/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.clientsort.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.terminalmc.clientsort.ClientSort;
import dev.terminalmc.clientsort.inventory.sort.SortMode;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Config {
    private static final Path DIR_PATH = Path.of("config", new String[0]);
    private static final String FILE_NAME = "clientsort.json";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public final Options options = new Options();
    private static Config instance = null;

    private void cleanup() {
    }

    public static Config get() {
        if (instance == null) {
            instance = Config.load();
        }
        return instance;
    }

    public static Config getAndSave() {
        Config.get();
        Config.save();
        return instance;
    }

    public static Config resetAndSave() {
        instance = new Config();
        Config.save();
        return instance;
    }

    @NotNull
    public static Config load() {
        Path file = DIR_PATH.resolve(FILE_NAME);
        Config config = null;
        if (Files.exists(file, new LinkOption[0])) {
            config = Config.load(file, GSON);
        }
        if (config == null) {
            config = new Config();
        }
        return config;
    }

    @Nullable
    private static Config load(Path file, Gson gson) {
        Config config;
        FileReader reader = new FileReader(file.toFile());
        try {
            config = (Config)gson.fromJson((Reader)reader, Config.class);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                ClientSort.LOG.error("Unable to load config.", e);
                return null;
            }
        }
        reader.close();
        return config;
    }

    public static void save() {
        if (instance == null) {
            return;
        }
        instance.cleanup();
        try {
            if (!Files.isDirectory(DIR_PATH, new LinkOption[0])) {
                Files.createDirectories(DIR_PATH, new FileAttribute[0]);
            }
            Path file = DIR_PATH.resolve(FILE_NAME);
            Path tempFile = file.resolveSibling(String.valueOf(file.getFileName()) + ".tmp");
            try (FileWriter writer = new FileWriter(tempFile.toFile());){
                writer.write(GSON.toJson((Object)instance));
            }
            catch (IOException e) {
                throw new IOException(e);
            }
            Files.move(tempFile, file, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
            ClientSort.onConfigSaved(instance);
        }
        catch (IOException e) {
            ClientSort.LOG.error("Unable to save config.", e);
        }
    }

    public static class Options {
        public static final int defaultInteractionRateServer = 10;
        public int interactionRateServer = 10;
        public static final int defaultInteractionRateClient = 1;
        public int interactionRateClient = 1;
        public static final HotbarMode defaultHotbarMode = HotbarMode.HARD;
        public HotbarMode hotbarMode = defaultHotbarMode;
        public static final String defaultSortMode = SortMode.CREATIVE.name;
        public String sortModeStr = defaultSortMode;
        public transient SortMode sortMode;
        public static final String defaultShiftSortMode = SortMode.QUANTITY.name;
        public String shiftSortModeStr = defaultShiftSortMode;
        public transient SortMode shiftSortMode;
        public static final String defaultCtrlSortMode = SortMode.ALPHABET.name;
        public String ctrlSortModeStr = defaultCtrlSortMode;
        public transient SortMode ctrlSortMode;
        public static final String defaultAltSortMode = SortMode.RAW_ID.name;
        public String altSortModeStr = defaultAltSortMode;
        public transient SortMode altSortMode;
        public static final boolean defaultOptimizedCreativeSorting = true;
        public boolean optimizedCreativeSorting = true;

        public static enum HotbarMode {
            NONE,
            HARD,
            SOFT;


            public String lowerName() {
                return switch (this.ordinal()) {
                    default -> throw new MatchException(null, null);
                    case 0 -> "merge";
                    case 1 -> "split";
                    case 2 -> "off";
                };
            }
        }
    }
}

