/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.clientsort.inventory.sort;

import dev.terminalmc.clientsort.inventory.ContainerScreenHelper;
import dev.terminalmc.clientsort.inventory.sort.SortContext;
import dev.terminalmc.clientsort.inventory.sort.SortMode;
import dev.terminalmc.clientsort.network.InteractionManager;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_465;

public class InventorySorter {
    private final ContainerScreenHelper<? extends class_465<?>> screenHelper;
    private final class_465<?> containerScreen;
    private class_1735[] inventorySlots;
    private final class_1799[] stacks;

    public InventorySorter(ContainerScreenHelper<? extends class_465<?>> screenHelper, class_465<?> containerScreen, class_1735 originSlot) {
        this.screenHelper = screenHelper;
        this.containerScreen = containerScreen;
        this.collectSlots(originSlot);
        this.stacks = new class_1799[this.inventorySlots.length];
        for (int i = 0; i < this.inventorySlots.length; ++i) {
            this.stacks[i] = this.inventorySlots[i].method_7677();
        }
    }

    private void collectSlots(class_1735 originSlot) {
        int originScope = this.screenHelper.getScope(originSlot);
        if (originScope == Integer.MAX_VALUE) {
            this.inventorySlots = new class_1735[0];
            return;
        }
        ArrayList<class_1735> slotsInScope = new ArrayList<class_1735>();
        for (class_1735 slot : this.containerScreen.method_17577().field_7761) {
            if (originScope != this.screenHelper.getScope(slot, true)) continue;
            slotsInScope.add(slot);
        }
        this.inventorySlots = slotsInScope.toArray(new class_1735[0]);
    }

    private void combineStacks() {
        ArrayDeque<InteractionManager.InteractionEvent> clickEvents = new ArrayDeque<InteractionManager.InteractionEvent>();
        for (int i = this.stacks.length - 1; i >= 0; --i) {
            int stackSize;
            class_1799 stack = this.stacks[i];
            if (stack.method_7960() || (stackSize = stack.method_7947()) >= stack.method_7909().method_7882()) continue;
            clickEvents.add(this.screenHelper.createClickEvent(this.inventorySlots[i], 0, class_1713.field_7790));
            for (int j = 0; j < i; ++j) {
                class_1799 targetStack = this.stacks[j];
                if (targetStack.method_7960() || targetStack.method_7947() >= targetStack.method_7909().method_7882() || !class_1799.method_31577((class_1799)stack, (class_1799)targetStack)) continue;
                int delta = targetStack.method_7909().method_7882() - targetStack.method_7947();
                delta = Math.min(delta, stackSize);
                targetStack.method_7939(targetStack.method_7947() + delta);
                clickEvents.add(this.screenHelper.createClickEvent(this.inventorySlots[j], 0, class_1713.field_7790));
                if ((stackSize -= delta) <= 0) break;
            }
            if (clickEvents.size() <= 1) {
                clickEvents.clear();
                continue;
            }
            InteractionManager.pushAll(clickEvents);
            InteractionManager.triggerSend(InteractionManager.TriggerType.GUI_CONFIRM);
            clickEvents.clear();
            if (stackSize > 0) {
                InteractionManager.push(this.screenHelper.createClickEvent(this.inventorySlots[i], 0, class_1713.field_7790));
                stack.method_7939(stackSize);
                continue;
            }
            this.stacks[i] = class_1799.field_8037;
        }
    }

    public void sort(SortMode sortMode) {
        if (this.inventorySlots.length <= 1) {
            return;
        }
        this.combineStacks();
        int[] sortIds = new int[this.stacks.length];
        for (int i = 0; i < sortIds.length; ++i) {
            sortIds[i] = i;
        }
        sortIds = sortMode.sort(sortIds, this.stacks, new SortContext(this.containerScreen, Arrays.asList(this.inventorySlots)));
        this.sortOnClient(sortIds);
    }

    protected void sortOnClient(int[] sortedIds) {
        int i;
        int slotCount = this.stacks.length;
        int[] origin2Target = new int[slotCount];
        for (int i2 = 0; i2 < origin2Target.length; ++i2) {
            origin2Target[sortedIds[i2]] = i2;
        }
        BitSet doneSlashEmpty = new BitSet(slotCount * 2);
        for (i = 0; i < slotCount; ++i) {
            if (i == sortedIds[i]) {
                doneSlashEmpty.set(i);
                continue;
            }
            if (!this.stacks[i].method_7960()) continue;
            doneSlashEmpty.set(slotCount + i);
        }
        block2: for (i = 0; i < slotCount; ++i) {
            if (doneSlashEmpty.get(i)) continue;
            if (doneSlashEmpty.get(slotCount + sortedIds[i])) {
                doneSlashEmpty.set(sortedIds[i]);
                continue;
            }
            InteractionManager.push(this.screenHelper.createClickEvent(this.inventorySlots[sortedIds[i]], 0, class_1713.field_7790));
            doneSlashEmpty.set(slotCount + sortedIds[i]);
            class_1799 currentStack = this.stacks[sortedIds[i]];
            class_1735 workingSlot = this.inventorySlots[sortedIds[i]];
            int id = i;
            do {
                if (this.stacks[id].method_7909() == currentStack.method_7909() && !doneSlashEmpty.get(slotCount + id) && class_1799.method_31577((class_1799)this.stacks[id], (class_1799)currentStack)) {
                    if (this.stacks[id].method_7947() == currentStack.method_7947()) {
                        doneSlashEmpty.set(id);
                        id = origin2Target[id];
                        continue;
                    }
                    if (currentStack.method_7947() < this.stacks[id].method_7947()) {
                        class_1735 targetSlot = this.inventorySlots[id];
                        InteractionManager.push(this.screenHelper.createClickEvent(workingSlot, 0, class_1713.field_7790));
                        InteractionManager.push(this.screenHelper.createClickEvent(targetSlot, 0, class_1713.field_7790));
                        InteractionManager.push(this.screenHelper.createClickEvent(workingSlot, 0, class_1713.field_7790));
                        InteractionManager.push(this.screenHelper.createClickEvent(targetSlot, 0, class_1713.field_7790));
                        InteractionManager.push(this.screenHelper.createClickEvent(workingSlot, 0, class_1713.field_7790));
                        currentStack = this.stacks[id];
                        doneSlashEmpty.set(id);
                        id = origin2Target[id];
                        continue;
                    }
                }
                InteractionManager.push(this.screenHelper.createClickEvent(this.inventorySlots[id], 0, class_1713.field_7790));
                currentStack = this.stacks[id];
                doneSlashEmpty.set(id);
                if (doneSlashEmpty.get(slotCount + id)) continue block2;
                id = origin2Target[id];
            } while (!doneSlashEmpty.get(id));
        }
    }
}

