/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2598;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.Logger;
import team.creative.creativecore.CreativeCore;
import team.creative.creativecore.common.network.CreativeNetworkClient;
import team.creative.creativecore.common.network.CreativeNetworkPacket;
import team.creative.creativecore.common.network.CreativePacket;

public class CreativeNetwork {
    public final class_2960 CHANNEL;
    private final HashMap<Class<? extends CreativePacket>, CreativeNetworkPacket> packetTypes = new HashMap();
    private final Logger logger;
    private final String modid;
    private int id = 0;

    public CreativeNetwork(int version, Logger logger, class_2960 location) {
        this.logger = logger;
        this.CHANNEL = location;
        this.modid = location.method_12836();
        this.logger.debug("Created network " + String.valueOf(location));
    }

    public <T extends CreativePacket> void registerType(Class<T> classType, Supplier<T> supplier) {
        CreativeNetworkPacket handler = new CreativeNetworkPacket(class_2960.method_43902((String)this.modid, (String)("" + this.id)), classType, supplier, true);
        PayloadTypeRegistry.playC2S().register(handler.sid, class_9139.method_56438((x, y) -> handler.write((Object)x, (class_9129)y, class_2598.field_11942), x -> {
            Object packet = handler.read((class_9129)x, class_2598.field_11942);
            ((CreativePacket)packet).setType(handler.sid);
            return packet;
        }));
        PayloadTypeRegistry.playS2C().register(handler.sid, class_9139.method_56438((x, y) -> handler.write((Object)x, (class_9129)y, class_2598.field_11941), x -> {
            Object packet = handler.read((class_9129)x, class_2598.field_11941);
            ((CreativePacket)packet).setType(handler.sid);
            return packet;
        }));
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            CreativeNetworkClient.registerClientType(handler);
        }
        ServerPlayNetworking.registerGlobalReceiver(handler.sid, (payload, context) -> {
            try {
                context.player().method_5682().execute(() -> payload.executeServer(context.player()));
            }
            catch (Exception e) {
                CreativeCore.LOGGER.error("Failed to handle packet " + String.valueOf(handler.sid.comp_2242()), (Throwable)e);
            }
        });
        this.packetTypes.put(classType, handler);
        ++this.id;
    }

    public CreativeNetworkPacket getPacketType(Class<? extends CreativePacket> clazz) {
        return this.packetTypes.get(clazz);
    }

    protected <T extends CreativePacket> T prepare(T packet, class_2598 flow) {
        packet.setType(this.packetTypes.get(packet.getClass()).sid);
        return packet;
    }

    public void sendToServer(CreativePacket message) {
        ClientPlayNetworking.send((class_8710)this.prepare(message, class_2598.field_11942));
    }

    public void sendToClient(CreativePacket message, class_3222 player) {
        ServerPlayNetworking.send((class_3222)player, (class_8710)this.prepare(message, class_2598.field_11941));
    }

    public void sendToClientAll(MinecraftServer server, CreativePacket message) {
        this.prepare(message, class_2598.field_11941);
        for (class_3222 player : PlayerLookup.all((MinecraftServer)server)) {
            ServerPlayNetworking.send((class_3222)player, (class_8710)message);
        }
    }
}

