/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.dataObjects.render.bufferBuilding;

import com.seibel.distanthorizons.api.enums.rendering.EDhApiDebugRendering;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.dataObjects.render.ColumnRenderSource;
import com.seibel.distanthorizons.core.dataObjects.render.bufferBuilding.ColumnRenderBuffer;
import com.seibel.distanthorizons.core.dataObjects.render.bufferBuilding.CubicLodTemplate;
import com.seibel.distanthorizons.core.dataObjects.render.bufferBuilding.LodQuadBuilder;
import com.seibel.distanthorizons.core.dataObjects.render.columnViews.ColumnArrayView;
import com.seibel.distanthorizons.core.enums.EDhDirection;
import com.seibel.distanthorizons.core.level.IDhClientLevel;
import com.seibel.distanthorizons.core.logging.ConfigBasedLogger;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhBlockPos;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import com.seibel.distanthorizons.core.render.glObject.GLProxy;
import com.seibel.distanthorizons.core.render.glObject.buffer.GLVertexBuffer;
import com.seibel.distanthorizons.core.util.LodUtil;
import com.seibel.distanthorizons.core.util.RenderDataPointUtil;
import com.seibel.distanthorizons.core.util.objects.UncheckedInterruptedException;
import com.seibel.distanthorizons.core.util.threading.ThreadPoolUtil;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ColumnRenderBufferBuilder {
    public static final ConfigBasedLogger EVENT_LOGGER = new ConfigBasedLogger(LogManager.getLogger(), () -> Config.Client.Advanced.Logging.logRendererBufferEvent.get());
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    public static final int MAX_NUMBER_OF_CONCURRENT_CALLS_PER_THREAD = 3;
    public static int maxNumberOfConcurrentCalls = 3;

    public static CompletableFuture<ColumnRenderBuffer> buildAndUploadBuffersAsync(IDhClientLevel clientLevel, ColumnRenderSource renderSource, ColumnRenderSource[] adjData) {
        ThreadPoolExecutor bufferBuilderExecutor = ThreadPoolUtil.getBufferBuilderExecutor();
        ThreadPoolExecutor bufferUploaderExecutor = ThreadPoolUtil.getBufferUploaderExecutor();
        if (bufferBuilderExecutor == null || bufferBuilderExecutor.isTerminated() || bufferUploaderExecutor == null || bufferUploaderExecutor.isTerminated()) {
            CompletableFuture<ColumnRenderBuffer> future = new CompletableFuture<ColumnRenderBuffer>();
            future.cancel(true);
            return future;
        }
        try {
            return CompletableFuture.supplyAsync(() -> {
                try {
                    boolean enableTransparency = Config.Client.Advanced.Graphics.Quality.transparency.get().transparencyEnabled;
                    boolean enableSkyLightCulling = Config.Client.Advanced.Graphics.AdvancedGraphics.enableCaveCulling.get() != false && !clientLevel.getLevelWrapper().hasCeiling() && !clientLevel.getLevelWrapper().getDimensionType().isTheEnd() && DhSectionPos.getDetailLevel(renderSource.pos) == 6;
                    int skyLightCullingBelow = Config.Client.Advanced.Graphics.AdvancedGraphics.caveCullingHeight.get();
                    skyLightCullingBelow = Math.max(skyLightCullingBelow, clientLevel.getMinY());
                    long builderStartTime = System.currentTimeMillis();
                    LodQuadBuilder builder = new LodQuadBuilder(enableSkyLightCulling, (short)(skyLightCullingBelow - clientLevel.getMinY()), enableTransparency, clientLevel.getClientLevelWrapper());
                    ColumnRenderBufferBuilder.makeLodRenderData(builder, renderSource, adjData);
                    long builderEndTime = System.currentTimeMillis();
                    long buildMs = builderEndTime - builderStartTime;
                    LOGGER.debug("RenderRegion end QuadBuild @ " + renderSource.pos + " took: " + buildMs);
                    return builder;
                }
                catch (UncheckedInterruptedException e) {
                    throw e;
                }
                catch (Throwable e3) {
                    LOGGER.error("\"LodNodeBufferBuilder\" was unable to build quads: ", e3);
                    throw e3;
                }
            }, bufferBuilderExecutor).thenApplyAsync(quadBuilder -> {
                try {
                    ColumnRenderBuffer buffer = new ColumnRenderBuffer(new DhBlockPos(DhSectionPos.getMinCornerBlockX(renderSource.pos), clientLevel.getMinY(), DhSectionPos.getMinCornerBlockZ(renderSource.pos)));
                    try {
                        buffer.uploadBuffer((LodQuadBuilder)quadBuilder, GLProxy.getInstance().getGpuUploadMethod());
                        LodUtil.assertTrue(buffer.buffersUploaded);
                        return buffer;
                    }
                    catch (Exception e) {
                        buffer.close();
                        throw e;
                    }
                }
                catch (InterruptedException e) {
                    throw UncheckedInterruptedException.convert(e);
                }
                catch (Throwable e3) {
                    LOGGER.error("LodNodeBufferBuilder was unable to upload buffer: " + e3.getMessage(), e3);
                    throw e3;
                }
            }, (Executor)bufferUploaderExecutor);
        }
        catch (RejectedExecutionException ignore) {
            CompletableFuture<ColumnRenderBuffer> future = new CompletableFuture<ColumnRenderBuffer>();
            future.cancel(true);
            return future;
        }
    }

    private static void makeLodRenderData(LodQuadBuilder quadBuilder, ColumnRenderSource renderSource, ColumnRenderSource[] adjRegions) {
        EDhApiDebugRendering debugMode = Config.Client.Advanced.Debugging.debugRendering.get();
        boolean enableColumnBufferLimit = Config.Client.Advanced.Debugging.columnBuilderDebugEnable.get();
        if (enableColumnBufferLimit) {
            if (DhSectionPos.getDetailLevel(renderSource.pos) == Config.Client.Advanced.Debugging.columnBuilderDebugDetailLevel.get() && DhSectionPos.getX(renderSource.pos) == Config.Client.Advanced.Debugging.columnBuilderDebugXPos.get() && DhSectionPos.getZ(renderSource.pos) == Config.Client.Advanced.Debugging.columnBuilderDebugZPos.get()) {
                boolean bl = false;
            } else {
                return;
            }
        }
        byte detailLevel = renderSource.getDataDetailLevel();
        for (int x = 0; x < ColumnRenderSource.SECTION_SIZE; ++x) {
            for (int z = 0; z < ColumnRenderSource.SECTION_SIZE; ++z) {
                long data;
                UncheckedInterruptedException.throwIfInterrupted();
                ColumnArrayView columnRenderData = renderSource.getVerticalDataPointView(x, z);
                if (columnRenderData.size() == 0 || !RenderDataPointUtil.doesDataPointExist(columnRenderData.get(0)) || RenderDataPointUtil.isVoid(columnRenderData.get(0))) continue;
                ColumnRenderSource.DebugSourceFlag debugSourceFlag = renderSource.debugGetFlag(x, z);
                ColumnArrayView[][] adjColumnViews = new ColumnArrayView[4][];
                for (EDhDirection lodDirection : EDhDirection.ADJ_DIRECTIONS) {
                    try {
                        byte adjDetailLevel;
                        ColumnRenderSource adjRenderSource;
                        boolean isCrossRegionBoundary;
                        int xAdj = x + lodDirection.getNormal().x;
                        int zAdj = z + lodDirection.getNormal().z;
                        boolean bl = isCrossRegionBoundary = xAdj < 0 || xAdj >= ColumnRenderSource.SECTION_SIZE || zAdj < 0 || zAdj >= ColumnRenderSource.SECTION_SIZE;
                        if (isCrossRegionBoundary) {
                            adjRenderSource = adjRegions[lodDirection.ordinal() - 2];
                            if (adjRenderSource == null) continue;
                            adjDetailLevel = adjRenderSource.getDataDetailLevel();
                            if (adjDetailLevel == detailLevel) {
                                if (xAdj < 0) {
                                    xAdj += ColumnRenderSource.SECTION_SIZE;
                                }
                                if (zAdj < 0) {
                                    zAdj += ColumnRenderSource.SECTION_SIZE;
                                }
                                if (xAdj >= ColumnRenderSource.SECTION_SIZE) {
                                    xAdj -= ColumnRenderSource.SECTION_SIZE;
                                }
                                if (zAdj >= ColumnRenderSource.SECTION_SIZE) {
                                    zAdj -= ColumnRenderSource.SECTION_SIZE;
                                }
                            }
                        } else {
                            adjRenderSource = renderSource;
                            adjDetailLevel = detailLevel;
                        }
                        if (adjDetailLevel < detailLevel - 1 || adjDetailLevel > detailLevel + 1) continue;
                        if (adjDetailLevel == detailLevel || adjDetailLevel > detailLevel) {
                            adjColumnViews[lodDirection.ordinal() - 2] = new ColumnArrayView[1];
                            adjColumnViews[lodDirection.ordinal() - 2][0] = adjRenderSource.getVerticalDataPointView(xAdj, zAdj);
                            continue;
                        }
                        adjColumnViews[lodDirection.ordinal() - 2] = new ColumnArrayView[2];
                        adjColumnViews[lodDirection.ordinal() - 2][0] = adjRenderSource.getVerticalDataPointView(xAdj, zAdj);
                        adjColumnViews[lodDirection.ordinal() - 2][1] = adjRenderSource.getVerticalDataPointView(xAdj + (lodDirection.getAxis() == EDhDirection.Axis.X ? 0 : 1), zAdj + (lodDirection.getAxis() == EDhDirection.Axis.Z ? 0 : 1));
                    }
                    catch (RuntimeException e) {
                        EVENT_LOGGER.warn("Failed to get adj data for [" + detailLevel + ":" + x + "," + z + "] at [" + (Object)((Object)lodDirection) + "], Error: " + e.getMessage(), e);
                    }
                }
                for (int i = 0; i < columnRenderData.size() && !RenderDataPointUtil.isVoid(data = columnRenderData.get(i)) && RenderDataPointUtil.doesDataPointExist(data); ++i) {
                    long topDataPoint = i - 1 >= 0 ? columnRenderData.get(i - 1) : 0L;
                    long bottomDataPoint = i + 1 < columnRenderData.size() ? columnRenderData.get(i + 1) : 0L;
                    CubicLodTemplate.addLodToBuffer(data, topDataPoint, bottomDataPoint, adjColumnViews, detailLevel, x, z, quadBuilder, debugMode, debugSourceFlag);
                }
            }
        }
        quadBuilder.finalizeData();
    }

    public static GLVertexBuffer[] resizeBuffer(GLVertexBuffer[] vbos, int newSize) {
        if (vbos.length == newSize) {
            return vbos;
        }
        GLVertexBuffer[] newVbos = new GLVertexBuffer[newSize];
        System.arraycopy(vbos, 0, newVbos, 0, Math.min(vbos.length, newSize));
        if (newSize < vbos.length) {
            for (int i = newSize; i < vbos.length; ++i) {
                if (vbos[i] == null) continue;
                vbos[i].close();
            }
        }
        return newVbos;
    }
}

