/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.enums;

import com.seibel.distanthorizons.coreapi.util.math.Vec3i;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public enum EDhDirection {
    DOWN(0, 1, -1, "down", AxisDirection.NEGATIVE, Axis.Y, new Vec3i(0, -1, 0)),
    UP(1, 0, -1, "up", AxisDirection.POSITIVE, Axis.Y, new Vec3i(0, 1, 0)),
    NORTH(2, 3, 2, "north", AxisDirection.NEGATIVE, Axis.Z, new Vec3i(0, 0, -1)),
    SOUTH(3, 2, 0, "south", AxisDirection.POSITIVE, Axis.Z, new Vec3i(0, 0, 1)),
    WEST(4, 5, 1, "west", AxisDirection.NEGATIVE, Axis.X, new Vec3i(-1, 0, 0)),
    EAST(5, 4, 3, "east", AxisDirection.POSITIVE, Axis.X, new Vec3i(1, 0, 0));

    public static final EDhDirection[] CARDINAL_DIRECTIONS;
    public static final EDhDirection[] OPPOSITE_DIRECTIONS;
    public static final EDhDirection[] ADJ_DIRECTIONS;
    private final String name;
    private final Axis axis;
    private final AxisDirection axisDirection;
    private final Vec3i normal;
    private static final EDhDirection[] VALUES;
    private static final Map<String, EDhDirection> BY_NAME;

    private EDhDirection(int p_i46016_3_, int p_i46016_4_, int p_i46016_5_, String p_i46016_6_, AxisDirection p_i46016_7_, Axis p_i46016_8_, Vec3i p_i46016_9_) {
        this.name = p_i46016_6_;
        this.axis = p_i46016_8_;
        this.axisDirection = p_i46016_7_;
        this.normal = p_i46016_9_;
    }

    public AxisDirection getAxisDirection() {
        return this.axisDirection;
    }

    public EDhDirection getClockWise() {
        switch (this.ordinal()) {
            case 2: {
                return EAST;
            }
            case 3: {
                return WEST;
            }
            case 4: {
                return NORTH;
            }
            case 5: {
                return SOUTH;
            }
        }
        throw new IllegalStateException("Unable to get Y-rotated facing of " + (Object)((Object)this));
    }

    public EDhDirection getCounterClockWise() {
        switch (this.ordinal()) {
            case 2: {
                return WEST;
            }
            case 3: {
                return EAST;
            }
            case 4: {
                return SOUTH;
            }
            case 5: {
                return NORTH;
            }
        }
        throw new IllegalStateException("Unable to get CCW facing of " + (Object)((Object)this));
    }

    public String getName() {
        return this.name;
    }

    public Axis getAxis() {
        return this.axis;
    }

    public static EDhDirection byName(String name) {
        return name == null ? null : BY_NAME.get(name.toLowerCase(Locale.ROOT));
    }

    public static EDhDirection fromAxisAndDirection(Axis p_211699_0_, AxisDirection p_211699_1_) {
        switch (p_211699_0_.ordinal()) {
            case 0: {
                return p_211699_1_ == AxisDirection.POSITIVE ? EAST : WEST;
            }
            case 1: {
                return p_211699_1_ == AxisDirection.POSITIVE ? UP : DOWN;
            }
        }
        return p_211699_1_ == AxisDirection.POSITIVE ? SOUTH : NORTH;
    }

    public static EDhDirection get(AxisDirection p_181076_0_, Axis p_181076_1_) {
        for (EDhDirection lodDirection : VALUES) {
            if (lodDirection.getAxisDirection() != p_181076_0_ || lodDirection.getAxis() != p_181076_1_) continue;
            return lodDirection;
        }
        throw new IllegalArgumentException("No such direction: " + (Object)((Object)p_181076_0_) + " " + p_181076_1_);
    }

    public Vec3i getNormal() {
        return this.normal;
    }

    public String getSerializedName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    static {
        CARDINAL_DIRECTIONS = new EDhDirection[]{UP, DOWN, WEST, EAST, NORTH, SOUTH};
        OPPOSITE_DIRECTIONS = new EDhDirection[]{UP, DOWN, SOUTH, NORTH, EAST, WEST};
        ADJ_DIRECTIONS = new EDhDirection[]{EAST, WEST, SOUTH, NORTH};
        VALUES = EDhDirection.values();
        BY_NAME = Arrays.stream(VALUES).collect(Collectors.toMap(EDhDirection::getName, p_199787_0_ -> p_199787_0_));
    }

    public static enum Axis implements Predicate<EDhDirection>
    {
        X("x"){

            @Override
            public int choose(int x, int y, int z) {
                return x;
            }

            @Override
            public double choose(double x, double y, double z) {
                return x;
            }
        }
        ,
        Y("y"){

            @Override
            public int choose(int x, int y, int z) {
                return y;
            }

            @Override
            public double choose(double x, double y, double z) {
                return y;
            }
        }
        ,
        Z("z"){

            @Override
            public int choose(int x, int y, int z) {
                return z;
            }

            @Override
            public double choose(double x, double y, double z) {
                return z;
            }
        };

        private static final Axis[] VALUES;
        private static final Map<String, Axis> BY_NAME;
        private final String name;

        private Axis(String name) {
            this.name = name;
        }

        public static Axis byName(String name) {
            return BY_NAME.get(name.toLowerCase(Locale.ROOT));
        }

        public String getName() {
            return this.name;
        }

        public boolean isVertical() {
            return this == Y;
        }

        public boolean isHorizontal() {
            return this == X || this == Z;
        }

        public String toString() {
            return this.name;
        }

        @Override
        public boolean test(EDhDirection p_test_1_) {
            return p_test_1_ != null && p_test_1_.getAxis() == this;
        }

        public abstract int choose(int var1, int var2, int var3);

        public abstract double choose(double var1, double var3, double var5);

        static {
            VALUES = Axis.values();
            BY_NAME = Arrays.stream(VALUES).collect(Collectors.toMap(Axis::getName, p_199785_0_ -> p_199785_0_));
        }
    }

    public static enum AxisDirection {
        POSITIVE(1, "Towards positive"),
        NEGATIVE(-1, "Towards negative");

        private final int step;
        private final String name;

        private AxisDirection(int newStep, String newName) {
            this.step = newStep;
            this.name = newName;
        }

        public int getStep() {
            return this.step;
        }

        public String toString() {
            return this.name;
        }

        public AxisDirection opposite() {
            return this == POSITIVE ? NEGATIVE : POSITIVE;
        }
    }
}

