/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.generation;

import com.seibel.distanthorizons.core.enums.EDhDirection;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhBlockPos;
import com.seibel.distanthorizons.core.pos.DhChunkPos;
import com.seibel.distanthorizons.core.wrapperInterfaces.block.IBlockStateWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.chunk.IChunkWrapper;
import com.seibel.distanthorizons.coreapi.util.BitShiftUtil;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Queue;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class DhLightingEngine {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    public static final DhLightingEngine INSTANCE = new DhLightingEngine();
    private static final ThreadLocal<DhBlockPos> PRIMARY_BLOCK_POS_REF = ThreadLocal.withInitial(() -> new DhBlockPos());
    private static final ThreadLocal<DhBlockPos> SECONDARY_BLOCK_POS_REF = ThreadLocal.withInitial(() -> new DhBlockPos());

    private DhLightingEngine() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lightChunk(@NotNull IChunkWrapper centerChunk, @NotNull ArrayList<IChunkWrapper> nearbyChunkList, int maxSkyLight) {
        DhChunkPos centerChunkPos = centerChunk.getChunkPos();
        AdjacentChunkHolder adjacentChunkHolder = new AdjacentChunkHolder(centerChunk);
        long startTimeNs = System.nanoTime();
        StableLightPosStack blockLightPosQueue = null;
        StableLightPosStack skyLightPosQueue = null;
        try {
            blockLightPosQueue = StableLightPosStack.borrowStableLightPosArray();
            skyLightPosQueue = StableLightPosStack.borrowStableLightPosArray();
            HashSet<DhChunkPos> requestedAdjacentPositions = new HashSet<DhChunkPos>(9);
            for (int xOffset = -1; xOffset <= 1; ++xOffset) {
                for (int zOffset = -1; zOffset <= 1; ++zOffset) {
                    DhChunkPos adjacentPos = new DhChunkPos(centerChunkPos.x + xOffset, centerChunkPos.z + zOffset);
                    requestedAdjacentPositions.add(adjacentPos);
                }
            }
            boolean warningLogged = false;
            for (int chunkIndex = 0; chunkIndex < nearbyChunkList.size(); ++chunkIndex) {
                IChunkWrapper chunk = nearbyChunkList.get(chunkIndex);
                if (chunk != null && requestedAdjacentPositions.contains(chunk.getChunkPos())) {
                    requestedAdjacentPositions.remove(chunk.getChunkPos());
                    adjacentChunkHolder.add(chunk);
                    DhBlockPos relLightBlockPos = PRIMARY_BLOCK_POS_REF.get();
                    DhBlockPos relBlockPos2 = SECONDARY_BLOCK_POS_REF.get();
                    ArrayList<DhBlockPos> blockLightPosList = chunk.getBlockLightPosList();
                    for (int blockLightIndex = 0; blockLightIndex < blockLightPosList.size(); ++blockLightIndex) {
                        DhBlockPos blockLightPos = blockLightPosList.get(blockLightIndex);
                        blockLightPos.mutateToChunkRelativePos(relLightBlockPos);
                        IBlockStateWrapper blockState = chunk.getBlockState(relLightBlockPos);
                        int lightValue = blockState.getLightEmission();
                        blockLightPosQueue.push(blockLightPos.x, blockLightPos.y, blockLightPos.z, lightValue);
                        blockLightPos.mutateToChunkRelativePos(relBlockPos2);
                        chunk.setDhBlockLight(relBlockPos2.x, relBlockPos2.y, relBlockPos2.z, lightValue);
                    }
                    if (maxSkyLight > 0) {
                        int maxY = chunk.getMaxNonEmptyHeight();
                        int minY = chunk.getMinBuildHeight();
                        for (int relX = 0; relX < 16; ++relX) {
                            for (int relZ = 0; relZ < 16; ++relZ) {
                                IBlockStateWrapper block;
                                for (int y = maxY; y >= minY && ((block = chunk.getBlockState(relX, y, relZ)) == null || block.getOpacity() == 0); --y) {
                                    DhBlockPos skyLightPos = new DhBlockPos(chunk.getMinBlockX() + relX, y, chunk.getMinBlockZ() + relZ);
                                    skyLightPosQueue.push(skyLightPos.x, skyLightPos.y, skyLightPos.z, maxSkyLight);
                                    skyLightPos.mutateToChunkRelativePos(relBlockPos2);
                                    chunk.setDhSkyLight(relBlockPos2.x, relBlockPos2.y, relBlockPos2.z, maxSkyLight);
                                }
                            }
                        }
                    }
                }
                if (requestedAdjacentPositions.isEmpty()) break;
            }
            this.propagateLightPosList(blockLightPosQueue, adjacentChunkHolder, (neighbourChunk, relBlockPos) -> neighbourChunk.getDhBlockLight(relBlockPos.x, relBlockPos.y, relBlockPos.z), (neighbourChunk, relBlockPos, newLightValue) -> neighbourChunk.setDhBlockLight(relBlockPos.x, relBlockPos.y, relBlockPos.z, newLightValue));
            this.propagateLightPosList(skyLightPosQueue, adjacentChunkHolder, (neighbourChunk, relBlockPos) -> neighbourChunk.getDhSkyLight(relBlockPos.x, relBlockPos.y, relBlockPos.z), (neighbourChunk, relBlockPos, newLightValue) -> neighbourChunk.setDhSkyLight(relBlockPos.x, relBlockPos.y, relBlockPos.z, newLightValue));
        }
        catch (Exception e) {
            LOGGER.error("Unexpected lighting issue for center chunk: " + centerChunkPos, (Throwable)e);
        }
        finally {
            StableLightPosStack.returnStableLightPosArray(blockLightPosQueue);
            StableLightPosStack.returnStableLightPosArray(skyLightPosQueue);
        }
        centerChunk.setIsDhLightCorrect(true);
        centerChunk.setUseDhLighting(true);
        long endTimeNs = System.nanoTime();
        float totalTimeMs = (float)(endTimeNs - startTimeNs) / 1000000.0f;
    }

    private void propagateLightPosList(StableLightPosStack lightPosQueue, AdjacentChunkHolder adjacentChunkHolder, IGetLightFunc getLightFunc, ISetLightFunc setLightFunc) {
        LightPos lightPos = new LightPos(0, 0, 0, 0);
        DhBlockPos neighbourBlockPos = PRIMARY_BLOCK_POS_REF.get();
        DhBlockPos relNeighbourBlockPos = SECONDARY_BLOCK_POS_REF.get();
        while (!lightPosQueue.isEmpty()) {
            lightPosQueue.popMutate(lightPos);
            int lightValue = lightPos.lightValue;
            for (EDhDirection direction : EDhDirection.CARDINAL_DIRECTIONS) {
                IBlockStateWrapper neighbourBlockState;
                int targetLevel;
                int currentBlockLight;
                lightPos.mutateOffset(direction, neighbourBlockPos);
                neighbourBlockPos.mutateToChunkRelativePos(relNeighbourBlockPos);
                IChunkWrapper neighbourChunk = adjacentChunkHolder.getByBlockPos(neighbourBlockPos.x, neighbourBlockPos.z);
                if (neighbourChunk == null || relNeighbourBlockPos.y < neighbourChunk.getMinNonEmptyHeight() || relNeighbourBlockPos.y > neighbourChunk.getMaxBuildHeight() || (currentBlockLight = getLightFunc.getLight(neighbourChunk, relNeighbourBlockPos)) >= lightValue - 1 || (targetLevel = lightValue - Math.max(1, (neighbourBlockState = neighbourChunk.getBlockState(relNeighbourBlockPos)).getOpacity())) <= currentBlockLight) continue;
                setLightFunc.setLight(neighbourChunk, relNeighbourBlockPos, targetLevel);
                lightPosQueue.push(neighbourBlockPos.x, neighbourBlockPos.y, neighbourBlockPos.z, targetLevel);
            }
        }
    }

    private static class AdjacentChunkHolder {
        final IChunkWrapper[] chunkArray = new IChunkWrapper[9];

        public AdjacentChunkHolder(IChunkWrapper centerWrapper) {
            this.chunkArray[4] = centerWrapper;
        }

        public void add(IChunkWrapper centerWrapper) {
            DhChunkPos centerPos = this.chunkArray[4].getChunkPos();
            DhChunkPos offsetPos = centerWrapper.getChunkPos();
            int offsetX = offsetPos.x - centerPos.x;
            if (offsetX < -1 || offsetX > 1) {
                return;
            }
            int offsetZ = offsetPos.z - centerPos.z;
            if (offsetZ < -1 || offsetZ > 1) {
                return;
            }
            this.chunkArray[4 + offsetX + offsetZ + (offsetZ << 1)] = centerWrapper;
        }

        public IChunkWrapper getByBlockPos(int blockX, int blockZ) {
            int chunkX = BitShiftUtil.divideByPowerOfTwo(blockX, 4);
            int chunkZ = BitShiftUtil.divideByPowerOfTwo(blockZ, 4);
            IChunkWrapper centerChunk = this.chunkArray[4];
            DhChunkPos centerPos = centerChunk.getChunkPos();
            if (centerPos.x == chunkX && centerPos.z == chunkZ) {
                return centerChunk;
            }
            int offsetX = chunkX - centerPos.x;
            if (offsetX < -1 || offsetX > 1) {
                return null;
            }
            int offsetZ = chunkZ - centerPos.z;
            if (offsetZ < -1 || offsetZ > 1) {
                return null;
            }
            return this.chunkArray[4 + offsetX + offsetZ + (offsetZ << 1)];
        }
    }

    private static class StableLightPosStack {
        private static final ReentrantLock cacheLock = new ReentrantLock();
        private static final Queue<StableLightPosStack> lightArrayCache = new ArrayDeque<StableLightPosStack>();
        private int index = -1;
        public static final int INTS_PER_LIGHT_POS = 4;
        private final IntArrayList lightPositions = new IntArrayList(160000);

        private StableLightPosStack() {
        }

        private static StableLightPosStack borrowStableLightPosArray() {
            try {
                cacheLock.lock();
                StableLightPosStack stableLightPosStack = lightArrayCache.isEmpty() ? new StableLightPosStack() : lightArrayCache.remove();
                return stableLightPosStack;
            }
            finally {
                cacheLock.unlock();
            }
        }

        private static void returnStableLightPosArray(StableLightPosStack stableArray) {
            try {
                cacheLock.lock();
                if (stableArray != null) {
                    lightArrayCache.add(stableArray);
                }
            }
            finally {
                cacheLock.unlock();
            }
        }

        public boolean isEmpty() {
            return this.index == -1;
        }

        public int size() {
            return this.index + 1;
        }

        public void push(int blockX, int blockY, int blockZ, int lightValue) {
            ++this.index;
            int subIndex = this.index * 4;
            if (subIndex < this.lightPositions.size()) {
                this.lightPositions.set(subIndex, blockX);
                this.lightPositions.set(subIndex + 1, blockY);
                this.lightPositions.set(subIndex + 2, blockZ);
                this.lightPositions.set(subIndex + 3, lightValue);
            } else {
                this.lightPositions.add(blockX);
                this.lightPositions.add(blockY);
                this.lightPositions.add(blockZ);
                this.lightPositions.add(lightValue);
            }
        }

        public void popMutate(LightPos pos) {
            int subIndex = this.index * 4;
            pos.x = this.lightPositions.getInt(subIndex);
            pos.y = this.lightPositions.getInt(subIndex + 1);
            pos.z = this.lightPositions.getInt(subIndex + 2);
            pos.lightValue = this.lightPositions.getInt(subIndex + 3);
            --this.index;
        }

        public String toString() {
            return this.index + "/" + this.lightPositions.size() / 4;
        }
    }

    @FunctionalInterface
    static interface IGetLightFunc {
        public int getLight(IChunkWrapper var1, DhBlockPos var2);
    }

    @FunctionalInterface
    static interface ISetLightFunc {
        public void setLight(IChunkWrapper var1, DhBlockPos var2, int var3);
    }

    private static class LightPos
    extends DhBlockPos {
        public int lightValue;

        public LightPos(int x, int y, int z, int lightValue) {
            super(x, y, z);
            this.lightValue = lightValue;
        }
    }
}

