/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers;

import com.seibel.distanthorizons.api.interfaces.block.IDhApiBiomeWrapper;
import com.seibel.distanthorizons.api.interfaces.block.IDhApiBlockStateWrapper;
import com.seibel.distanthorizons.api.interfaces.world.IDhApiLevelWrapper;
import com.seibel.distanthorizons.core.level.IDhLevel;
import com.seibel.distanthorizons.core.level.IDhServerLevel;
import com.seibel.distanthorizons.core.util.LodUtil;
import com.seibel.distanthorizons.core.wrapperInterfaces.IWrapperFactory;
import com.seibel.distanthorizons.core.wrapperInterfaces.block.IBlockStateWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.chunk.IChunkWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IBiomeWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.ILevelWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.worldGeneration.AbstractBatchGenerationEnvironmentWrapper;
import java.io.IOException;
import java.util.HashSet;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.block.BiomeWrapper;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.block.BlockStateWrapper;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.chunk.ChunkWrapper;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.world.ClientLevelWrapper;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.world.ServerLevelWrapper;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.worldGeneration.BatchGenerationEnvironment;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;

public class WrapperFactory
implements IWrapperFactory {
    public static final WrapperFactory INSTANCE = new WrapperFactory();

    @Override
    public AbstractBatchGenerationEnvironmentWrapper createBatchGenerator(IDhLevel targetLevel) {
        if (targetLevel instanceof IDhServerLevel) {
            return new BatchGenerationEnvironment((IDhServerLevel)targetLevel);
        }
        throw new IllegalArgumentException("The target level must be a server-side level.");
    }

    @Override
    public IBiomeWrapper deserializeBiomeWrapper(String str, ILevelWrapper levelWrapper) throws IOException {
        return BiomeWrapper.deserialize(str, levelWrapper);
    }

    @Override
    public IBiomeWrapper getPlainsBiomeWrapper(ILevelWrapper levelWrapper) {
        try {
            return BiomeWrapper.deserialize("minecraft:plains", levelWrapper);
        }
        catch (IOException e) {
            throw new LodUtil.AssertFailureException("Unable to parse plains resource string [minecraft:plains], error:\n " + e.getMessage());
        }
    }

    @Override
    public IBlockStateWrapper deserializeBlockStateWrapper(String str, ILevelWrapper levelWrapper) throws IOException {
        return BlockStateWrapper.deserialize(str, levelWrapper);
    }

    @Override
    public IBlockStateWrapper getAirBlockStateWrapper() {
        return BlockStateWrapper.AIR;
    }

    @Override
    public HashSet<IBlockStateWrapper> getRendererIgnoredBlocks(ILevelWrapper levelWrapper) {
        return BlockStateWrapper.getRendererIgnoredBlocks(levelWrapper);
    }

    @Override
    public IChunkWrapper createChunkWrapper(Object[] objectArray) throws ClassCastException {
        if (objectArray.length == 1 && objectArray[0] instanceof IChunkWrapper) {
            try {
                return (IChunkWrapper)objectArray[0];
            }
            catch (Exception e) {
                throw new ClassCastException(WrapperFactory.createChunkWrapperErrorMessage(objectArray));
            }
        }
        if (objectArray.length == 2) {
            ILevelWrapper levelWrapper;
            Level level;
            if (!(objectArray[0] instanceof ChunkAccess)) {
                throw new ClassCastException(WrapperFactory.createChunkWrapperErrorMessage(objectArray));
            }
            ChunkAccess chunk = (ChunkAccess)objectArray[0];
            if (!(objectArray[1] instanceof Level)) {
                throw new ClassCastException(WrapperFactory.createChunkWrapperErrorMessage(objectArray));
            }
            Level lightSource = level = (Level)objectArray[1];
            if (level instanceof ServerLevel) {
                levelWrapper = ServerLevelWrapper.getWrapper((ServerLevel)level);
            } else if (level instanceof ClientLevel) {
                levelWrapper = ClientLevelWrapper.getWrapper((ClientLevel)level);
            } else {
                throw new ClassCastException(WrapperFactory.createChunkWrapperErrorMessage(objectArray));
            }
            return new ChunkWrapper(chunk, (LevelReader)lightSource, levelWrapper);
        }
        throw new ClassCastException(WrapperFactory.createChunkWrapperErrorMessage(objectArray));
    }

    private static String createChunkWrapperErrorMessage(Object[] objectArray) {
        String[] expectedClassNames = new String[]{ChunkAccess.class.getName(), ServerLevel.class.getName() + "] or [" + ClientLevel.class.getName()};
        return WrapperFactory.createWrapperErrorMessage("Chunk wrapper", expectedClassNames, objectArray);
    }

    @Override
    public IDhApiBiomeWrapper getBiomeWrapper(Object[] objectArray, IDhApiLevelWrapper levelWrapper) {
        if (!(levelWrapper instanceof ILevelWrapper)) {
            throw new ClassCastException("Unable to cast... only DH provided IDhApiLevelWrapper's can be used.");
        }
        ILevelWrapper coreLevelWrapper = (ILevelWrapper)levelWrapper;
        if (!(objectArray[0] instanceof Holder) || !(((Holder)objectArray[0]).value() instanceof Biome)) {
            throw new ClassCastException(WrapperFactory.createBiomeWrapperErrorMessage(objectArray));
        }
        Holder biomeHolder = (Holder)objectArray[0];
        return BiomeWrapper.getBiomeWrapper((Holder<Biome>)biomeHolder, coreLevelWrapper);
    }

    private static String createBiomeWrapperErrorMessage(Object[] objectArray) {
        String[] expectedClassNames = new String[]{Holder.class.getName() + "<" + Biome.class.getName() + ">"};
        return WrapperFactory.createWrapperErrorMessage("Biome wrapper", expectedClassNames, objectArray);
    }

    @Override
    public IDhApiBlockStateWrapper getBlockStateWrapper(Object[] objectArray, IDhApiLevelWrapper levelWrapper) {
        if (!(levelWrapper instanceof ILevelWrapper)) {
            throw new ClassCastException("Unable to cast... only DH provided IDhApiLevelWrapper's can be used.");
        }
        ILevelWrapper coreLevelWrapper = (ILevelWrapper)levelWrapper;
        if (objectArray.length != 1) {
            throw new ClassCastException(WrapperFactory.createBlockStateWrapperErrorMessage(objectArray));
        }
        if (!(objectArray[0] instanceof BlockState)) {
            throw new ClassCastException(WrapperFactory.createBlockStateWrapperErrorMessage(objectArray));
        }
        BlockState blockState = (BlockState)objectArray[0];
        return BlockStateWrapper.fromBlockState(blockState, coreLevelWrapper);
    }

    private static String createBlockStateWrapperErrorMessage(Object[] objectArray) {
        String[] expectedClassNames = new String[]{Holder.class.getName() + "<" + Biome.class.getName() + ">"};
        return WrapperFactory.createWrapperErrorMessage("BlockState wrapper", expectedClassNames, objectArray);
    }

    private static String createWrapperErrorMessage(String wrapperName, String[] expectedClassNames, Object[] objectArray) {
        StringBuilder message = new StringBuilder(wrapperName + " creation failed. \nExpected object array parameters: \n");
        for (String expectedClassName : expectedClassNames) {
            message.append("[").append(expectedClassName).append("], \n");
        }
        if (objectArray.length != 0) {
            message.append("Given parameters: ");
            for (Object obj : objectArray) {
                String objClassName = obj != null ? obj.getClass().getName() : "NULL";
                message.append("[").append(objClassName).append("], ");
            }
        } else {
            message.append(" No parameters given.");
        }
        return message.toString();
    }
}

