/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.world;

import com.seibel.distanthorizons.api.enums.worldGeneration.EDhApiLevelType;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.level.IKeyedClientLevelManager;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhBlockPos;
import com.seibel.distanthorizons.core.pos.DhChunkPos;
import com.seibel.distanthorizons.core.wrapperInterfaces.block.IBlockStateWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.chunk.IChunkWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IBiomeWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IClientLevelWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IDimensionTypeWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IServerLevelWrapper;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.McObjectConverter;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.block.BiomeWrapper;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.block.BlockStateWrapper;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.block.cache.ClientBlockDetailMap;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.chunk.ChunkWrapper;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.minecraft.MinecraftClientWrapper;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.world.DimensionTypeWrapper;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.world.ServerLevelWrapper;
import net.minecraft.client.multiplayer.ClientChunkCache;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClientLevelWrapper
implements IClientLevelWrapper {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger(ClientLevelWrapper.class.getSimpleName());
    private static final ConcurrentHashMap<ClientLevel, ClientLevelWrapper> LEVEL_WRAPPER_BY_CLIENT_LEVEL = new ConcurrentHashMap();
    private static final IKeyedClientLevelManager KEYED_CLIENT_LEVEL_MANAGER = SingletonInjector.INSTANCE.get(IKeyedClientLevelManager.class);
    private final ClientLevel level;
    private final ClientBlockDetailMap blockMap = new ClientBlockDetailMap(this);
    private BlockStateWrapper dirtBlockWrapper;
    private BiomeWrapper plainsBiomeWrapper;

    protected ClientLevelWrapper(ClientLevel level) {
        this.level = level;
    }

    @Nullable
    public static IClientLevelWrapper getWrapper(@Nullable ClientLevel level) {
        if (level == null) {
            return null;
        }
        if (KEYED_CLIENT_LEVEL_MANAGER.getUseOverrideWrapper()) {
            return KEYED_CLIENT_LEVEL_MANAGER.getOverrideWrapper();
        }
        return ClientLevelWrapper.getWrapperIgnoringOverride(level);
    }

    public static IClientLevelWrapper getWrapperIgnoringOverride(@NotNull ClientLevel level) {
        return LEVEL_WRAPPER_BY_CLIENT_LEVEL.computeIfAbsent(level, ClientLevelWrapper::new);
    }

    @Override
    @Nullable
    public IServerLevelWrapper tryGetServerSideWrapper() {
        try {
            Iterable serverLevels = MinecraftClientWrapper.INSTANCE.mc.getSingleplayerServer().getAllLevels();
            ServerLevelWrapper foundLevelWrapper = null;
            for (ServerLevel serverLevel : serverLevels) {
                if (serverLevel.dimension() != this.level.dimension()) continue;
                foundLevelWrapper = ServerLevelWrapper.getWrapper(serverLevel);
                break;
            }
            return foundLevelWrapper;
        }
        catch (Exception e) {
            LOGGER.error("Failed to get server side wrapper for client level: " + String.valueOf(this.level));
            return null;
        }
    }

    @Override
    public int computeBaseColor(DhBlockPos pos, IBiomeWrapper biome, IBlockStateWrapper blockState) {
        return this.blockMap.getColor(((BlockStateWrapper)blockState).blockState, (BiomeWrapper)biome, pos);
    }

    @Override
    public int getDirtBlockColor() {
        if (this.dirtBlockWrapper == null) {
            try {
                this.dirtBlockWrapper = (BlockStateWrapper)BlockStateWrapper.deserialize("minecraft:dirt", this);
            }
            catch (IOException e) {
                LOGGER.warn("Unable to get dirt color with resource location [minecraft:dirt] with level [" + String.valueOf(this) + "].", (Throwable)e);
                return -1;
            }
        }
        return this.blockMap.getColor(this.dirtBlockWrapper.blockState, BiomeWrapper.EMPTY_WRAPPER, DhBlockPos.ZERO);
    }

    @Override
    public IBiomeWrapper getPlainsBiomeWrapper() {
        if (this.plainsBiomeWrapper == null) {
            try {
                this.plainsBiomeWrapper = (BiomeWrapper)BiomeWrapper.deserialize("minecraft:plains", this);
            }
            catch (IOException e) {
                LOGGER.warn("Unable to get planes biome with resource location [minecraft:plains] with level [" + String.valueOf(this) + "].", (Throwable)e);
                return null;
            }
        }
        return this.plainsBiomeWrapper;
    }

    @Override
    public IDimensionTypeWrapper getDimensionType() {
        return DimensionTypeWrapper.getDimensionTypeWrapper(this.level.dimensionType());
    }

    @Override
    public EDhApiLevelType getLevelType() {
        return EDhApiLevelType.CLIENT_LEVEL;
    }

    public ClientLevel getLevel() {
        return this.level;
    }

    @Override
    public boolean hasCeiling() {
        return this.level.dimensionType().hasCeiling();
    }

    @Override
    public boolean hasSkyLight() {
        return this.level.dimensionType().hasSkyLight();
    }

    @Override
    public int getHeight() {
        return this.level.getHeight();
    }

    @Override
    public int getMinHeight() {
        return this.level.getMinBuildHeight();
    }

    @Override
    public IChunkWrapper tryGetChunk(DhChunkPos pos) {
        if (!this.level.hasChunk(pos.x, pos.z)) {
            return null;
        }
        ChunkAccess chunk = this.level.getChunk(pos.x, pos.z, ChunkStatus.EMPTY, false);
        if (chunk == null) {
            return null;
        }
        return new ChunkWrapper(chunk, (LevelReader)this.level, this);
    }

    @Override
    public boolean hasChunkLoaded(int chunkX, int chunkZ) {
        ClientChunkCache source = this.level.getChunkSource();
        return source.hasChunk(chunkX, chunkZ);
    }

    @Override
    public IBlockStateWrapper getBlockState(DhBlockPos pos) {
        return BlockStateWrapper.fromBlockState(this.level.getBlockState(McObjectConverter.Convert(pos)), this);
    }

    @Override
    public IBiomeWrapper getBiome(DhBlockPos pos) {
        return BiomeWrapper.getBiomeWrapper((Holder<Biome>)this.level.getBiome(McObjectConverter.Convert(pos)), this);
    }

    public ClientLevel getWrappedMcObject() {
        return this.level;
    }

    @Override
    public void onUnload() {
        LEVEL_WRAPPER_BY_CLIENT_LEVEL.remove(this.level);
    }

    public String toString() {
        if (this.level == null) {
            return "Wrapped{null}";
        }
        return "Wrapped{" + this.level.toString() + "@" + this.getDimensionType().getDimensionName() + "}";
    }
}

