/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.world;

import com.seibel.distanthorizons.api.enums.worldGeneration.EDhApiLevelType;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhBlockPos;
import com.seibel.distanthorizons.core.pos.DhChunkPos;
import com.seibel.distanthorizons.core.wrapperInterfaces.block.IBlockStateWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.chunk.IChunkWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IBiomeWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IClientLevelWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IServerLevelWrapper;
import java.io.File;
import java.util.concurrent.ConcurrentHashMap;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.McObjectConverter;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.block.BiomeWrapper;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.block.BlockStateWrapper;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.block.cache.ServerBlockDetailMap;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.chunk.ChunkWrapper;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.minecraft.MinecraftClientWrapper;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.world.ClientLevelWrapper;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.world.DimensionTypeWrapper;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class ServerLevelWrapper
implements IServerLevelWrapper {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    private static final ConcurrentHashMap<ServerLevel, ServerLevelWrapper> LEVEL_WRAPPER_BY_SERVER_LEVEL = new ConcurrentHashMap();
    final ServerLevel level;
    ServerBlockDetailMap blockMap = new ServerBlockDetailMap(this);

    public static ServerLevelWrapper getWrapper(ServerLevel level) {
        return LEVEL_WRAPPER_BY_SERVER_LEVEL.computeIfAbsent(level, ServerLevelWrapper::new);
    }

    public ServerLevelWrapper(ServerLevel level) {
        this.level = level;
    }

    @Override
    @Nullable
    public IClientLevelWrapper tryGetClientLevelWrapper() {
        MinecraftClientWrapper client = MinecraftClientWrapper.INSTANCE;
        if (client.mc.level == null) {
            return null;
        }
        return ClientLevelWrapper.getWrapper(client.mc.level);
    }

    @Override
    public File getSaveFolder() {
        return this.level.getChunkSource().getDataStorage().dataFolder;
    }

    @Override
    public DimensionTypeWrapper getDimensionType() {
        return DimensionTypeWrapper.getDimensionTypeWrapper(this.level.dimensionType());
    }

    @Override
    public EDhApiLevelType getLevelType() {
        return EDhApiLevelType.SERVER_LEVEL;
    }

    public ServerLevel getLevel() {
        return this.level;
    }

    @Override
    public boolean hasCeiling() {
        return this.level.dimensionType().hasCeiling();
    }

    @Override
    public boolean hasSkyLight() {
        return this.level.dimensionType().hasSkyLight();
    }

    @Override
    public int getHeight() {
        return this.level.getHeight();
    }

    @Override
    public int getMinHeight() {
        return this.level.getMinBuildHeight();
    }

    @Override
    public IChunkWrapper tryGetChunk(DhChunkPos pos) {
        if (!this.level.hasChunk(pos.x, pos.z)) {
            return null;
        }
        ChunkAccess chunk = this.level.getChunk(pos.x, pos.z, ChunkStatus.FULL, false);
        if (chunk == null) {
            return null;
        }
        return new ChunkWrapper(chunk, (LevelReader)this.level, this);
    }

    @Override
    public boolean hasChunkLoaded(int chunkX, int chunkZ) {
        ServerChunkCache source = this.level.getChunkSource();
        return source.hasChunk(chunkX, chunkZ);
    }

    @Override
    public IBlockStateWrapper getBlockState(DhBlockPos pos) {
        return BlockStateWrapper.fromBlockState(this.level.getBlockState(McObjectConverter.Convert(pos)), this);
    }

    @Override
    public IBiomeWrapper getBiome(DhBlockPos pos) {
        return BiomeWrapper.getBiomeWrapper((Holder<Biome>)this.level.getBiome(McObjectConverter.Convert(pos)), this);
    }

    public ServerLevel getWrappedMcObject() {
        return this.level;
    }

    @Override
    public void onUnload() {
        LEVEL_WRAPPER_BY_SERVER_LEVEL.remove(this.level);
    }

    public String toString() {
        return "Wrapped{" + this.level.toString() + "@" + this.getDimensionType().getDimensionName() + "}";
    }
}

