/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.worldGeneration;

import com.seibel.distanthorizons.api.enums.worldGeneration.EDhApiWorldGenerationStep;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhChunkPos;
import com.seibel.distanthorizons.core.util.objects.EventTimer;
import com.seibel.distanthorizons.core.util.objects.UncheckedInterruptedException;
import com.seibel.distanthorizons.core.util.threading.ThreadPoolUtil;
import com.seibel.distanthorizons.core.wrapperInterfaces.chunk.IChunkWrapper;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.worldGeneration.BatchGenerationEnvironment;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.worldGeneration.ThreadedParameters;
import org.apache.logging.log4j.Logger;

public final class GenerationEvent {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger(MethodHandles.lookup().lookupClass().getSimpleName());
    private static int generationFutureDebugIDs = 0;
    public final int id;
    public final ThreadedParameters threadedParam;
    public final DhChunkPos minPos;
    public final int size;
    public final EDhApiWorldGenerationStep targetGenerationStep;
    public EventTimer timer = null;
    public long inQueueTime = System.nanoTime();
    public long timeoutTime = -1L;
    public CompletableFuture<Void> future = null;
    public final Consumer<IChunkWrapper> resultConsumer;

    public GenerationEvent(DhChunkPos minPos, int size, BatchGenerationEnvironment generationGroup, EDhApiWorldGenerationStep targetGenerationStep, Consumer<IChunkWrapper> resultConsumer) {
        this.id = generationFutureDebugIDs++;
        this.minPos = minPos;
        this.size = size;
        this.targetGenerationStep = targetGenerationStep;
        this.threadedParam = ThreadedParameters.getOrMake(generationGroup.params);
        this.resultConsumer = resultConsumer;
    }

    public static GenerationEvent startEvent(DhChunkPos minPos, int size, BatchGenerationEnvironment genEnvironment, EDhApiWorldGenerationStep target, Consumer<IChunkWrapper> resultConsumer, ExecutorService worldGeneratorThreadPool) {
        if (size % 2 == 0) {
            ++size;
        }
        GenerationEvent generationEvent = new GenerationEvent(minPos, size, genEnvironment, target, resultConsumer);
        generationEvent.future = CompletableFuture.runAsync(() -> {
            long runStartTime;
            generationEvent.timeoutTime = runStartTime = System.nanoTime();
            generationEvent.inQueueTime = runStartTime - generationEvent.inQueueTime;
            generationEvent.timer = new EventTimer("setup");
            BatchGenerationEnvironment.isDistantGeneratorThread.set(true);
            try {
                genEnvironment.generateLodFromList(generationEvent);
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                BatchGenerationEnvironment.isDistantGeneratorThread.remove();
            }
        }, worldGeneratorThreadPool);
        return generationEvent;
    }

    public boolean isComplete() {
        return this.future.isDone();
    }

    public boolean hasTimeout(int duration, TimeUnit unit) {
        if (this.timeoutTime == -1L) {
            return false;
        }
        long currentTime = System.nanoTime();
        long delta = currentTime - this.timeoutTime;
        return delta > TimeUnit.NANOSECONDS.convert(duration, unit);
    }

    public boolean terminate() {
        LOGGER.info("======================DUMPING ALL THREADS FOR WORLD GEN=======================");
        ThreadPoolUtil.WORLD_GEN_THREAD_FACTORY.dumpAllThreadStacks();
        this.future.cancel(true);
        return this.future.isCancelled();
    }

    public boolean tooClose(int minX, int minZ, int width) {
        int aMinX = this.minPos.x;
        int aMinZ = this.minPos.z;
        int aSize = this.size;
        return aMinX + ++aSize >= minX && aMinX <= minX + ++width && aMinZ + aSize >= minZ && aMinZ <= minZ + width;
    }

    public void refreshTimeout() {
        this.timeoutTime = System.nanoTime();
        UncheckedInterruptedException.throwIfInterrupted();
    }

    public String toString() {
        return this.id + ":" + this.size + "@" + String.valueOf(this.minPos) + "(" + String.valueOf((Object)this.targetGenerationStep) + ")";
    }
}

