/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.worldGeneration.mimicObject;

import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.ReentrantLock;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.worldGeneration.BatchGenerationEnvironment;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.storage.RegionFile;
import net.minecraft.world.level.chunk.storage.RegionFileStorage;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

@Deprecated
public class RegionFileStorageExternalCache
implements AutoCloseable {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    @Nullable
    public final RegionFileStorage storage;
    public static final int MAX_CACHE_SIZE = 16;
    public static boolean regionCacheNullPointerWarningSent = false;
    ReentrantLock getRegionFileLock = new ReentrantLock();
    public ConcurrentLinkedQueue<RegionFileCache> regionFileCache = new ConcurrentLinkedQueue();

    public RegionFileStorageExternalCache(RegionFileStorage storage) {
        this.storage = storage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public RegionFile getRegionFile(ChunkPos pos) throws IOException {
        if (this.storage == null) {
            if (!regionCacheNullPointerWarningSent) {
                regionCacheNullPointerWarningSent = true;
                LOGGER.warn("Unable to access Minecraft's chunk cache. This may be due to another mod changing said cache. DH will be unable to access any Minecraft chunk data until said mod is removed.");
            }
            return null;
        }
        long posLong = ChunkPos.asLong((int)pos.getRegionX(), (int)pos.getRegionZ());
        RegionFile rFile = null;
        int retryCount = 0;
        int maxRetryCount = 8;
        while (retryCount < maxRetryCount) {
            ++retryCount;
            try {
                this.getRegionFileLock.lock();
                rFile = (RegionFile)this.storage.regionCache.getOrDefault(posLong, null);
                break;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            catch (NullPointerException e) {
                if (regionCacheNullPointerWarningSent) break;
                regionCacheNullPointerWarningSent = true;
                LOGGER.warn("Unable to access Minecraft's chunk cache. This may be due to another mod changing said cache. Falling back to DH's internal cache.");
                break;
            }
            finally {
                this.getRegionFileLock.unlock();
            }
        }
        if (retryCount >= maxRetryCount) {
            BatchGenerationEnvironment.LOAD_LOGGER.warn("Concurrency issue detected when getting region file for chunk at " + String.valueOf(pos) + ".", new Object[0]);
        }
        if (rFile != null) {
            return rFile;
        }
        for (RegionFileCache cache : this.regionFileCache) {
            if (cache.pos != posLong) continue;
            return cache.file;
        }
        Path storageFolderPath = this.storage.folder;
        if (!Files.exists(storageFolderPath, new LinkOption[0])) {
            return null;
        }
        Path regionFilePath = storageFolderPath.resolve("r." + pos.getRegionX() + "." + pos.getRegionZ() + ".mca");
        rFile = new RegionFile(new RegionStorageInfo("level", null, "level type"), regionFilePath, storageFolderPath, false);
        this.regionFileCache.add(new RegionFileCache(ChunkPos.asLong((int)pos.getRegionX(), (int)pos.getRegionZ()), rFile));
        while (this.regionFileCache.size() > 16) {
            this.regionFileCache.poll().file.close();
        }
        return rFile;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public CompoundTag read(ChunkPos pos) throws IOException {
        RegionFile file = this.getRegionFile(pos);
        if (file == null) {
            return null;
        }
        try (DataInputStream stream = file.getChunkDataInputStream(pos);){
            if (stream == null) {
                CompoundTag compoundTag2 = null;
                return compoundTag2;
            }
            CompoundTag compoundTag = NbtIo.read((DataInput)stream);
            return compoundTag;
        }
        catch (Throwable e) {
            return null;
        }
    }

    @Override
    public void close() throws IOException {
        RegionFileCache cache;
        while ((cache = this.regionFileCache.poll()) != null) {
            cache.file.close();
        }
    }

    static class RegionFileCache {
        public final long pos;
        public final RegionFile file;

        public RegionFileCache(long pos, RegionFile file) {
            this.pos = pos;
            this.file = file;
        }
    }
}

