/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl;

import java.util.function.Function;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2404;
import net.minecraft.class_2680;
import snownee.jade.api.AccessorClientHandler;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IComponentProvider;
import snownee.jade.api.IJadeProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.ui.IElement;
import snownee.jade.impl.WailaClientRegistration;
import snownee.jade.impl.WailaCommonRegistration;
import snownee.jade.impl.config.PluginConfig;
import snownee.jade.impl.ui.ElementHelper;
import snownee.jade.impl.ui.ItemStackElement;
import snownee.jade.overlay.RayTracing;
import snownee.jade.util.ClientProxy;
import snownee.jade.util.WailaExceptionHandler;

public class BlockAccessorClientHandler
implements AccessorClientHandler<BlockAccessor> {
    @Override
    public boolean shouldDisplay(BlockAccessor accessor) {
        return IWailaConfig.get().getGeneral().getDisplayBlocks();
    }

    @Override
    public boolean shouldRequestData(BlockAccessor accessor) {
        for (IServerDataProvider<BlockAccessor> provider : WailaCommonRegistration.instance().getBlockNBTProviders(accessor.getBlock(), accessor.getBlockEntity())) {
            if (!provider.shouldRequestData(accessor)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void requestData(BlockAccessor accessor) {
        ClientProxy.requestBlockData(accessor);
    }

    @Override
    public IElement getIcon(BlockAccessor accessor) {
        class_2680 blockState = accessor.getBlockState();
        class_2248 block = blockState.method_26204();
        if (blockState.method_26215()) {
            return null;
        }
        IElement icon = null;
        if (accessor.isFakeBlock()) {
            icon = ItemStackElement.of(accessor.getFakeBlock());
        } else {
            class_1799 pick = accessor.getPickedResult();
            if (!pick.method_7960()) {
                icon = ItemStackElement.of(pick);
            }
        }
        if (RayTracing.isEmptyElement(icon) && block.method_8389() != class_1802.field_8162) {
            icon = ItemStackElement.of(new class_1799((class_1935)block));
        }
        if (RayTracing.isEmptyElement(icon) && block instanceof class_2404) {
            icon = ClientProxy.elementFromLiquid(blockState);
        }
        for (IComponentProvider<BlockAccessor> provider : WailaClientRegistration.instance().getBlockIconProviders(block, PluginConfig.INSTANCE::get)) {
            try {
                IElement element = provider.getIcon(accessor, PluginConfig.INSTANCE, icon);
                if (RayTracing.isEmptyElement(element)) continue;
                icon = element;
            }
            catch (Throwable e) {
                WailaExceptionHandler.handleErr(e, provider, null, null);
            }
        }
        return icon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void gatherComponents(BlockAccessor accessor, Function<IJadeProvider, ITooltip> tooltipProvider) {
        for (IComponentProvider<BlockAccessor> provider : WailaClientRegistration.instance().getBlockProviders(accessor.getBlock(), PluginConfig.INSTANCE::get)) {
            ITooltip tooltip = tooltipProvider.apply(provider);
            try {
                ElementHelper.INSTANCE.setCurrentUid(provider.getUid());
                provider.appendTooltip(tooltip, accessor, PluginConfig.INSTANCE);
            }
            catch (Throwable e) {
                WailaExceptionHandler.handleErr(e, provider, tooltip, null);
            }
            finally {
                ElementHelper.INSTANCE.setCurrentUid(null);
            }
        }
    }
}

