/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl.ui;

import java.util.Objects;
import net.minecraft.class_1799;
import net.minecraft.class_241;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.ITooltip;
import snownee.jade.api.JadeIds;
import snownee.jade.api.fluid.JadeFluidObject;
import snownee.jade.api.ui.BoxStyle;
import snownee.jade.api.ui.IBoxElement;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.IElementHelper;
import snownee.jade.api.ui.ITextElement;
import snownee.jade.api.ui.ProgressStyle;
import snownee.jade.impl.Tooltip;
import snownee.jade.impl.ui.BoxElement;
import snownee.jade.impl.ui.FluidStackElement;
import snownee.jade.impl.ui.ItemStackElement;
import snownee.jade.impl.ui.ProgressElement;
import snownee.jade.impl.ui.SimpleProgressStyle;
import snownee.jade.impl.ui.SpacerElement;
import snownee.jade.impl.ui.SpriteElement;
import snownee.jade.impl.ui.TextElement;

public class ElementHelper
implements IElementHelper {
    public static final ElementHelper INSTANCE = new ElementHelper();
    public static final class_2960 DEFAULT_PROGRESS = JadeIds.JADE("progress");
    public static final class_2960 DEFAULT_PROGRESS_BASE = JadeIds.JADE("progress_base");
    public static final class_241 SMALL_ITEM_SIZE = new class_241(10.0f, 10.0f);
    public static final class_241 SMALL_ITEM_OFFSET = new class_241(0.0f, -1.0f);
    private class_2960 uid;

    @Override
    public ITextElement text(class_2561 component) {
        return new TextElement(component);
    }

    @Override
    public IElement item(class_1799 stack) {
        return ItemStackElement.of(stack);
    }

    @Override
    public IElement item(class_1799 stack, float scale) {
        return ItemStackElement.of(stack, scale);
    }

    @Override
    public IElement item(class_1799 stack, float scale, String text) {
        return ItemStackElement.of(stack, scale, text);
    }

    @Override
    public IElement smallItem(class_1799 stack) {
        return this.item(stack, 0.5f, "").size(SMALL_ITEM_SIZE).translate(SMALL_ITEM_OFFSET).message(null);
    }

    @Override
    public IElement fluid(JadeFluidObject fluid) {
        return new FluidStackElement(fluid);
    }

    @Override
    public IElement spacer(int width, int height) {
        return new SpacerElement(new class_241((float)width, (float)height));
    }

    @Override
    public IElement progress(float progress, @Nullable class_2561 text, ProgressStyle style, BoxStyle boxStyle, boolean canDecrease) {
        Objects.requireNonNull(style);
        Objects.requireNonNull(boxStyle);
        return new ProgressElement(progress, text, style, boxStyle, canDecrease);
    }

    @Override
    public IElement progress(float progress) {
        return this.progress(progress, DEFAULT_PROGRESS_BASE, DEFAULT_PROGRESS, 22, 16, false);
    }

    @Override
    public IElement progress(float progress, class_2960 baseSprite, class_2960 progressSprite, int width, int height, boolean canDecrease) {
        ProgressStyle style = this.progressStyle().fitContentX(false).overlay(this.sprite(progressSprite, width, height));
        BoxStyle boxStyle = BoxStyle.getSprite(baseSprite, null);
        return this.progress(progress, null, style, boxStyle, canDecrease).size(new class_241((float)width, (float)height));
    }

    @Override
    public IBoxElement box(ITooltip tooltip, BoxStyle boxStyle) {
        return new BoxElement((Tooltip)tooltip, boxStyle);
    }

    @Override
    public ITooltip tooltip() {
        return new Tooltip();
    }

    @Override
    public ProgressStyle progressStyle() {
        return new SimpleProgressStyle();
    }

    @Override
    public IElement sprite(class_2960 sprite, int width, int height) {
        return new SpriteElement(sprite, width, height);
    }

    @Nullable
    public class_2960 currentUid() {
        return this.uid;
    }

    public void setCurrentUid(class_2960 uid) {
        this.uid = uid;
    }
}

