/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.util;

import com.google.common.base.Strings;
import com.mojang.brigadier.CommandDispatcher;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientEntityEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.item.v1.ItemTooltipCallback;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.transfer.v1.client.fluid.FluidVariantRenderHandler;
import net.fabricmc.fabric.api.transfer.v1.client.fluid.FluidVariantRendering;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_1058;
import net.minecraft.class_1074;
import net.minecraft.class_1297;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1920;
import net.minecraft.class_1934;
import net.minecraft.class_2246;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_327;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3304;
import net.minecraft.class_332;
import net.minecraft.class_3528;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3675;
import net.minecraft.class_4013;
import net.minecraft.class_408;
import net.minecraft.class_437;
import net.minecraft.class_634;
import net.minecraft.class_636;
import net.minecraft.class_638;
import net.minecraft.class_7157;
import net.minecraft.class_768;
import net.minecraft.class_8710;
import net.minecraft.class_9326;
import org.jetbrains.annotations.Nullable;
import snownee.jade.JadeClient;
import snownee.jade.addon.harvest.HarvestToolProvider;
import snownee.jade.addon.harvest.SimpleToolHandler;
import snownee.jade.addon.harvest.ToolHandler;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.JadeIds;
import snownee.jade.api.fluid.JadeFluidObject;
import snownee.jade.api.ui.IElement;
import snownee.jade.command.JadeClientCommand;
import snownee.jade.compat.JEICompat;
import snownee.jade.gui.BaseOptionsScreen;
import snownee.jade.impl.BlockAccessorImpl;
import snownee.jade.impl.EntityAccessorImpl;
import snownee.jade.impl.ObjectDataCenter;
import snownee.jade.impl.theme.ThemeHelper;
import snownee.jade.impl.ui.FluidStackElement;
import snownee.jade.mixin.KeyAccess;
import snownee.jade.network.ReceiveDataPacket;
import snownee.jade.network.RequestBlockPacket;
import snownee.jade.network.RequestEntityPacket;
import snownee.jade.network.ServerPingPacket;
import snownee.jade.network.ShowOverlayPacket;
import snownee.jade.overlay.DatapackBlockManager;
import snownee.jade.overlay.OverlayRenderer;
import snownee.jade.overlay.WailaTickHandler;
import snownee.jade.util.CommonProxy;
import snownee.jade.util.UsernameCache;
import snownee.jade.util.WailaExceptionHandler;

public final class ClientProxy
implements ClientModInitializer {
    public static boolean hasJEI = CommonProxy.isModLoaded("jei");
    public static boolean hasREI = false;
    public static boolean hasFastScroll = CommonProxy.isModLoaded("fastscroll");
    public static boolean maybeLowVisionUser = CommonProxy.isModLoaded("minecraft_access");

    public static Optional<String> getModName(String namespace) {
        String modMenuKey = "modmenu.nameTranslation.%s".formatted(namespace);
        if (class_1074.method_4663((String)modMenuKey)) {
            return Optional.of(class_1074.method_4662((String)modMenuKey, (Object[])new Object[0]));
        }
        return FabricLoader.getInstance().getModContainer(namespace).map(ModContainer::getMetadata).map(ModMetadata::getName).filter(Predicate.not(Strings::isNullOrEmpty));
    }

    public static void registerClientCommand(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 registryAccess) {
        dispatcher.register(JadeClientCommand.create(ClientCommandManager::literal, FabricClientCommandSource::sendFeedback, FabricClientCommandSource::sendError));
    }

    private static void onEntityJoin(class_1297 entity, class_638 level) {
        DatapackBlockManager.onEntityJoin(entity);
    }

    private static void onEntityLeave(class_1297 entity, class_638 level) {
        DatapackBlockManager.onEntityLeave(entity);
    }

    private static void onTooltip(class_1799 stack, class_1792.class_9635 tooltipContext, class_1836 tooltipType, List<class_2561> lines) {
        JadeClient.appendModName(lines, stack, tooltipContext, tooltipType);
    }

    public static void onRenderTick(class_332 guiGraphics, float tickDelta) {
        try {
            OverlayRenderer.renderOverlay478757(guiGraphics, tickDelta);
        }
        catch (Throwable e) {
            WailaExceptionHandler.handleErr(e, null, null, null);
        }
    }

    private static void onClientTick(class_310 mc) {
        try {
            WailaTickHandler.instance().tickClient();
        }
        catch (Throwable e) {
            WailaExceptionHandler.handleErr(e, null, null, null);
        }
    }

    private static void onPlayerLeave(class_634 handler, class_310 client) {
        ObjectDataCenter.serverConnected = false;
    }

    private static void onKeyPressed(class_310 mc) {
        JadeClient.onKeyPressed(1);
        if (JadeClient.showUses != null && hasJEI) {
            JEICompat.onKeyPressed(1);
        }
    }

    private static void onGui(class_437 screen) {
        JadeClient.onGui(screen);
    }

    public static class_304 registerKeyBinding(String desc, int defaultKey) {
        class_304 key = new class_304("key.jade." + desc, class_3675.class_307.field_1668, defaultKey, "modmenu.nameTranslation.jade");
        KeyBindingHelper.registerKeyBinding((class_304)key);
        return key;
    }

    public static boolean shouldRegisterRecipeViewerKeys() {
        return hasJEI || hasREI;
    }

    public static void requestBlockData(BlockAccessor accessor) {
        ClientPlayNetworking.send((class_8710)new RequestBlockPacket(new BlockAccessorImpl.SyncData(accessor)));
    }

    public static void requestEntityData(EntityAccessor accessor) {
        ClientPlayNetworking.send((class_8710)new RequestEntityPacket(new EntityAccessorImpl.SyncData(accessor)));
    }

    public static IElement elementFromLiquid(class_2680 blockState) {
        class_3610 fluidState = blockState.method_26227();
        return new FluidStackElement(JadeFluidObject.of(fluidState.method_15772()));
    }

    public static void registerReloadListener(class_4013 listener) {
        class_310.method_1551().execute(() -> {
            class_3304 manager = (class_3304)class_310.method_1551().method_1478();
            manager.method_14477((class_3302)listener);
            listener.method_14491((class_3300)manager);
        });
    }

    @Nullable
    public static class_768 getBossBarRect() {
        class_310 mc = class_310.method_1551();
        int size = mc.field_1705.method_1740().field_2060.size();
        if (size == 0) {
            return null;
        }
        int i = mc.method_22683().method_4486();
        int k = i / 2 - 91;
        Objects.requireNonNull(mc.field_1772);
        int height = 10 + 9;
        size = Math.min(size, (mc.method_22683().method_4502() / 3 - 12) / height + 1);
        return new class_768(k, 12, 182, height * size);
    }

    public static boolean isShowDetailsPressed() {
        return class_437.method_25442() || JadeClient.showDetails.method_1434();
    }

    public static boolean shouldShowWithOverlay(class_310 mc, @Nullable class_437 screen) {
        return screen == null || screen instanceof BaseOptionsScreen || screen instanceof class_408;
    }

    public static void getFluidSpriteAndColor(JadeFluidObject fluid, BiConsumer<@Nullable class_1058, Integer> consumer) {
        class_3611 type = fluid.getType();
        FluidVariant variant = FluidVariant.of((class_3611)type, (class_9326)fluid.getComponents());
        FluidVariantRenderHandler handler = FluidVariantRendering.getHandlerOrDefault((class_3611)type);
        class_1058[] sprites = handler.getSprites(variant);
        class_1058 fluidStillSprite = sprites == null ? null : sprites[0];
        int fluidColor = handler.getColor(variant, (class_1920)class_310.method_1551().field_1687, null);
        consumer.accept(fluidStillSprite, fluidColor);
    }

    public static ToolHandler createSwordToolHandler() {
        return SimpleToolHandler.create(JadeIds.JADE("sword"), false, List.of(class_1802.field_8091)).addBlock(class_2246.field_10343).addBlock(class_2246.field_10211);
    }

    public static class_304 registerDetailsKeyBinding() {
        return ClientProxy.registerKeyBinding("show_details_alternative", class_3675.field_16237.method_1444());
    }

    public static void renderItemDecorationsExtra(class_332 guiGraphics, class_327 font, class_1799 stack, int x, int y, String text) {
    }

    public static class_3675.class_306 getBoundKeyOf(class_304 keyMapping) {
        return KeyBindingHelper.getBoundKeyOf((class_304)keyMapping);
    }

    public static class_1934 getGameMode() {
        class_636 gameMode = class_310.method_1551().field_1761;
        return gameMode == null ? class_1934.field_9215 : gameMode.method_2920();
    }

    public void onInitializeClient() {
        ClientLifecycleEvents.CLIENT_STARTED.register(mc -> CommonProxy.loadComplete());
        ClientEntityEvents.ENTITY_LOAD.register(ClientProxy::onEntityJoin);
        ClientEntityEvents.ENTITY_UNLOAD.register(ClientProxy::onEntityLeave);
        class_2960 lowest = JadeIds.CORE_MOD_NAME;
        ItemTooltipCallback.EVENT.addPhaseOrdering(Event.DEFAULT_PHASE, lowest);
        ItemTooltipCallback.EVENT.register(lowest, ClientProxy::onTooltip);
        ClientPlayConnectionEvents.DISCONNECT.register(ClientProxy::onPlayerLeave);
        ClientTickEvents.END_CLIENT_TICK.register(ClientProxy::onClientTick);
        ClientTickEvents.END_CLIENT_TICK.register(ClientProxy::onKeyPressed);
        ScreenEvents.AFTER_INIT.register((client, screen, scaledWidth, scaledHeight) -> ClientProxy.onGui(screen));
        ClientCommandRegistrationCallback.EVENT.register(ClientProxy::registerClientCommand);
        HudRenderCallback.EVENT.register((guiGraphics, deltaTracker) -> {
            if (class_310.method_1551().field_1755 == null) {
                ClientProxy.onRenderTick(guiGraphics, deltaTracker.method_60638());
            }
        });
        ScreenEvents.AFTER_INIT.register((client, screen, scaledWidth, scaledHeight) -> {
            if (ClientProxy.shouldShowWithOverlay(client, screen)) {
                ScreenEvents.afterRender((class_437)screen).register((screen1, guiGraphics, mouseX, mouseY, tickDelta) -> ClientProxy.onRenderTick(guiGraphics, tickDelta));
            }
        });
        ClientPlayNetworking.registerGlobalReceiver(ReceiveDataPacket.TYPE, (payload, context) -> ReceiveDataPacket.handle(payload, arg_0 -> ((class_310)context.client()).execute(arg_0)));
        ClientPlayNetworking.registerGlobalReceiver(ServerPingPacket.TYPE, (payload, context) -> ServerPingPacket.handle(payload, arg_0 -> ((class_310)context.client()).execute(arg_0)));
        ClientPlayNetworking.registerGlobalReceiver(ShowOverlayPacket.TYPE, (payload, context) -> ShowOverlayPacket.handle(payload, arg_0 -> ((class_310)context.client()).execute(arg_0)));
        for (int i = 320; i < 330; ++i) {
            class_3675.class_306 key = class_3675.class_307.field_1668.method_1447(i);
            ((KeyAccess)key).setDisplayName((class_3528<class_2561>)new class_3528(() -> class_2561.method_43471((String)key.method_1441())));
        }
        JadeClient.init();
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)ThemeHelper.INSTANCE);
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)HarvestToolProvider.INSTANCE);
        UsernameCache.load();
    }
}

