/*
 * Decompiled with CFR 0.152.
 */
package carpetextra.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.io.IOUtils;

public class CarpetExtraTranslations {
    public static Map<String, String> getTranslationFromResourcePath(String lang) {
        String jsonData;
        InputStream langFile = CarpetExtraTranslations.class.getClassLoader().getResourceAsStream("assets/carpet-extra/lang/%s.json".formatted(lang));
        if (langFile == null) {
            return Collections.emptyMap();
        }
        try {
            jsonData = IOUtils.toString((InputStream)langFile, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            return Collections.emptyMap();
        }
        Gson gson = new GsonBuilder().setLenient().create();
        return (Map)gson.fromJson(jsonData, new TypeToken<Map<String, String>>(){}.getType());
    }
}

