/*
 * Decompiled with CFR 0.152.
 */
package cgcm.chestsearchbar.config;

import cgcm.chestsearchbar.config.JsonConfig;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class Config {
    public static boolean keepSearch = true;
    public static boolean autoFocus = false;
    public static Mode vanillaContainerMode = Mode.SORT;
    public static Mode nonVanillaContainerMode = Mode.SHADOW;
    public static int minSlots = 27;
    public static List<String> allowedScreensList = new ArrayList<String>(Arrays.asList("net.minecraft.client.gui.screens.inventory.ContainerScreen"));
    public static List<String> deniedScreensList = new ArrayList<String>(Arrays.asList("com.tiviacz.travelersbackpack.client.screens.", "net.p3pp3rf1y.sophisticatedstorage.client.gui.", "shetiphian.enderchests.client.gui.", "blusunrize.immersiveengineering.client.gui.CraftingTableScreen", "appeng.client.gui.", "mekanism.client.gui.", "unhappycodings.thoriumreactors.common.container."));
    private static final JsonConfig.BooleanConfig KEEP_SEARCH = JsonConfig.booleanBuilder("keepSearch", true);
    private static final JsonConfig.BooleanConfig AUTO_FOCUS = JsonConfig.booleanBuilder("autoFocus", false);
    private static final JsonConfig.IntConfig VANILLA_MODE = (JsonConfig.IntConfig)JsonConfig.intBuilder("vanillaContainerMode", Mode.SORT.ordinal(), 0, 2).description("Mode used for minecraft containers. 0 = Disabled.");
    private static final JsonConfig.IntConfig NON_VANILLA_MODE = (JsonConfig.IntConfig)JsonConfig.intBuilder("nonVanillaContainerMode", Mode.SHADOW.ordinal(), 0, 2).description("Mode used for non-vanilla containers. 0 = Disabled.");
    private static final JsonConfig.StringListConfig ALLOWED_SCREENS_LIST = new JsonConfig.StringListConfig("allowedScreensList", List.of("appeng.client.gui.implementations.SkyChestScreen"));
    private static final JsonConfig.StringListConfig DENIED_SCREENS_LIST = new JsonConfig.StringListConfig("deniedScreensList", List.of(""));

    public static boolean isScreenAllowed(String screenClass, int size) {
        if (!Config.isEnabled(screenClass)) {
            return false;
        }
        if (allowedScreensList.contains(screenClass)) {
            return true;
        }
        return size >= minSlots && !Config.isClassPresent(screenClass, deniedScreensList);
    }

    public static boolean isEnabled(String screenClass) {
        return !(screenClass.startsWith("net.minecraft.") ? vanillaContainerMode == Mode.DISABLED : nonVanillaContainerMode == Mode.DISABLED);
    }

    public static boolean isClassPresent(String className, List<String> list) {
        for (String item : list) {
            if (item.isBlank() || !className.startsWith(item)) continue;
            return true;
        }
        return false;
    }

    public static void load(Path p) {
        JsonConfig.load(p.resolve("chestsearchbar.json").toFile());
        keepSearch = (Boolean)KEEP_SEARCH.get();
        autoFocus = (Boolean)AUTO_FOCUS.get();
        vanillaContainerMode = Mode.values()[(Integer)VANILLA_MODE.get()];
        nonVanillaContainerMode = Mode.values()[(Integer)NON_VANILLA_MODE.get()];
        allowedScreensList.addAll((Collection)ALLOWED_SCREENS_LIST.get());
        deniedScreensList.addAll((Collection)DENIED_SCREENS_LIST.get());
    }

    public static enum Mode {
        DISABLED,
        SORT,
        SHADOW;

    }
}

