/*
 * Decompiled with CFR 0.152.
 */
package cgcm.chestsearchbar.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class JsonConfig {
    private static final Map<String, ConfigEntry<?, ?>> entries = new LinkedHashMap();
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public static BooleanConfig booleanBuilder(String key, boolean def) {
        return new BooleanConfig(key, def);
    }

    public static IntConfig intBuilder(String key, int def, int min, int max) {
        return new IntConfig(key, def, min, max);
    }

    public static StringConfig stringBuilder(String key, String def) {
        return new StringConfig(key, def);
    }

    public static StringListConfig stringListBuilder(String key, List<String> def) {
        return new StringListConfig(key, def);
    }

    public static void load(File file) {
        if (!file.exists()) {
            JsonConfig.save(file);
            return;
        }
        try (FileReader reader = new FileReader(file);){
            JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            for (Map.Entry<String, ConfigEntry<?, ?>> entry : entries.entrySet()) {
                String key = entry.getKey();
                ConfigEntry<?, ?> configEntry = entry.getValue();
                if (!json.has(key)) continue;
                JsonObject entryJson = json.getAsJsonObject(key);
                if (configEntry instanceof BooleanConfig) {
                    if (!entryJson.has(key) || !entryJson.get(key).isJsonPrimitive() || !entryJson.get(key).getAsJsonPrimitive().isBoolean()) continue;
                    ((BooleanConfig)configEntry).setValue(entryJson.get(key).getAsBoolean());
                    continue;
                }
                if (configEntry instanceof IntConfig) {
                    if (!entryJson.has(key) || !entryJson.get(key).isJsonPrimitive() || !entryJson.get(key).getAsJsonPrimitive().isNumber()) continue;
                    ((IntConfig)configEntry).setValue(entryJson.get(key).getAsInt());
                    continue;
                }
                if (configEntry instanceof StringConfig) {
                    if (!entryJson.has(key) || !entryJson.get(key).isJsonPrimitive() || !entryJson.get(key).getAsJsonPrimitive().isString()) continue;
                    ((StringConfig)configEntry).setValue(entryJson.get(key).getAsString());
                    continue;
                }
                if (!(configEntry instanceof StringListConfig) || !entryJson.has(key) || !entryJson.get(key).isJsonArray()) continue;
                Type listType = new TypeToken<List<String>>(){}.getType();
                List list = (List)gson.fromJson(entryJson.get(key), listType);
                ((StringListConfig)configEntry).setValue(list);
            }
        }
        catch (IOException iOException) {
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            // empty catch block
        }
        JsonConfig.save(file);
    }

    private static void save(File file) {
        JsonObject json = new JsonObject();
        for (Map.Entry<String, ConfigEntry<?, ?>> entry : entries.entrySet()) {
            String key = entry.getKey();
            ConfigEntry<?, ?> configEntry = entry.getValue();
            JsonObject entryJson = new JsonObject();
            if (configEntry.description != null) {
                entryJson.addProperty("description", configEntry.description);
            }
            if (configEntry instanceof BooleanConfig) {
                entryJson.addProperty(key, (Boolean)configEntry.get());
            } else if (configEntry instanceof IntConfig) {
                entryJson.addProperty(key, (Number)((Integer)configEntry.get()));
            } else if (configEntry instanceof StringConfig) {
                entryJson.addProperty(key, (String)configEntry.get());
            } else if (configEntry instanceof StringListConfig) {
                JsonArray jsonArray = gson.toJsonTree(configEntry.get()).getAsJsonArray();
                entryJson.add(key, (JsonElement)jsonArray);
            }
            json.add(key, (JsonElement)entryJson);
        }
        try (FileWriter writer = new FileWriter(file);){
            gson.toJson((JsonElement)json, (Appendable)writer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static class BooleanConfig
    extends ConfigEntry<Boolean, BooleanConfig> {
        public BooleanConfig(String key, Boolean defaultValue) {
            super(key, defaultValue);
        }
    }

    public static class IntConfig
    extends ConfigEntry<Integer, IntConfig> {
        private final int min;
        private final int max;

        public IntConfig(String key, Integer defaultValue, int min, int max) {
            super(key, defaultValue);
            this.min = min;
            this.max = max;
        }

        @Override
        public void setValue(Integer value) {
            super.setValue(Math.max(this.min, Math.min(this.max, value)));
        }
    }

    public static class StringConfig
    extends ConfigEntry<String, StringConfig> {
        public StringConfig(String key, String defaultValue) {
            super(key, defaultValue);
        }
    }

    public static class StringListConfig
    extends ConfigEntry<List<String>, StringListConfig> {
        public StringListConfig(String key, List<String> defaultValue) {
            super(key, defaultValue);
        }
    }

    public static abstract class ConfigEntry<T, S extends ConfigEntry<T, S>> {
        private String description;
        private T value;

        public ConfigEntry(String key, T defaultValue) {
            this.value = defaultValue;
            entries.put(key, this);
        }

        public S description(String description) {
            this.description = description;
            return (S)this;
        }

        public T get() {
            return this.value;
        }

        public void setValue(T value) {
            this.value = value;
        }
    }
}

