/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.api;

import carpet.script.CarpetContext;
import carpet.script.Expression;
import carpet.script.exception.InternalExpressionException;
import carpet.script.exception.ThrowStatement;
import carpet.script.exception.Throwables;
import carpet.script.external.Vanilla;
import carpet.script.utils.InputValidator;
import carpet.script.value.BooleanValue;
import carpet.script.value.EntityValue;
import carpet.script.value.FormattedTextValue;
import carpet.script.value.ListValue;
import carpet.script.value.NumericValue;
import carpet.script.value.StringValue;
import carpet.script.value.Value;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.class_124;
import net.minecraft.class_1259;
import net.minecraft.class_2561;
import net.minecraft.class_266;
import net.minecraft.class_268;
import net.minecraft.class_269;
import net.minecraft.class_270;
import net.minecraft.class_274;
import net.minecraft.class_2960;
import net.minecraft.class_2995;
import net.minecraft.class_3002;
import net.minecraft.class_3004;
import net.minecraft.class_3222;
import net.minecraft.class_8646;
import net.minecraft.class_9014;
import net.minecraft.class_9015;

public class Scoreboards {
    private static class_9015 getScoreboardKeyFromValue(Value keyValue) {
        class_9015 class_90152;
        if (keyValue instanceof EntityValue) {
            EntityValue ev = (EntityValue)keyValue;
            class_90152 = ev.getEntity();
        } else {
            class_90152 = class_9015.method_55422((String)keyValue.getString());
        }
        return class_90152;
    }

    public static void apply(Expression expression) {
        expression.addContextFunction("scoreboard", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            class_2995 scoreboard = cc.server().method_3845();
            if (lv.isEmpty()) {
                return ListValue.wrap(scoreboard.method_1163().stream().map(StringValue::new));
            }
            String objectiveName = ((Value)lv.get(0)).getString();
            class_266 objective = scoreboard.method_1170(objectiveName);
            if (objective == null) {
                return Value.NULL;
            }
            if (lv.size() == 1) {
                return ListValue.wrap(scoreboard.method_1184(objective).stream().map(s -> new StringValue(s.comp_2127())));
            }
            class_9015 key = Scoreboards.getScoreboardKeyFromValue((Value)lv.get(1));
            if (lv.size() == 2) {
                return scoreboard.method_55430(key, objective) == null ? Value.NULL : NumericValue.of(scoreboard.method_1180(key, objective).method_55409());
            }
            Value value = (Value)lv.get(2);
            if (value.isNull()) {
                int score = scoreboard.method_1180(key, objective).method_55409();
                scoreboard.method_1155(key, objective);
                return NumericValue.of(score);
            }
            if (value instanceof NumericValue) {
                class_9014 score = scoreboard.method_1180(key, objective);
                int previous = score.method_55409();
                score.method_55410(NumericValue.asNumber(value).getInt());
                return NumericValue.of(previous);
            }
            throw new InternalExpressionException("'scoreboard' requires a number or null as the third parameter");
        });
        expression.addContextFunction("scoreboard_remove", -1, (c, t, lv) -> {
            String objectiveName;
            if (lv.isEmpty()) {
                throw new InternalExpressionException("'scoreboard_remove' requires at least one parameter");
            }
            CarpetContext cc = (CarpetContext)c;
            class_2995 scoreboard = cc.server().method_3845();
            class_266 objective = scoreboard.method_1170(objectiveName = ((Value)lv.get(0)).getString());
            if (objective == null) {
                return Value.FALSE;
            }
            if (lv.size() == 1) {
                scoreboard.method_1194(objective);
                return Value.TRUE;
            }
            class_9015 key = Scoreboards.getScoreboardKeyFromValue((Value)lv.get(1));
            if (scoreboard.method_55430(key, objective) == null) {
                return Value.NULL;
            }
            class_9014 scoreboardPlayerScore = scoreboard.method_1180(key, objective);
            NumericValue previous = new NumericValue(scoreboardPlayerScore.method_55409());
            scoreboard.method_1155(key, objective);
            return previous;
        });
        expression.addContextFunction("scoreboard_add", -1, (c, t, lv) -> {
            class_274 criterion;
            CarpetContext cc = (CarpetContext)c;
            class_2995 scoreboard = cc.server().method_3845();
            if (lv.isEmpty() || lv.size() > 2) {
                throw new InternalExpressionException("'scoreboard_add' should have one or two parameters");
            }
            String objectiveName = ((Value)lv.get(0)).getString();
            if (lv.size() == 1) {
                criterion = class_274.field_1468;
            } else {
                String critetionName = ((Value)lv.get(1)).getString();
                criterion = class_274.method_1224((String)critetionName).orElse(null);
                if (criterion == null) {
                    throw new ThrowStatement(critetionName, Throwables.UNKNOWN_CRITERION);
                }
            }
            class_266 objective = scoreboard.method_1170(objectiveName);
            if (objective != null) {
                c.host.issueDeprecation("reading or modifying an objective's criterion with scoreboard_add");
                if (lv.size() == 1) {
                    return StringValue.of(objective.method_1116().method_1225());
                }
                if (objective.method_1116().equals(criterion) || lv.size() == 1) {
                    return Value.NULL;
                }
                Vanilla.Scoreboard_getObjectivesByCriterion((class_269)scoreboard).get(objective.method_1116()).remove(objective);
                Vanilla.Objective_setCriterion(objective, criterion);
                Vanilla.Scoreboard_getObjectivesByCriterion((class_269)scoreboard).computeIfAbsent(criterion, cr -> Lists.newArrayList()).add(objective);
                scoreboard.method_1185(objective);
                return Value.FALSE;
            }
            scoreboard.method_1168(objectiveName, criterion, (class_2561)class_2561.method_43470((String)objectiveName), criterion.method_1227(), false, null);
            return Value.TRUE;
        });
        expression.addContextFunction("scoreboard_property", -1, (c, t, lv) -> {
            String property;
            if (lv.size() < 2) {
                throw new InternalExpressionException("'scoreboard_property' requires at least two parameters");
            }
            CarpetContext cc = (CarpetContext)c;
            class_2995 scoreboard = cc.server().method_3845();
            class_266 objective = scoreboard.method_1170(((Value)lv.get(0)).getString());
            if (objective == null) {
                return Value.NULL;
            }
            boolean modify = lv.size() > 2;
            Value setValue = null;
            if (modify) {
                setValue = (Value)lv.get(2);
            }
            switch (property = ((Value)lv.get(1)).getString()) {
                case "criterion": {
                    if (modify) {
                        class_274 criterion = class_274.method_1224((String)setValue.getString()).orElse(null);
                        if (criterion == null) {
                            throw new InternalExpressionException("Unknown scoreboard criterion: " + setValue.getString());
                        }
                        if (objective.method_1116().equals(criterion) || lv.size() == 1) {
                            return Value.FALSE;
                        }
                        Vanilla.Scoreboard_getObjectivesByCriterion((class_269)scoreboard).get(objective.method_1116()).remove(objective);
                        Vanilla.Objective_setCriterion(objective, criterion);
                        Vanilla.Scoreboard_getObjectivesByCriterion((class_269)scoreboard).computeIfAbsent(criterion, cr -> Lists.newArrayList()).add(objective);
                        scoreboard.method_1185(objective);
                        return Value.TRUE;
                    }
                    return StringValue.of(objective.method_1116().method_1225());
                }
                case "display_name": {
                    if (modify) {
                        class_2561 text = FormattedTextValue.getTextByValue(setValue);
                        objective.method_1121(text);
                        return Value.TRUE;
                    }
                    return new FormattedTextValue(objective.method_1114());
                }
                case "display_slot": {
                    if (modify) {
                        class_8646 slot = (class_8646)class_8646.field_45175.method_42633(setValue.getString());
                        if (slot == null) {
                            throw new InternalExpressionException("Unknown scoreboard display slot: " + setValue.getString());
                        }
                        if (objective.equals(scoreboard.method_1189(slot))) {
                            return Value.FALSE;
                        }
                        scoreboard.method_1158(slot, objective);
                        return Value.TRUE;
                    }
                    ArrayList<Value> slots = new ArrayList<Value>();
                    for (class_8646 slot : class_8646.values()) {
                        if (scoreboard.method_1189(slot) != objective) continue;
                        slots.add(StringValue.of(slot.method_15434()));
                    }
                    return ListValue.wrap(slots);
                }
                case "render_type": {
                    if (modify) {
                        class_274.class_275 renderType = class_274.class_275.method_1229((String)setValue.getString().toLowerCase());
                        if (objective.method_1118().equals((Object)renderType)) {
                            return Value.FALSE;
                        }
                        objective.method_1115(renderType);
                        return Value.TRUE;
                    }
                    return StringValue.of(objective.method_1118().method_1228());
                }
            }
            throw new InternalExpressionException("scoreboard property '" + property + "' is not a valid property");
        });
        expression.addContextFunction("scoreboard_display", 2, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            class_2995 scoreboard = cc.server().method_3845();
            String location = ((Value)lv.get(0)).getString();
            class_8646 slot = (class_8646)class_8646.field_45175.method_42633(location);
            if (slot == null) {
                throw new InternalExpressionException("Invalid objective slot: " + location);
            }
            Value target = (Value)lv.get(1);
            if (target.isNull()) {
                scoreboard.method_1158(slot, null);
                return StringValue.of(slot.method_15434());
            }
            String objectiveString = target.getString();
            class_266 objective = scoreboard.method_1170(objectiveString);
            if (objective == null) {
                return Value.NULL;
            }
            scoreboard.method_1158(slot, objective);
            return StringValue.of(slot.method_15434());
        });
        expression.addContextFunction("team_list", -1, (c, t, lv) -> {
            if (lv.size() > 1) {
                throw new InternalExpressionException("'team_list' requires zero or one parameters");
            }
            CarpetContext cc = (CarpetContext)c;
            class_2995 scoreboard = cc.server().method_3845();
            if (lv.isEmpty()) {
                return ListValue.wrap(scoreboard.method_1196().stream().map(StringValue::of));
            }
            if (lv.size() != 1) {
                return Value.NULL;
            }
            class_268 team = scoreboard.method_1153(((Value)lv.get(0)).getString());
            return team == null ? Value.NULL : ListValue.wrap(team.method_1204().stream().map(StringValue::of));
        });
        expression.addContextFunction("team_add", -1, (c, t, lv) -> {
            if (lv.size() >= 3 || lv.isEmpty()) {
                throw new InternalExpressionException("'team_add' requires one or two parameters");
            }
            CarpetContext cc = (CarpetContext)c;
            class_2995 scoreboard = cc.server().method_3845();
            String teamName = ((Value)lv.get(0)).getString();
            if (lv.size() == 1) {
                if (scoreboard.method_1153(teamName) != null) {
                    return Value.NULL;
                }
                scoreboard.method_1171(teamName);
                return new StringValue(teamName);
            }
            if (lv.size() != 2) {
                return Value.NULL;
            }
            Value playerVal = (Value)lv.get(1);
            String player = EntityValue.getPlayerNameByValue(playerVal);
            if (player == null) {
                return Value.NULL;
            }
            class_268 team = scoreboard.method_1153(teamName);
            if (team == null) {
                return Value.NULL;
            }
            if (team.method_1206((class_270)scoreboard.method_1164(player))) {
                return Value.FALSE;
            }
            scoreboard.method_1172(player, team);
            return Value.TRUE;
        });
        expression.addContextFunction("team_remove", 1, (c, t, lv) -> {
            Value teamVal;
            CarpetContext cc = (CarpetContext)c;
            class_2995 scoreboard = cc.server().method_3845();
            class_268 team = scoreboard.method_1153((teamVal = (Value)lv.get(0)).getString());
            if (team == null) {
                return Value.NULL;
            }
            scoreboard.method_1191(team);
            return Value.TRUE;
        });
        expression.addContextFunction("team_leave", 1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            class_2995 scoreboard = cc.server().method_3845();
            Value playerVal = (Value)lv.get(0);
            String player = EntityValue.getPlayerNameByValue(playerVal);
            return player == null ? Value.NULL : BooleanValue.of(scoreboard.method_1195(player));
        });
        expression.addContextFunction("team_property", -1, (c, t, lv) -> {
            class_268 team;
            CarpetContext cc = (CarpetContext)c;
            class_2995 scoreboard = cc.server().method_3845();
            if (lv.size() < 2 || lv.size() > 3) {
                throw new InternalExpressionException("'team_property' requires two or three arguments");
            }
            Value teamVal = (Value)lv.get(0);
            Value propertyVal = (Value)lv.get(1);
            Value settingVal = null;
            boolean modifying = false;
            if (lv.size() == 3) {
                modifying = true;
                settingVal = (Value)lv.get(2);
            }
            if ((team = scoreboard.method_1153(teamVal.getString())) == null) {
                return Value.NULL;
            }
            if (!(propertyVal instanceof StringValue)) {
                throw new InternalExpressionException("'team_property' requires a string as the second argument");
            }
            switch (propertyVal.getString()) {
                case "collisionRule": {
                    if (!modifying) {
                        return new StringValue(team.method_1203().field_1436);
                    }
                    if (!(settingVal instanceof StringValue)) {
                        throw new InternalExpressionException("'team_property' requires a string as the third argument for the property " + propertyVal.getString());
                    }
                    class_270.class_271 collisionRule = class_270.class_271.method_1210((String)settingVal.getString());
                    if (collisionRule == null) {
                        throw new InternalExpressionException("Unknown value for property " + propertyVal.getString() + ": " + settingVal.getString());
                    }
                    team.method_1145(collisionRule);
                    break;
                }
                case "color": {
                    if (!modifying) {
                        return new StringValue(team.method_1202().method_537());
                    }
                    if (!(settingVal instanceof StringValue)) {
                        throw new InternalExpressionException("'team_property' requires a string as the third argument for the property " + propertyVal.getString());
                    }
                    class_124 color = class_124.method_533((String)settingVal.getString().toUpperCase());
                    if (color == null || !color.method_543()) {
                        throw new InternalExpressionException("Unknown value for property " + propertyVal.getString() + ": " + settingVal.getString());
                    }
                    team.method_1141(color);
                    break;
                }
                case "deathMessageVisibility": {
                    if (!modifying) {
                        return new StringValue(team.method_1200().field_1445);
                    }
                    if (!(settingVal instanceof StringValue)) {
                        throw new InternalExpressionException("'team_property' requires a string as the third argument for the property " + propertyVal.getString());
                    }
                    class_270.class_272 deathMessageVisibility = class_270.class_272.method_1213((String)settingVal.getString());
                    if (deathMessageVisibility == null) {
                        throw new InternalExpressionException("Unknown value for property " + propertyVal.getString() + ": " + settingVal.getString());
                    }
                    team.method_1133(deathMessageVisibility);
                    break;
                }
                case "displayName": {
                    if (!modifying) {
                        return new FormattedTextValue(team.method_1140());
                    }
                    if (!(settingVal instanceof StringValue)) {
                        throw new InternalExpressionException("'team_property' requires a string or formatted text as the third argument for the property " + propertyVal.getString());
                    }
                    team.method_1137(FormattedTextValue.getTextByValue(settingVal));
                    break;
                }
                case "friendlyFire": {
                    if (!modifying) {
                        return BooleanValue.of(team.method_1205());
                    }
                    if (!(settingVal instanceof NumericValue)) {
                        throw new InternalExpressionException("'team_property' requires a boolean as the third argument for the property " + propertyVal.getString());
                    }
                    team.method_1135(settingVal.getBoolean());
                    break;
                }
                case "nametagVisibility": {
                    if (!modifying) {
                        return new StringValue(team.method_1201().field_1445);
                    }
                    if (!(settingVal instanceof StringValue)) {
                        throw new InternalExpressionException("'team_property' requires a string as the third argument for the property " + propertyVal.getString());
                    }
                    class_270.class_272 nametagVisibility = class_270.class_272.method_1213((String)settingVal.getString());
                    if (nametagVisibility == null) {
                        throw new InternalExpressionException("Unknown value for property " + propertyVal.getString() + ": " + settingVal.getString());
                    }
                    team.method_1149(nametagVisibility);
                    break;
                }
                case "prefix": {
                    if (!modifying) {
                        return new FormattedTextValue(team.method_1144());
                    }
                    if (!(settingVal instanceof StringValue)) {
                        throw new InternalExpressionException("'team_property ' requires a string or formatted text as the third argument for the property " + propertyVal.getString());
                    }
                    team.method_1138(FormattedTextValue.getTextByValue(settingVal));
                    break;
                }
                case "seeFriendlyInvisibles": {
                    if (!modifying) {
                        return BooleanValue.of(team.method_1199());
                    }
                    if (!(settingVal instanceof NumericValue)) {
                        throw new InternalExpressionException("'team_property' requires a boolean as the third argument for the property " + propertyVal.getString());
                    }
                    team.method_1143(settingVal.getBoolean());
                    break;
                }
                case "suffix": {
                    if (!modifying) {
                        return new FormattedTextValue(team.method_1136());
                    }
                    if (!(settingVal instanceof StringValue)) {
                        throw new InternalExpressionException("'team_property' requires a string or formatted text as the third argument for the property " + propertyVal.getString());
                    }
                    team.method_1139(FormattedTextValue.getTextByValue(settingVal));
                    break;
                }
                default: {
                    throw new InternalExpressionException("team property '" + propertyVal.getString() + "' is not a valid property");
                }
            }
            return Value.TRUE;
        });
        expression.addContextFunction("bossbar", -1, (c, t, lv) -> {
            class_3004 bossBarManager = ((CarpetContext)c).server().method_3837();
            if (lv.size() > 3) {
                throw new InternalExpressionException("'bossbar' accepts max three arguments");
            }
            if (lv.isEmpty()) {
                return ListValue.wrap(bossBarManager.method_12969().stream().map(class_3002::method_12959).map(class_2960::toString).map(StringValue::of));
            }
            String id = ((Value)lv.get(0)).getString();
            class_2960 identifier = InputValidator.identifierOf(id);
            if (lv.size() == 1) {
                if (bossBarManager.method_12971(identifier) != null) {
                    return Value.FALSE;
                }
                return StringValue.of(bossBarManager.method_12970(identifier, (class_2561)class_2561.method_43470((String)id)).method_12959().toString());
            }
            String property = ((Value)lv.get(1)).getString();
            class_3002 bossBar = bossBarManager.method_12971(identifier);
            if (bossBar == null) {
                return Value.NULL;
            }
            Value propertyValue = lv.size() == 3 ? (Value)lv.get(2) : null;
            switch (property) {
                case "color": {
                    if (propertyValue == null) {
                        class_1259.class_1260 color = bossBar.method_5420();
                        return color == null ? Value.NULL : StringValue.of(color.method_5421());
                    }
                    class_1259.class_1260 color = class_1259.class_1260.method_5422((String)propertyValue.getString());
                    if (color == null) {
                        return Value.NULL;
                    }
                    bossBar.method_5416(class_1259.class_1260.method_5422((String)propertyValue.getString()));
                    return Value.TRUE;
                }
                case "max": {
                    if (propertyValue == null) {
                        return NumericValue.of(bossBar.method_12960());
                    }
                    if (!(propertyValue instanceof NumericValue)) {
                        throw new InternalExpressionException("'bossbar' requires a number as the value for the property " + property);
                    }
                    NumericValue number = (NumericValue)propertyValue;
                    bossBar.method_12956(number.getInt());
                    return Value.TRUE;
                }
                case "name": {
                    if (propertyValue == null) {
                        return new FormattedTextValue(bossBar.method_5414());
                    }
                    bossBar.method_5413(FormattedTextValue.getTextByValue(propertyValue));
                    return Value.TRUE;
                }
                case "add_player": {
                    if (propertyValue == null) {
                        throw new InternalExpressionException("Bossbar property " + property + " can't be queried, add a third parameter");
                    }
                    if (propertyValue instanceof ListValue) {
                        ListValue list = (ListValue)propertyValue;
                        list.getItems().forEach(v -> {
                            class_3222 player = EntityValue.getPlayerByValue(((CarpetContext)c).server(), propertyValue);
                            if (player != null) {
                                bossBar.method_14088(player);
                            }
                        });
                        return Value.TRUE;
                    }
                    class_3222 player = EntityValue.getPlayerByValue(((CarpetContext)c).server(), propertyValue);
                    if (player != null) {
                        bossBar.method_14088(player);
                        return Value.TRUE;
                    }
                    return Value.FALSE;
                }
                case "players": {
                    if (propertyValue == null) {
                        return ListValue.wrap(bossBar.method_14092().stream().map(EntityValue::new));
                    }
                    if (propertyValue instanceof ListValue) {
                        ListValue list = (ListValue)propertyValue;
                        bossBar.method_14094();
                        list.getItems().forEach(v -> {
                            class_3222 p = EntityValue.getPlayerByValue(((CarpetContext)c).server(), v);
                            if (p != null) {
                                bossBar.method_14088(p);
                            }
                        });
                        return Value.TRUE;
                    }
                    class_3222 p = EntityValue.getPlayerByValue(((CarpetContext)c).server(), propertyValue);
                    bossBar.method_14094();
                    if (p != null) {
                        bossBar.method_14088(p);
                        return Value.TRUE;
                    }
                    return Value.FALSE;
                }
                case "style": {
                    if (propertyValue == null) {
                        return StringValue.of(bossBar.method_5415().method_5425());
                    }
                    class_1259.class_1261 style = class_1259.class_1261.method_5424((String)propertyValue.getString());
                    if (style == null) {
                        throw new InternalExpressionException("'" + propertyValue.getString() + "' is not a valid value for property " + property);
                    }
                    bossBar.method_5409(style);
                    return Value.TRUE;
                }
                case "value": {
                    if (propertyValue == null) {
                        return NumericValue.of(bossBar.method_12955());
                    }
                    if (!(propertyValue instanceof NumericValue)) {
                        throw new InternalExpressionException("'bossbar' requires a number as the value for the property " + property);
                    }
                    NumericValue number = (NumericValue)propertyValue;
                    bossBar.method_12954(number.getInt());
                    return Value.TRUE;
                }
                case "visible": {
                    if (propertyValue == null) {
                        return BooleanValue.of(bossBar.method_14093());
                    }
                    bossBar.method_14091(propertyValue.getBoolean());
                    return Value.TRUE;
                }
                case "remove": {
                    bossBarManager.method_12973(bossBar);
                    return Value.TRUE;
                }
            }
            throw new InternalExpressionException("Unknown bossbar property " + property);
        });
    }
}

