/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.input;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import mezz.jei.common.gui.elements.DrawableNineSliceTexture;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.common.platform.IPlatformScreenHelper;
import mezz.jei.common.platform.Services;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.core.util.TextHistory;
import mezz.jei.gui.input.IUserInputHandler;
import mezz.jei.gui.input.handlers.TextFieldInputHandler;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_5244;
import org.jetbrains.annotations.Nullable;

public class GuiTextFieldFilter
extends class_342 {
    private static final int maxSearchLength = 128;
    private static final TextHistory history = new TextHistory();
    private final BooleanSupplier filterEmpty;
    private ImmutableRect2i area;
    private final DrawableNineSliceTexture background;
    private ImmutableRect2i backgroundBounds;
    @Nullable
    private class_339 previouslyFocusedWidget;

    public GuiTextFieldFilter(Textures textures, BooleanSupplier filterEmpty) {
        super(class_310.method_1551().field_1772, 0, 0, 0, 0, class_5244.field_39003);
        this.filterEmpty = filterEmpty;
        this.method_1880(128);
        this.area = ImmutableRect2i.EMPTY;
        this.background = textures.getSearchBackground();
        this.backgroundBounds = ImmutableRect2i.EMPTY;
        this.method_1858(false);
    }

    public void updateBounds(ImmutableRect2i area) {
        this.backgroundBounds = area;
        this.method_46421(area.getX() + 4);
        this.method_46419(area.getY() + (area.getHeight() - 8) / 2);
        this.field_22758 = area.getWidth() - 12;
        this.field_22759 = area.getHeight();
        this.area = area;
    }

    public void method_1852(String filterText) {
        if (!filterText.equals(this.method_1882())) {
            super.method_1852(filterText);
        }
        int color = this.filterEmpty.getAsBoolean() ? -65536 : -1;
        this.method_1868(color);
    }

    public Optional<String> getHistory(TextHistory.Direction direction) {
        String currentText = this.method_1882();
        return history.get(direction, currentText);
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return this.area.contains(mouseX, mouseY);
    }

    public IUserInputHandler createInputHandler() {
        return new TextFieldInputHandler(this);
    }

    public void method_25365(boolean keyboardFocus) {
        boolean previousFocus = this.method_25370();
        super.method_25365(keyboardFocus);
        if (previousFocus != keyboardFocus) {
            class_310 minecraft = class_310.method_1551();
            if (keyboardFocus) {
                screen = minecraft.field_1755;
                if (screen != null) {
                    class_364 class_3642 = screen.method_25399();
                    if (class_3642 instanceof class_339) {
                        class_339 widget = (class_339)class_3642;
                        IPlatformScreenHelper screenHelper = Services.PLATFORM.getScreenHelper();
                        screenHelper.setFocused(widget, false);
                        this.previouslyFocusedWidget = widget;
                    }
                    screen.method_25395(null);
                }
            } else if (this.previouslyFocusedWidget != null) {
                screen = minecraft.field_1755;
                if (screen != null) {
                    IPlatformScreenHelper screenHelper = Services.PLATFORM.getScreenHelper();
                    screenHelper.setFocused(this.previouslyFocusedWidget, true);
                    screen.method_25395((class_364)this.previouslyFocusedWidget);
                }
                this.previouslyFocusedWidget = null;
            }
            String text = this.method_1882();
            history.add(text);
        }
    }

    public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.method_1885()) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.background.draw(guiGraphics, this.backgroundBounds);
        }
        super.method_48579(guiGraphics, mouseX, mouseY, partialTicks);
    }
}

