/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.cartography.color;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import journeymap.client.texture.TextureCache;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import net.minecraft.class_1011;
import net.minecraft.class_1058;
import net.minecraft.class_2960;
import net.minecraft.class_777;
import org.apache.logging.log4j.Logger;

@ParametersAreNonnullByDefault
public class ColoredSprite {
    private static Logger logger = Journeymap.getLogger();
    private final Integer color;
    private final class_1058 sprite;

    public ColoredSprite(class_1058 sprite, @Nullable Integer color) {
        this.sprite = sprite;
        this.color = null;
    }

    public ColoredSprite(class_777 quad) {
        this.sprite = quad.method_35788();
        this.color = null;
    }

    public String getIconName() {
        return this.sprite.method_45851().method_45816().method_12832();
    }

    @Nullable
    public Integer getColor() {
        return this.color;
    }

    public boolean hasColor() {
        return this.color != null;
    }

    @Nullable
    public class_1011 getColoredImage() {
        try {
            class_2960 resourceLocation = class_2960.method_60654((String)this.getIconName());
            if (resourceLocation.equals((Object)class_2960.method_60654((String)"missingno"))) {
                return null;
            }
            class_1011 image = this.sprite.method_45851().field_40540[0];
            if (image == null || image.method_4307() == 0) {
                image = this.getImageResource(this.sprite);
            }
            if (image == null || image.method_4307() == 0) {
                return null;
            }
            return image;
        }
        catch (Throwable e1) {
            if (logger.isDebugEnabled()) {
                logger.error("ColoredSprite: Error getting image for " + this.getIconName() + ": " + LogFormatter.toString(e1));
            }
            return null;
        }
    }

    private class_1011 getImageResource(class_1058 tas) {
        try {
            class_2960 iconNameLoc = class_2960.method_60654((String)tas.method_45851().method_45816().method_12832());
            class_2960 fileLoc = class_2960.method_60655((String)iconNameLoc.method_12836(), (String)("textures/" + iconNameLoc.method_12832() + ".png"));
            return TextureCache.resolveImage(fileLoc);
        }
        catch (Throwable t) {
            logger.error(String.format("ColoredSprite: Unable to use texture file for %s: %s", tas.method_45851().method_45816().method_12832(), t.getMessage()));
            return null;
        }
    }
}

