/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.render.draw;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import journeymap.client.JourneymapClient;
import journeymap.client.data.DataCache;
import journeymap.client.render.draw.DrawWayPointStep;
import journeymap.client.render.map.Renderer;
import journeymap.client.waypoint.ClientWaypointImpl;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_746;

public class WaypointDrawStepFactory {
    final List<DrawWayPointStep> drawStepList = new ArrayList<DrawWayPointStep>();

    public List<DrawWayPointStep> prepareSteps(Collection<ClientWaypointImpl> waypoints, Renderer renderer, boolean checkDistance, boolean showLabel) {
        class_310 mc = class_310.method_1551();
        class_746 player = mc.field_1724;
        int maxDistance = JourneymapClient.getInstance().getWaypointProperties().maxDistance.get();
        float waypointLabelScale = JourneymapClient.getInstance().getFullMapProperties().waypointLabelScale.get().floatValue();
        float waypointIconScale = JourneymapClient.getInstance().getFullMapProperties().waypointIconScale.get().floatValue();
        checkDistance = checkDistance && maxDistance > 0;
        class_243 playerVec = checkDistance ? player.method_19538() : null;
        this.drawStepList.clear();
        try {
            for (ClientWaypointImpl waypoint : waypoints) {
                DrawWayPointStep wayPointStep;
                double actualDistance;
                if (!waypoint.isEnabled() || !waypoint.isInPlayerDimension() || checkDistance && (actualDistance = playerVec.method_1022(waypoint.getPosition())) > (double)maxDistance || (wayPointStep = DataCache.INSTANCE.getDrawWayPointStep(waypoint)) == null) continue;
                this.drawStepList.add(wayPointStep);
                wayPointStep.setShowLabel(showLabel);
                wayPointStep.setLabelScale(waypointLabelScale);
                wayPointStep.setIconScale(waypointIconScale);
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("Error during prepareSteps: " + LogFormatter.toString(t));
        }
        return this.drawStepList;
    }
}

