/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.texture;

import it.unimi.dsi.fastutil.floats.Float2ObjectMap;
import it.unimi.dsi.fastutil.floats.Float2ObjectOpenHashMap;
import java.io.IOException;
import journeymap.client.cartography.color.RGB;
import journeymap.client.texture.DynamicTextureImpl;
import journeymap.client.texture.ImageUtil;
import journeymap.client.texture.Texture;
import net.minecraft.class_1011;
import net.minecraft.class_1049;
import net.minecraft.class_1084;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3270;
import net.minecraft.class_3298;
import net.minecraft.class_3300;

public class SimpleTextureImpl
extends class_1049
implements Texture {
    private final class_2960 location;
    private final Float2ObjectMap<Texture> scaledImageMap = new Float2ObjectOpenHashMap();
    private float alpha;
    private class_1049.class_4006 textureData;
    private Integer renderWidth;
    private Integer renderHeight;

    public SimpleTextureImpl(class_2960 location) {
        super(location);
        this.location = location;
        this.textureData = super.method_18153(class_310.method_1551().method_1478());
    }

    @Override
    public int getWidth() {
        try {
            return this.renderWidth == null ? this.textureData.method_18157().method_4307() : this.renderWidth.intValue();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int getHeight() {
        try {
            return this.renderHeight == null ? this.textureData.method_18157().method_4323() : this.renderHeight.intValue();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setDisplayWidth(int width) {
        this.renderWidth = width;
    }

    @Override
    public void setDisplayHeight(int height) {
        this.renderHeight = height;
    }

    public void resize(float scale) {
        try {
            class_1011 newImg = ImageUtil.getScaledImage(scale, this.textureData.method_18157(), false);
            this.setNativeImage(newImg);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Texture getScaledImage(float drawScale) {
        if (drawScale == 1.0f) {
            return this;
        }
        Texture scaledTexture = (Texture)this.scaledImageMap.get(drawScale);
        try {
            if (scaledTexture == null) {
                scaledTexture = new DynamicTextureImpl(ImageUtil.getScaledImage(drawScale, this.textureData.method_18157(), false), drawScale);
                this.scaledImageMap.put(drawScale, (Object)scaledTexture);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return scaledTexture;
    }

    @Override
    public Integer getRGB(int x, int y) {
        int rgba = this.getNativeImage().method_4315(x, y);
        return RGB.rgbaToRgb(rgba);
    }

    @Override
    public int getTextureId() {
        return super.method_4624();
    }

    @Override
    public boolean hasImage() {
        return this.textureData != null;
    }

    @Override
    public void remove() {
        this.close();
    }

    @Override
    public void setNativeImage(class_1011 image) {
        this.textureData.close();
        this.textureData = this.updateImage(class_310.method_1551().method_1478(), image);
    }

    public void close() {
        if (this.getNativeImage() != null) {
            this.scaledImageMap.values().forEach(Texture::remove);
            this.getNativeImage().close();
            this.textureData.close();
            this.method_4528();
            this.textureData = null;
        }
    }

    @Override
    public class_1011 getNativeImage() {
        try {
            return this.textureData.method_18157();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public class_2960 getLocation() {
        return this.location;
    }

    @Override
    public float getAlpha() {
        return this.alpha;
    }

    @Override
    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }

    private class_1049.class_4006 updateImage(class_3300 pResourceManager, class_1011 nativeimage) {
        try {
            class_3298 resource = (class_3298)pResourceManager.method_14486(this.location).get();
            class_1084 texturemetadatasection = null;
            try {
                texturemetadatasection = resource.method_14481().method_43041((class_3270)class_1084.field_5344).orElse(null);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            class_1049.class_4006 image = new class_1049.class_4006(texturemetadatasection, nativeimage);
            return image;
        }
        catch (IOException ioexception) {
            return new class_1049.class_4006(ioexception);
        }
    }

    @Override
    public void release() {
        super.method_4528();
    }
}

