/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.colorpalette;

import java.util.ArrayList;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.IntStream;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.cartography.color.ColorManager;
import journeymap.client.cartography.color.ColorPalette;
import journeymap.client.model.BlockMD;
import journeymap.client.properties.CoreProperties;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.colorpalette.ColorPaletteItem;
import journeymap.client.ui.colorpalette.DomainDropDownButton;
import journeymap.client.ui.colorpalette.PaletteDropDownButton;
import journeymap.client.ui.colorpalette.SortButton;
import journeymap.client.ui.component.ScrollListPane;
import journeymap.client.ui.component.SearchTextBox;
import journeymap.client.ui.component.buttons.Button;
import journeymap.client.ui.component.screens.JmUI;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_7923;
import net.minecraft.class_8016;
import net.minecraft.class_8021;
import net.minecraft.class_8667;

public class ColorPaletteScreen
extends JmUI {
    private final class_2561 labelClose = class_2561.method_43471((String)"jm.common.close");
    private final class_2561 labelManagePalettes = class_2561.method_43471((String)"jm.colorpalette.manage_palettes");
    private final class_2561 labelModsAndPlayers = class_2561.method_43471((String)"jm.colorpalette.mobs_and_players");
    static final String ASCEND = "\u25b2";
    static final String DESCEND = "\u25bc";
    private static ColorPaletteItem.Sort currentSort;
    private static String searchString;
    protected ScrollListPane itemScrollPane;
    protected int rowHeight = 36;
    private SortButton buttonSortName;
    private SortButton buttonSortId;
    private DomainDropDownButton buttonDomains;
    private PaletteDropDownButton buttonPalettes;
    private SearchTextBox searchText;
    private ArrayList<ColorPaletteItem> items = new ArrayList();
    private boolean remapNeeded = false;

    public ColorPaletteScreen(class_437 returnDisplay) {
        super(Constants.getString("jm.colorpalette.manage_colors_title"), true, returnDisplay);
    }

    @Override
    public void method_25426() {
        super.method_25426();
        class_8667 leftHeaderButtons = class_8667.method_52742();
        leftHeaderButtons.method_52735(4).method_52740();
        this.buttonDomains = (DomainDropDownButton)leftHeaderButtons.method_52736((class_8021)new DomainDropDownButton(ColorManager.INSTANCE.getDefaultPalette(), b -> this.updateItems()));
        boolean hasGlobal = !ColorManager.INSTANCE.getGlobalPalette().isEmpty();
        boolean hasWorld = !ColorManager.INSTANCE.getWorldPalette().isEmpty();
        this.buttonPalettes = (PaletteDropDownButton)leftHeaderButtons.method_52736((class_8021)new PaletteDropDownButton(hasGlobal, hasWorld, b -> this.updateItems()));
        this.buttonPalettes.setVisible(hasGlobal || hasWorld);
        this.topLeftHeader.method_46441((class_8021)leftHeaderButtons);
        class_8667 bottomHeaderButtons = class_8667.method_52742();
        bottomHeaderButtons.method_52735(4).method_52740();
        ColorPaletteItem.NameComparator nameSort = new ColorPaletteItem.NameComparator(true);
        this.buttonSortName = (SortButton)bottomHeaderButtons.method_52736((class_8021)new SortButton(Constants.getString("jm.colorpalette.name"), nameSort, this::sortButtonPressed));
        this.buttonSortName.setTextOnly(this.getFontRenderer());
        this.buttonSortName.drawUnderline(true);
        ColorPaletteItem.IdComparator idSort = new ColorPaletteItem.IdComparator(true);
        this.buttonSortId = (SortButton)bottomHeaderButtons.method_52736((class_8021)new SortButton(Constants.getString("jm.colorpalette.id"), idSort, this::sortButtonPressed));
        this.buttonSortId.setTextOnly(this.getFontRenderer());
        this.buttonSortId.drawUnderline(true);
        this.bottomHeader.method_46441((class_8021)bottomHeaderButtons);
        this.searchText = (SearchTextBox)this.topRightHeader.method_46441((class_8021)new SearchTextBox(searchString, this.field_22793, 100, 20, false, false));
        this.searchText.setResponder(t -> this.updateItems());
        this.searchText.setMinLength(0);
        this.footerLayout.method_52736((class_8021)Button.method_46430((class_2561)this.labelModsAndPlayers, b -> UIManager.INSTANCE.openMobsAndPlayersColorEditor(this)).method_46432(this.field_22793.method_27525((class_5348)this.labelModsAndPlayers) + 10).method_46431());
        this.footerLayout.method_52736((class_8021)Button.method_46430((class_2561)this.labelManagePalettes, b -> UIManager.INSTANCE.openColorPaletteManager(this)).method_46432(this.field_22793.method_27525((class_5348)this.labelManagePalettes) + 10).method_46431());
        this.footerLayout.method_52736((class_8021)Button.method_46430((class_2561)this.labelClose, b -> this.refreshAndClose()).method_46432(this.field_22793.method_27525((class_5348)this.labelClose) + 10).method_46431());
        Objects.requireNonNull(this);
        Objects.requireNonNull(this);
        Objects.requireNonNull(this);
        this.itemScrollPane = (ScrollListPane)this.contentLayout.method_46441(new ScrollListPane(this.field_22787, 0, 36, this.field_22789, this.field_22790 - 36 - 30, this.rowHeight));
        SortButton sortButton = this.getInitialSort();
        currentSort = sortButton.sort;
        this.updateSort(sortButton);
        this.method_48640();
    }

    @Override
    protected void method_48640() {
        this.updateItems();
        Objects.requireNonNull(this);
        Objects.requireNonNull(this);
        Objects.requireNonNull(this);
        this.itemScrollPane.updateSize(this.field_22789, this.field_22790 - 36 - 30, 0, 36);
        this.itemScrollPane.setListWidth(this.panelWidth());
        this.itemScrollPane.method_25307(this.itemScrollPane.method_25341());
        super.method_48640();
    }

    @Override
    public void method_25394(class_332 graphics, int x, int y, float partialTicks) {
        this.buttonSortName.setEnabled(!this.items.isEmpty());
        this.buttonSortId.setEnabled(!this.items.isEmpty());
        super.method_25394(graphics, x, y, partialTicks);
    }

    @Override
    public void method_25420(class_332 graphics, int x, int y, float partialTicks) {
    }

    public boolean method_25402(double mouseX, double mouseY, int mouseButton) {
        if (this.searchText.mouseOver(mouseX, mouseY)) {
            this.searchText.method_25402(mouseX, mouseY, mouseButton);
            super.method_25395((class_364)this.searchText);
            return true;
        }
        return super.method_25402(mouseX, mouseY, mouseButton);
    }

    public boolean method_25400(char typedChar, int keyCode) {
        if (this.searchText.method_25367()) {
            return this.searchText.method_25400(typedChar, keyCode);
        }
        return super.method_25400(typedChar, keyCode);
    }

    public void method_48263(class_8016 path) {
        super.method_48263(path);
    }

    public void copyBlock(String blockID, boolean globalToWorld) {
        ColorPalette worldPalette = ColorManager.INSTANCE.getWorldPalette();
        ColorPalette globalPalette = ColorManager.INSTANCE.getGlobalPalette();
        if (globalToWorld) {
            worldPalette.copyFromPalette(globalPalette, blockID);
        } else {
            globalPalette.copyFromPalette(worldPalette, blockID);
        }
        ColorPaletteItem selected = (ColorPaletteItem)this.itemScrollPane.method_25334();
        this.updateItems();
        if (selected != null) {
            this.selectItem(selected.blockID, selected.palette);
        }
        this.setRemapNeeded();
    }

    public void removeFromPalette(String blockID, ColorPalette.Type type) {
        ColorPalette palette = type == ColorPalette.Type.Global ? ColorManager.INSTANCE.getGlobalPalette() : ColorManager.INSTANCE.getWorldPalette();
        palette.remove(blockID);
        this.updateItems();
        this.selectItem(blockID, ColorManager.INSTANCE.getDefaultPalette());
        this.setRemapNeeded();
    }

    public void setRemapNeeded() {
        this.remapNeeded = true;
    }

    protected void selectItem(String blockID, ColorPalette palette) {
        if (this.items.isEmpty()) {
            return;
        }
        int index = IntStream.range(0, this.items.size()).filter(i -> blockID.equals(this.items.get((int)i).blockID) && palette == this.items.get((int)i).palette).findFirst().orElse(0);
        ColorPaletteItem toSelect = (ColorPaletteItem)this.itemScrollPane.getSlot(index);
        this.itemScrollPane.method_25395((class_364)toSelect);
        toSelect.focusEditButton();
    }

    protected void updateItems() {
        ColorPaletteItem item;
        if (this.searchText == null) {
            return;
        }
        boolean hasGlobal = !ColorManager.INSTANCE.getGlobalPalette().isEmpty();
        boolean hasWorld = !ColorManager.INSTANCE.getWorldPalette().isEmpty();
        this.buttonPalettes.setValidPalettes(hasGlobal, hasWorld);
        this.buttonPalettes.setVisible(hasGlobal || hasWorld);
        this.items.clear();
        String domain = DomainDropDownButton.currentDomain;
        searchString = this.searchText.getText();
        boolean all = PaletteDropDownButton.currentPalette.equals("all");
        ColorPalette defaultPalette = ColorManager.INSTANCE.getDefaultPalette();
        if (all) {
            for (String blockID : defaultPalette.getAllBlocks()) {
                if (!this.filterDomain(domain, blockID) || !this.filterSearch(searchString, blockID)) continue;
                ColorPaletteItem item2 = new ColorPaletteItem(defaultPalette, blockID, false, this.getFontRenderer(), this);
                this.items.add(item2);
            }
        }
        boolean global = PaletteDropDownButton.currentPalette.equals("global");
        boolean world = PaletteDropDownButton.currentPalette.equals("world");
        if (all || global) {
            ColorPalette globalPalette = ColorManager.INSTANCE.getGlobalPalette();
            for (String blockID : globalPalette.getAllBlocks()) {
                if (!this.filterDomain(domain, blockID) || !this.filterSearch(searchString, blockID) || !defaultPalette.hasBlockID(blockID)) continue;
                item = new ColorPaletteItem(globalPalette, blockID, all, this.getFontRenderer(), this);
                this.items.add(item);
            }
        }
        if (all || world) {
            ColorPalette worldPalette = ColorManager.INSTANCE.getWorldPalette();
            for (String blockID : worldPalette.getAllBlocks()) {
                if (!this.filterDomain(domain, blockID) || !this.filterSearch(searchString, blockID) || !defaultPalette.hasBlockID(blockID)) continue;
                item = new ColorPaletteItem(worldPalette, blockID, all, this.getFontRenderer(), this);
                this.items.add(item);
            }
        }
        this.items.sort(currentSort);
        this.itemScrollPane.setSlots(this.items);
        this.itemScrollPane.method_25307(this.itemScrollPane.method_25341());
    }

    private int panelWidth() {
        return (int)Math.min((double)this.field_22789, 960.0 * ColorPaletteScreen.calculateScaleFactor());
    }

    private boolean filterDomain(String domain, String blockID) {
        return domain == null || domain.isEmpty() || class_2960.method_60654((String)blockID).method_12836().equals(domain);
    }

    private boolean filterSearch(String search, String blockID) {
        if (search == null || search.isEmpty()) {
            return true;
        }
        search = search.toLowerCase(Locale.ROOT);
        String blockName = BlockMD.getBlockName((class_2248)class_7923.field_41175.method_10223(class_2960.method_60654((String)blockID))).toLowerCase(Locale.ROOT);
        return blockID.toLowerCase(Locale.ROOT).contains(search) || blockName.contains(search);
    }

    private void sortButtonPressed(class_4185 button) {
        SortButton sortButton = (SortButton)button;
        sortButton.toggle();
        if (!sortButton.sort.equals(currentSort) && sortButton.sort.ascending != ColorPaletteScreen.currentSort.ascending) {
            sortButton.toggle();
        }
        this.updateSort(sortButton);
        this.items.sort(currentSort);
        this.itemScrollPane.setSlots(this.items);
    }

    private void updateSort(SortButton sortButton) {
        for (class_4068 button : this.getRenderables()) {
            if (!(button instanceof SortButton)) continue;
            if (button == sortButton) {
                if (!sortButton.sort.equals(currentSort)) {
                    sortButton.setActive(true);
                }
                this.updateSortProperty(sortButton);
                currentSort = sortButton.sort;
                continue;
            }
            ((SortButton)button).setActive(false);
        }
    }

    protected void refreshAndClose() {
        this.closeAndReturn();
    }

    @Override
    protected void closeAndReturn() {
        if (this.remapNeeded) {
            ColorManager.INSTANCE.applyColors();
            ColorManager.INSTANCE.savePalettes();
        }
        if (returnDisplayStack == null || returnDisplayStack.peek() == null) {
            UIManager.INSTANCE.closeAll();
        } else {
            UIManager.INSTANCE.open((class_437)returnDisplayStack.pop());
        }
    }

    private SortButton getInitialSort() {
        CoreProperties prop = JourneymapClient.getInstance().getCoreProperties();
        boolean ascending = prop.sortAscending.get();
        SortButton button = switch ((ColorPaletteItem.SortType)((Object)prop.initialSortOrder.get())) {
            default -> throw new MatchException(null, null);
            case ColorPaletteItem.SortType.Id -> this.buttonSortId;
            case ColorPaletteItem.SortType.Name -> this.buttonSortName;
        };
        button.sort.ascending = ascending;
        button.setToggled(ascending);
        return button;
    }

    private void updateSortProperty(SortButton sortButton) {
        CoreProperties prop = JourneymapClient.getInstance().getCoreProperties();
        if (sortButton == this.buttonSortName) {
            prop.initialSortOrder.set(ColorPaletteItem.SortType.Name);
        } else {
            prop.initialSortOrder.set(ColorPaletteItem.SortType.Id);
        }
        prop.sortAscending.set(sortButton.sort.ascending);
    }

    static {
        searchString = "";
    }
}

