/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component;

import java.awt.Color;
import java.util.List;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.ui.component.ScrollListPane;
import journeymap.client.ui.component.Slot;
import journeymap.client.ui.option.CategorySlot;
import journeymap.client.ui.option.SlotMetadata;
import net.minecraft.class_310;
import net.minecraft.class_332;

public class DraggableListPane<T extends Slot>
extends ScrollListPane<T> {
    private boolean clicked = false;
    private Integer frameColor = new Color(-6250336).getRGB();
    private boolean dragging = false;
    private boolean didDrag = false;
    private int mouseDragOffsetX = 0;
    private int mouseDragOffsetY = 0;

    public DraggableListPane(class_310 mc, int width, int height, int x, int y) {
        super(mc, x, y, width, height, 20);
        super.method_46421(x);
        super.method_46419(y);
    }

    @Override
    public void setSlots(List<T> slots) {
        int newWidth = this.field_22758;
        int newHeight = this.field_22759;
        super.setSlots(slots);
        for (Slot slot : this.getRootSlots()) {
            if (!(slot instanceof CategorySlot)) continue;
            newHeight = ((CategorySlot)slot).getAllChildMetadata().size() * 25;
            for (SlotMetadata child : ((CategorySlot)slot).getAllChildMetadata()) {
                String name = child.getName();
                int sWidth = class_310.method_1551().field_1772.method_1727(name) * 2;
                newWidth = Math.max(sWidth, newWidth);
            }
        }
        this.updateSize(newWidth, newHeight, 0, super.method_46427());
    }

    @Override
    public void updateSize(int width, int height, int x, int y) {
        super.method_55444(width, height, x, y);
        this.listWidth = this.field_22758 - this.hpad * 4;
        this.scrollbarX = this.field_22758 - this.hpad + super.method_46426();
    }

    @Override
    protected void renderBackground(class_332 graphics, int x, int y, float partialTicks) {
        if (this.clicked) {
            graphics.method_25296(super.method_46426(), super.method_46427(), super.method_55442(), super.method_55443(), -1072689136, -804253680);
            float alpha = 1.0f;
            DrawUtil.drawRectangle(graphics, super.method_46426() - 1, super.method_46427() - 1, this.field_22758 + 2, 1.0, this.frameColor, alpha);
            DrawUtil.drawRectangle(graphics, super.method_46426() - 1, super.method_46427() + this.field_22759, this.field_22758 + 2, 1.0, this.frameColor, alpha);
            DrawUtil.drawRectangle(graphics, super.method_46426() - 1, super.method_46427() - 1, 1.0, this.field_22759 + 1, this.frameColor, alpha);
            DrawUtil.drawRectangle(graphics, this.field_22758 + super.method_46426(), super.method_46427() - 1, 1.0, this.field_22759 + 2, this.frameColor, alpha);
        }
    }

    @Override
    public boolean method_25402(double pMouseX, double pMouseY, int pButton) {
        boolean paneClicked = false;
        if (super.method_25405(pMouseX, pMouseY) && !(this.method_25308(pMouseX, pMouseY) instanceof CategorySlot)) {
            paneClicked = super.method_25402(pMouseX, pMouseY, pButton);
        } else if (super.method_25405(pMouseX, pMouseY) && this.method_25308(pMouseX, pMouseY) instanceof CategorySlot) {
            this.mouseDragOffsetX = (int)(pMouseX - (double)super.method_46426());
            this.mouseDragOffsetY = (int)(pMouseY - (double)super.method_46427());
            this.dragging = true;
        }
        return paneClicked;
    }

    @Override
    public boolean method_25403(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (this.dragging) {
            this.didDrag = true;
            int posX = (int)(pMouseX - (double)this.mouseDragOffsetX);
            int posY = (int)(pMouseY - (double)this.mouseDragOffsetY);
            this.updatePosition(posX, posY);
        }
        return super.method_25403(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    protected void method_44398(class_332 graphics, int top, int width, int height, int outerColor, int innerColor) {
        int i = this.method_46426() + (this.field_22758 - width) / 2;
        int j = this.method_46426() + (this.field_22758 + width + 8) / 2;
        graphics.method_25294(i, top - 2, j, top + height + 2, outerColor);
        graphics.method_25294(i + 1, top - 1, j - 1, top + height + 1, innerColor);
    }

    @Override
    public boolean method_25406(double mouseX, double mouseY, int mouseButton) {
        if (this.dragging && this.didDrag) {
            this.didDrag = false;
            this.dragging = false;
        } else if (super.method_25405(mouseX, mouseY) && this.method_25308(mouseX, mouseY) instanceof CategorySlot) {
            this.didDrag = false;
            this.dragging = false;
            super.method_25402(mouseX, mouseY, mouseButton);
            CategorySlot slot = (CategorySlot)this.method_25308(mouseX, mouseY);
            this.clicked = slot.isSelected();
        }
        return super.method_25406(mouseX, mouseY, mouseButton);
    }

    public void updatePosition(int x, int y) {
        super.method_48229(x, y);
        this.scrollbarX = this.field_22758 - this.hpad + super.method_46426();
        this.listWidth = this.field_22758 - this.hpad * 4;
    }

    @Override
    public int method_25364() {
        return this.field_22759;
    }

    public int method_25368() {
        return this.field_22758;
    }

    public boolean isClicked() {
        return this.clicked;
    }

    public void setClicked(boolean clicked) {
        this.clicked = clicked;
    }
}

