/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.waypoint;

import java.awt.Color;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import journeymap.api.common.waypoint.WaypointFactoryImpl;
import journeymap.api.v2.common.waypoint.Waypoint;
import journeymap.api.v2.common.waypoint.WaypointGroup;
import journeymap.client.Constants;
import journeymap.client.log.JMLogger;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.ui.component.ScrollListPane;
import journeymap.client.ui.component.Slot;
import journeymap.client.ui.component.buttons.Button;
import journeymap.client.ui.component.popupscreenbutton.PopupButton;
import journeymap.client.ui.component.screens.TwoColumnScreen;
import journeymap.client.ui.waypoint.DimensionsDropDownButton;
import journeymap.client.ui.waypoint.WaypointPanel;
import journeymap.client.ui.waypoint.WaypointSlot;
import journeymap.client.ui.waypoint.group.EditGroupPopup;
import journeymap.client.ui.waypoint.group.GroupPanel;
import journeymap.client.ui.waypoint.group.GroupSlot;
import journeymap.client.waypoint.ClientWaypointImpl;
import journeymap.common.waypoint.WaypointGroupStore;
import journeymap.common.waypoint.WaypointStore;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5481;
import net.minecraft.class_8021;

public class WaypointManager
extends TwoColumnScreen<GroupPanel<GroupSlot>, WaypointPanel<WaypointSlot>> {
    private final ClientWaypointImpl focusWaypoint;
    private Map<WaypointGroup, GroupSlot> groupMap;
    private GroupPanel<GroupSlot> groupPanel;
    private static WaypointGroup selectedGroup = WaypointGroupStore.ALL;
    private GroupSlot draggingGroup;
    private final Map<WaypointGroup, WaypointPanel<WaypointSlot>> panelMap = new HashMap<WaypointGroup, WaypointPanel<WaypointSlot>>();
    private Button createGroupButton;
    int sidePanelSize = 120;
    int panelYOffset = 25;

    public WaypointManager(class_437 returnDisplay) {
        this(null, returnDisplay);
    }

    public WaypointManager(ClientWaypointImpl focusWaypoint, class_437 returnDisplay) {
        super(Constants.getString("jm.waypoint.manage_title"), true, returnDisplay, null, null);
        this.field_22787 = class_310.method_1551();
        this.focusWaypoint = focusWaypoint;
        this.groupMap = this.buildGroupSlots();
    }

    @Override
    public void method_25426() {
        this.footerLayout.method_52736((class_8021)new DimensionsDropDownButton(this::updateDimFilter));
        super.method_25426();
        try {
            this.groupPanel = new GroupPanel(this.field_22787, this, 1, 36 + this.panelYOffset, this.sidePanelSize - 1, this.field_22790 - 66 - 25, 20);
            this.groupPanel.setSlots(this.groupMap.values().stream().toList());
            this.createGroupButton = new PopupButton<String>(0, 0, "New Group", () -> new EditGroupPopup((class_2561)class_2561.method_43471((String)"Input new group name")), this::addNewGroup);
            this.method_37063((class_364)this.createGroupButton);
            this.method_37063((class_364)this.groupPanel);
            this.method_37063((class_364)this.getWaypointPanel(selectedGroup));
        }
        catch (Throwable t) {
            JMLogger.throwLogOnce("Error in WaypointManager.init(): {}", t);
        }
    }

    @Override
    protected GroupPanel<GroupSlot> getLeftPane() {
        return null;
    }

    @Override
    protected WaypointPanel<WaypointSlot> getRightPane() {
        return null;
    }

    @Override
    protected void method_48640() {
        super.method_48640();
        this.groupPanel.updateSize(this.sidePanelSize - 1, this.field_22790 - 22 - 66 - this.panelYOffset, 1, 36 + this.panelYOffset);
        this.groupPanel.updateSlots();
        this.groupPanel.method_25307(0.0);
        this.groupMap.keySet().forEach(group -> {
            WaypointPanel<WaypointSlot> waypointPanel = this.getWaypointPanel((WaypointGroup)group);
            waypointPanel.updateSize(this.field_22789 - this.sidePanelSize - 12, this.field_22790 - 66 - this.panelYOffset, this.sidePanelSize + 4, 36 + this.panelYOffset);
            waypointPanel.updateSlots();
            waypointPanel.method_25307(0.0);
        });
        this.createGroupButton.fitWidth(this.field_22793);
        this.createGroupButton.method_46419(this.groupPanel.method_55443() + 2);
        this.createGroupButton.method_46421(this.sidePanelSize / 2 - this.createGroupButton.method_25368() / 2);
    }

    private void updateDimFilter(class_4185 button) {
    }

    @Override
    public void method_25394(class_332 graphics, int x, int y, float par3) {
        GroupPanel<GroupSlot> panelUnderMouse;
        GroupSlot groupSlot;
        WaypointGroup group;
        super.method_25394(graphics, x, y, par3);
        this.outline(graphics, 0, 36, this.field_22789 - 1, this.field_22790 - 66);
        DrawUtil.drawRectangle(graphics, this.sidePanelSize, 36.0, 1.0, this.field_22790 - 66, 0xC0C0C0, 0.8f);
        DrawUtil.drawRectangle(graphics, 0.0, 56.0, this.field_22789 - 1, 1.0, 0xC0C0C0, 0.8f);
        graphics.method_25303(this.field_22793, "Groups", this.sidePanelSize / 2 - 23, 42, -1);
        graphics.method_25303(this.field_22793, "Waypoints", this.sidePanelSize + 10, 42, -1);
        Optional child = this.groupPanel.method_19355(x, y);
        if (this.getWaypointPanel(selectedGroup).getDraggingSlot() != null && child.isPresent() && (group = (groupSlot = (GroupSlot)child.get()).getGroup()) != null) {
            boolean transferable = WaypointGroupStore.getInstance().canTransferWaypoint(group, this.getWaypointPanel(selectedGroup).getDraggingSlot().getWaypoint());
            groupSlot.renderTransferStatus(graphics, transferable);
        }
        ScrollListPane scrollListPane = child.isPresent() ? this.groupPanel : (panelUnderMouse = this.getWaypointPanel(selectedGroup).method_19355(x, y).isPresent() ? this.getWaypointPanel(selectedGroup) : null);
        if (panelUnderMouse != null) {
            List<class_5481> lastTooltip = panelUnderMouse.lastTooltip;
            long lastTooltipTime = panelUnderMouse.lastTooltipTime;
            if (panelUnderMouse.lastTooltip != null && panelUnderMouse.lastTooltip.equals(lastTooltip)) {
                panelUnderMouse.lastTooltipTime = lastTooltipTime;
                if (System.currentTimeMillis() - panelUnderMouse.lastTooltipTime > panelUnderMouse.hoverDelay) {
                    graphics.method_51447(this.field_22793, panelUnderMouse.lastTooltip, x, y + 15);
                }
            }
        }
    }

    private void fillBackground(class_332 graphics, ScrollListPane panel) {
        DrawUtil.drawRectangle(graphics, panel.method_46426(), panel.method_46427(), panel.method_25368() - 1, panel.method_25364(), new Color(20, 20, 20).getRGB(), 0.95f);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        boolean groupClicked = this.groupPanel.method_25402(mouseX, mouseY, button);
        if (button == 0) {
            Slot groupSelected = (Slot)this.groupPanel.method_25334();
            if (groupSelected != null && groupClicked) {
                this.updateSelectedGroup(groupSelected);
                return true;
            }
            boolean waypointClicked = this.getWaypointPanel(selectedGroup).method_25402(mouseX, mouseY, button);
            Slot slot = (Slot)this.getWaypointPanel(selectedGroup).method_25334();
        }
        if (groupClicked) {
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public void updateSelectedGroup(Slot groupSelected) {
        this.groupPanel.unselect();
        this.method_37066((class_364)this.getWaypointPanel(selectedGroup));
        selectedGroup = ((GroupSlot)groupSelected).getGroup();
        this.getWaypointPanel(selectedGroup).setSlots(this.getWaypointsForGroup(selectedGroup));
        this.method_37063((class_364)this.getWaypointPanel(selectedGroup));
        ((GroupSlot)groupSelected).setSelected(true);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        Optional child = this.groupPanel.method_19355(mouseX, mouseY);
        if (this.getWaypointPanel(selectedGroup).getDraggingSlot() != null && child.isPresent()) {
            WaypointGroup groupTo = ((GroupSlot)child.get()).getGroup();
            Waypoint waypoint = this.getWaypointPanel(selectedGroup).getDraggingSlot().getWaypoint();
            WaypointGroup groupFrom = WaypointGroupStore.getInstance().get(waypoint.getGroupId());
            boolean didTransfer = groupTo.addWaypoint(waypoint);
            if (didTransfer && !WaypointGroupStore.ALL.getGuid().equals(selectedGroup.getGuid())) {
                this.getWaypointPanel(selectedGroup).setSlots(this.getWaypointsForGroup(groupFrom));
            }
        }
        boolean groupMouseReleased = this.groupPanel.method_25406(mouseX, mouseY, button);
        boolean waypointsMouseReleased = this.getWaypointPanel(selectedGroup).method_25406(mouseX, mouseY, button);
        return groupMouseReleased || waypointsMouseReleased;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        return this.groupPanel.method_25403(mouseX, mouseY, button, dragX, dragY) || this.getWaypointPanel(selectedGroup).method_25403(mouseX, mouseY, button, dragX, dragY) || super.method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        boolean groupScrolled = false;
        boolean waypointsScrolled = false;
        WaypointPanel<WaypointSlot> waypointPanel = this.getWaypointPanel(selectedGroup);
        if (this.groupPanel.method_25405(mouseX, mouseY)) {
            groupScrolled = this.groupPanel.method_25401(mouseX, mouseY, scrollX, scrollY);
        } else if (waypointPanel.method_25405(mouseX, mouseY)) {
            waypointsScrolled = this.getWaypointPanel(selectedGroup).method_25401(mouseX, mouseY, scrollX, scrollY);
        }
        return groupScrolled || waypointsScrolled;
    }

    private void outline(class_332 graphics, int x, int y, int width, int height) {
        int color = 0xC0C0C0;
        float alpha = 0.8f;
        DrawUtil.drawRectangle(graphics, x, y, width, 1.0, color, alpha);
        DrawUtil.drawRectangle(graphics, x, y + height, width, 1.0, color, alpha);
        DrawUtil.drawRectangle(graphics, x, y, 1.0, height, color, alpha);
        DrawUtil.drawRectangle(graphics, x + width, y, 1.0, height + 1, color, alpha);
    }

    protected Map<WaypointGroup, GroupSlot> buildGroupSlots() {
        LinkedHashMap<WaypointGroup, GroupSlot> map = new LinkedHashMap<WaypointGroup, GroupSlot>();
        map.put(WaypointGroupStore.ALL, new GroupSlot(WaypointGroupStore.ALL, this.field_22789, this.field_22790));
        WaypointGroupStore.getInstance().getAll().forEach(group -> map.put((WaypointGroup)group, new GroupSlot((WaypointGroup)group, this.field_22789, this.field_22790)));
        return map;
    }

    protected List<WaypointSlot> getWaypointsForGroup(WaypointGroup group) {
        return group.getWaypointIds().stream().map(id -> WaypointStore.getInstance().get((String)id)).toList().stream().map(WaypointSlot::new).toList();
    }

    private void addNewGroup(String name) {
        if (name != null && !name.isEmpty()) {
            WaypointGroup group = WaypointFactoryImpl.instance.createWaypointGroup(name);
            WaypointGroupStore.getInstance().put(group);
            this.updateGroupSlots();
        }
    }

    private void updateGroupSlots() {
        this.groupMap = this.buildGroupSlots();
        this.groupPanel.setSlots(this.groupMap.values().stream().toList());
    }

    private WaypointPanel<WaypointSlot> getWaypointPanel(WaypointGroup group) {
        WaypointPanel<WaypointSlot> panel = this.panelMap.get(group);
        if (panel == null) {
            panel = new WaypointPanel(this.field_22787, this.sidePanelSize + 4, 36 + this.panelYOffset, this.field_22789 - this.sidePanelSize - 12, this.field_22790 - 66 - this.panelYOffset, 20);
            panel.setSlots(this.getWaypointsForGroup(group));
            this.panelMap.put(group, panel);
        }
        return panel;
    }
}

