/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.waypoint.legacy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import journeymap.api.common.waypoint.WaypointFactoryImpl;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.command.CmdTeleportWaypoint;
import journeymap.client.log.ChatLog;
import journeymap.client.log.JMLogger;
import journeymap.client.properties.ClientCategory;
import journeymap.client.properties.WaypointProperties;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.component.ButtonList;
import journeymap.client.ui.component.ScrollListPane;
import journeymap.client.ui.component.buttons.Button;
import journeymap.client.ui.component.buttons.OnOffButton;
import journeymap.client.ui.component.screens.JmUILegacy;
import journeymap.client.ui.fullscreen.Fullscreen;
import journeymap.client.ui.option.CategorySlot;
import journeymap.client.ui.option.SlotMetadata;
import journeymap.client.ui.waypoint.DimensionsDropDownButton;
import journeymap.client.ui.waypoint.legacy.SortButton;
import journeymap.client.ui.waypoint.legacy.WaypointManagerItem;
import journeymap.client.waypoint.ClientWaypointImpl;
import journeymap.common.Journeymap;
import journeymap.common.properties.catagory.Category;
import journeymap.common.waypoint.WaypointGroupStore;
import journeymap.common.waypoint.WaypointStore;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_5321;
import net.minecraft.class_5481;

public class LegacyWaypointManager
extends JmUILegacy {
    static final String ASCEND = "\u25b2";
    static final String DESCEND = "\u25bc";
    static final int COLWAYPOINT = 0;
    static final int COLLOCATION = 20;
    static final int COLNAME = 60;
    static final int DEFAULT_ITEMWIDTH = 460;
    private static WaypointManagerItem.Sort currentSort;
    private final String on = Constants.getString("jm.common.on");
    private final String off = Constants.getString("jm.common.off");
    protected int colWaypoint = 0;
    protected int colLocation = 20;
    protected int colName = 60;
    protected int itemWidth = 460;
    protected ScrollListPane itemScrollPane;
    protected int rowHeight = 16;
    Boolean canUserTeleport;
    private SortButton buttonSortName;
    private SortButton buttonSortDistance;
    private SortButton buttonSortDeviation;
    private DimensionsDropDownButton buttonDimensions;
    private Button buttonClose;
    private Button buttonAdd;
    private Button buttonOptions;
    private OnOffButton buttonToggleAll;
    private ButtonList bottomButtons;
    private ClientWaypointImpl focusWaypoint;
    private ArrayList<WaypointManagerItem> items = new ArrayList();
    private static boolean toggled;

    public LegacyWaypointManager() {
        this((ClientWaypointImpl)null, (class_437)null);
    }

    public LegacyWaypointManager(class_437 returnDisplay) {
        this((ClientWaypointImpl)null, returnDisplay);
    }

    public LegacyWaypointManager(ClientWaypointImpl focusWaypoint, class_437 returnDisplay) {
        super(Constants.getString("jm.waypoint.manage_title"), returnDisplay);
        this.focusWaypoint = focusWaypoint;
    }

    public void setFocusWaypoint(ClientWaypointImpl focusWaypoint) {
        this.focusWaypoint = focusWaypoint;
    }

    @Override
    public void method_25426() {
        try {
            this.setRenderBottomBar(true);
            this.getRenderables().clear();
            Journeymap.getLogger().debug("Checking if tp is permitted");
            this.canUserTeleport = CmdTeleportWaypoint.isPermitted(class_310.method_1551());
            Journeymap.getLogger().debug("Checked if tp button should be displayed:" + this.canUserTeleport);
            class_327 fr = this.getFontRenderer();
            WaypointManagerItem.DistanceComparator distanceSort = new WaypointManagerItem.DistanceComparator((class_1657)class_310.method_1551().field_1724, true);
            String distanceLabel = Constants.getString("jm.waypoint.distance");
            this.buttonSortDistance = new SortButton(distanceLabel, distanceSort, b -> {
                this.buttonSortDistance.toggle();
                this.updateSort(this.buttonSortDistance);
            });
            this.buttonSortDistance.setTextOnly(fr);
            this.getRenderables().add((class_4068)this.buttonSortDistance);
            this.method_37063((class_364)this.buttonSortDistance);
            WaypointManagerItem.NameComparator nameSort = new WaypointManagerItem.NameComparator(true);
            WaypointManagerItem.DeviationComparator deviationSort = new WaypointManagerItem.DeviationComparator(true);
            this.buttonSortName = new SortButton(Constants.getString("jm.waypoint.name"), nameSort, b -> {
                this.buttonSortName.toggle();
                this.updateSort(this.buttonSortName);
            });
            this.buttonSortName.setTextOnly(fr);
            this.method_37063((class_364)this.buttonSortName);
            this.getRenderables().add((class_4068)this.buttonSortName);
            this.buttonSortDeviation = new SortButton(Constants.getString("jm.waypoint.deviation_button_sort"), deviationSort, b -> {
                this.buttonSortDeviation.toggle();
                this.updateSort(this.buttonSortDeviation);
            });
            this.buttonSortDeviation.setTextOnly(fr);
            this.method_37063((class_364)this.buttonSortDeviation);
            this.getRenderables().add((class_4068)this.buttonSortDeviation);
            String enableOn = Constants.getString("jm.waypoint.enable_all", "", this.on);
            String enableOff = Constants.getString("jm.waypoint.enable_all", "", this.off);
            this.buttonToggleAll = new OnOffButton(enableOff, enableOn, true, b -> {
                boolean state = this.buttonToggleAll.getToggled();
                state = this.toggleItems(state);
                this.buttonToggleAll.setToggled(state);
            });
            this.buttonToggleAll.setTextOnly(this.getFontRenderer());
            this.method_37063((class_364)this.buttonToggleAll);
            this.getRenderables().add((class_4068)this.buttonToggleAll);
            this.buttonDimensions = new DimensionsDropDownButton(b -> this.updateItems());
            this.method_37063((class_364)this.buttonDimensions);
            if (JourneymapClient.getInstance().getWaypointProperties().managerDimensionFocus.get().booleanValue()) {
                this.buttonDimensions.setDim((class_5321<class_1937>)this.field_22787.field_1724.method_5770().method_27983());
            }
            this.buttonAdd = (Button)this.method_37063((class_364)new Button(Constants.getString("jm.waypoint.new"), button -> {
                ClientWaypointImpl waypoint = WaypointFactoryImpl.of(this.field_22787.field_1724);
                UIManager.INSTANCE.openWaypointEditor(waypoint, true, this);
            }));
            this.buttonAdd.fitWidth(this.getFontRenderer());
            this.buttonAdd.method_25358(this.buttonAdd.method_25368() * 2);
            this.buttonOptions = (Button)this.method_37063((class_364)new Button(Constants.getString("jm.common.options_button"), button -> UIManager.INSTANCE.openOptionsManager((class_437)this, ClientCategory.Waypoint, ClientCategory.WaypointBeacon)));
            this.buttonOptions.fitWidth(this.getFontRenderer());
            this.buttonClose = (Button)this.method_37063((class_364)new Button(Constants.getString("jm.common.close"), button -> this.refreshAndClose()));
            this.bottomButtons = new ButtonList(this.buttonOptions, this.buttonAdd, this.buttonDimensions, this.buttonClose);
            this.buttonOptions.setDefaultStyle(false);
            this.buttonAdd.setDefaultStyle(false);
            this.buttonDimensions.setDefaultStyle(false);
            this.buttonClose.setDefaultStyle(false);
            this.getRenderables().addAll(this.bottomButtons);
            SortButton sortButton = this.getInitialSort();
            currentSort = sortButton.sort;
            this.updateSort(sortButton);
            if (this.items.isEmpty()) {
                this.updateItems();
            }
            if (this.itemScrollPane == null) {
                Objects.requireNonNull(this);
                Objects.requireNonNull(this);
                Objects.requireNonNull(this);
                this.itemScrollPane = new ScrollListPane(this.field_22787, 0, 36, this.field_22789, this.field_22790 - 36 - 30, 20);
            } else {
                Objects.requireNonNull(this);
                Objects.requireNonNull(this);
                Objects.requireNonNull(this);
                this.itemScrollPane.updateSize(this.field_22789, this.field_22790 - 36 - 30, 0, 36);
                this.itemScrollPane.updateSlots();
            }
            this.itemScrollPane.setSlots(this.items);
            if (!this.items.isEmpty()) {
                this.itemScrollPane.scrollTo(this.items.get(0));
            }
        }
        catch (Throwable t) {
            JMLogger.throwLogOnce("Error in OptionsManager.init(): " + String.valueOf(t), t);
        }
    }

    @Override
    protected void layoutButtons(class_332 graphics) {
        if (this.getRenderables().isEmpty() || this.itemScrollPane == null) {
            this.method_25426();
        }
        this.buttonToggleAll.setDrawButton(!this.items.isEmpty());
        this.buttonSortDistance.setDrawButton(!this.items.isEmpty());
        this.buttonSortName.setDrawButton(!this.items.isEmpty());
        this.buttonSortDeviation.setDrawButton(!this.items.isEmpty() && JourneymapClient.getInstance().getWaypointProperties().showDeviationLabel.get() != false);
        this.bottomButtons.equalizeWidths(this.getFontRenderer());
        int bottomButtonWidth = Math.min(this.bottomButtons.getWidth(4) + 25, this.itemScrollPane.method_25322());
        this.bottomButtons.equalizeWidths(this.getFontRenderer(), 4, bottomButtonWidth);
        this.bottomButtons.layoutCenteredHorizontal(this.field_22789 / 2, this.field_22790 - 25, true, 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void method_25394(class_332 graphics, int x, int y, float par3) {
        if (this.field_22787 == null) {
            return;
        }
        if (this.getRenderables().isEmpty() || this.itemScrollPane == null) {
            this.method_25426();
        }
        if (currentSort != null) {
            Collections.sort(this.items, currentSort);
        }
        if (this.itemScrollPane != null) {
            this.itemScrollPane.setSlots(this.items);
        }
        try {
            graphics.method_51448().method_22903();
            Objects.requireNonNull(this);
            Objects.requireNonNull(this);
            Objects.requireNonNull(this);
            this.itemScrollPane.updateSize(this.field_22789, this.field_22790 - 36 - 30, 0, 36);
            List<class_5481> lastTooltip = this.itemScrollPane.lastTooltip;
            long lastTooltipTime = this.itemScrollPane.lastTooltipTime;
            this.itemScrollPane.lastTooltip = null;
            this.itemScrollPane.method_25394(graphics, x, y, par3);
            super.method_25394(graphics, x, y, par3);
            if (!this.items.isEmpty()) {
                Objects.requireNonNull(this.getFontRenderer());
                int headerY = 36 - 9;
                WaypointManagerItem firstRow = this.items.get(0);
                if (firstRow.y > headerY + 16) {
                    headerY = firstRow.y - 16;
                }
                this.buttonToggleAll.centerHorizontalOn(firstRow.getButtonEnableCenterX()).method_46419(headerY);
                this.buttonSortDistance.centerHorizontalOn(firstRow.getLocationLeftX()).method_46419(headerY);
                this.colName = this.buttonSortDistance.getRightX() + 20;
                this.buttonSortName.setScrollablePosition(this.colName - 5, headerY);
                this.buttonSortDeviation.centerHorizontalOn(firstRow.getButtonDeviationX()).method_46419(headerY);
            }
            this.buttonToggleAll.drawUnderline(graphics);
            for (List<SlotMetadata> toolbar : this.getToolbars().values()) {
                for (SlotMetadata slotMetadata : toolbar) {
                    slotMetadata.getButton().secondaryDrawButton();
                }
            }
            if (this.itemScrollPane.lastTooltip != null && this.itemScrollPane.lastTooltip.equals(lastTooltip)) {
                this.itemScrollPane.lastTooltipTime = lastTooltipTime;
                if (System.currentTimeMillis() - this.itemScrollPane.lastTooltipTime > this.itemScrollPane.hoverDelay) {
                    Button button = this.itemScrollPane.lastTooltipMetadata.getButton();
                    graphics.method_51447(this.field_22793, this.itemScrollPane.lastTooltip, x, button.getBottomY() + 15);
                }
            }
        }
        catch (Throwable t) {
            JMLogger.throwLogOnce("Error in OptionsManager.render(): " + String.valueOf(t), t);
        }
        finally {
            graphics.method_51448().method_22909();
        }
    }

    @Override
    public void method_25420(class_332 guiGraphics, int i, int j, float f) {
    }

    public boolean method_25402(double mouseX, double mouseY, int mouseButton) {
        try {
            boolean pressed;
            if (mouseButton == 0 && (pressed = this.itemScrollPane.method_25402(mouseX, mouseY, mouseButton))) {
                this.checkPressedButton();
                return true;
            }
        }
        catch (Exception e) {
            Journeymap.getLogger().error("Problem with mouseClicked", (Throwable)e);
        }
        return super.method_25402(mouseX, mouseY, mouseButton);
    }

    @Override
    public boolean method_25406(double mouseX, double mouseY, int mouseButton) {
        this.itemScrollPane.method_25406(mouseX, mouseY, mouseButton);
        return super.method_25406(mouseX, mouseY, mouseButton);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double mouseDX, double mouseDY) {
        this.checkPressedButton();
        this.itemScrollPane.method_25403(mouseX, mouseY, button, mouseDX, mouseDY);
        return super.method_25403(mouseX, mouseY, button, mouseDX, mouseDY);
    }

    public boolean method_25401(double x, double y, double f, double scroll) {
        if (this.itemScrollPane.method_25401(x, y, f, scroll)) {
            return true;
        }
        return super.method_25401(x, y, f, scroll);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void checkPressedButton() {
        try {
            CategorySlot parentSlot;
            SlotMetadata slotMetadata = this.itemScrollPane.getLastPressed();
            if (slotMetadata != null) {
                // empty if block
            }
            if ((parentSlot = (CategorySlot)this.itemScrollPane.getLastPressedParentSlot()) == null) return;
        }
        catch (Exception e) {
            Journeymap.getLogger().error("WARNING: Problem checking buttons.");
            throw new RuntimeException("checkPressedButton", e);
        }
    }

    @Override
    public boolean method_25400(char typedChar, int keyCode) {
        if (keyCode == 256) {
            this.closeAndReturn();
        }
        if (this.itemScrollPane != null) {
            boolean keyUsed = this.itemScrollPane.method_25400(typedChar, keyCode);
            if (keyUsed) {
                return true;
            }
            if (keyCode == 265) {
                this.itemScrollPane.method_25309(-this.rowHeight);
                return true;
            }
            if (keyCode == 264) {
                this.itemScrollPane.method_25309(this.rowHeight);
                return true;
            }
            if (keyCode == 266) {
                this.itemScrollPane.method_25309(-this.itemScrollPane.method_25364());
                return true;
            }
            if (keyCode == 267) {
                this.itemScrollPane.method_25309(this.itemScrollPane.method_25364());
                return true;
            }
            if (keyCode == 268) {
                this.itemScrollPane.method_25309((int)(-this.itemScrollPane.method_25341()));
                return true;
            }
            if (keyCode == 269) {
                this.itemScrollPane.method_25309((int)this.itemScrollPane.method_25341());
                return true;
            }
        } else {
            Journeymap.getLogger().error("WARNING: itemScrollPane is null. This is an error state! Report to Developers!");
        }
        return true;
    }

    protected boolean toggleItems(boolean enable) {
        for (WaypointManagerItem item : this.items) {
            if (enable != item.waypoint.isEnabled()) continue;
            enable = !enable;
            break;
        }
        for (WaypointManagerItem item : this.items) {
            if (item.waypoint.isEnabled() == enable) continue;
            item.enableWaypoint(enable);
        }
        return !enable;
    }

    public static void toggleWaypointRendering() {
        LegacyWaypointManager.renderWaypoints(JourneymapClient.getInstance().getWaypointProperties().renderWaypoints.get() == false);
    }

    public static void renderWaypoints(boolean value) {
        ChatLog.announceWaypointRendering(value);
        JourneymapClient.getInstance().getWaypointProperties().renderWaypoints.set(value);
    }

    protected void updateItems() {
        this.items.clear();
        String currentDim = DimensionsDropDownButton.currentWorldProvider == null ? null : DimensionsDropDownButton.currentWorldProvider.getDimensionId();
        class_327 fr = this.getFontRenderer();
        List<ClientWaypointImpl> waypoints = WaypointStore.getInstance().getAll();
        boolean allOn = true;
        this.itemWidth = 0;
        for (ClientWaypointImpl waypoint : waypoints) {
            WaypointManagerItem item = new WaypointManagerItem(waypoint, fr, this);
            this.itemWidth = Math.max(item.internalWidth, this.itemWidth);
            item.getDistanceTo((class_1657)this.field_22787.field_1724);
            if (currentDim != null && !item.waypoint.getDimensions().contains(currentDim)) continue;
            this.items.add(item);
            if (!allOn) continue;
            allOn = waypoint.isEnabled();
        }
        if (this.items.isEmpty()) {
            this.itemWidth = 460;
        }
        this.buttonToggleAll.setToggled(!allOn);
        this.updateCount();
    }

    protected void updateSort(SortButton sortButton) {
        for (class_4068 button : this.getRenderables()) {
            if (!(button instanceof SortButton)) continue;
            if (button == sortButton) {
                if (!sortButton.sort.equals(currentSort)) {
                    sortButton.setActive(true);
                }
                this.updateSortProperty(sortButton);
                currentSort = sortButton.sort;
                continue;
            }
            ((SortButton)button).setActive(false);
        }
    }

    protected void updateCount() {
        String itemCount = this.items.isEmpty() ? "" : Integer.toString(this.items.size());
        String enableOn = Constants.getString("jm.waypoint.enable_all", itemCount, this.on);
        String enableOff = Constants.getString("jm.waypoint.enable_all", itemCount, this.off);
        this.buttonToggleAll.setLabels(enableOff, enableOn);
    }

    protected boolean isSelected(WaypointManagerItem item) {
        return this.itemScrollPane.method_25332(item.getSlotIndex());
    }

    protected int getMargin() {
        return this.field_22789 > this.itemWidth + 2 ? (this.field_22789 - this.itemWidth) / 2 : 0;
    }

    public void removeWaypoint(WaypointManagerItem item) {
        WaypointStore.getInstance().remove(item.waypoint, true);
        this.items.remove((Object)item);
        this.updateItems();
    }

    protected void refreshAndClose() {
        this.closeAndReturn();
    }

    @Override
    protected void closeAndReturn() {
        this.bottomButtons.setEnabled(false);
        WaypointGroupStore.getInstance().save();
        Fullscreen.state().requireRefresh();
        this.bottomButtons.setEnabled(true);
        if (returnDisplayStack == null || returnDisplayStack.peek() == null) {
            UIManager.INSTANCE.closeAll();
        } else {
            UIManager.INSTANCE.open((class_437)returnDisplayStack.pop());
        }
    }

    Map<Category, List<SlotMetadata>> getToolbars() {
        return Collections.EMPTY_MAP;
    }

    private SortButton getInitialSort() {
        WaypointProperties prop = JourneymapClient.getInstance().getWaypointProperties();
        boolean ascending = prop.sortAscending.get();
        SortButton button = switch ((WaypointManagerItem.SortType)((Object)prop.initialSortOrder.get())) {
            case WaypointManagerItem.SortType.Deviation -> this.buttonSortDeviation;
            case WaypointManagerItem.SortType.Name -> this.buttonSortName;
            default -> this.buttonSortDistance;
        };
        button.sort.ascending = ascending;
        button.setToggled(ascending);
        return button;
    }

    private void updateSortProperty(SortButton sortButton) {
        WaypointProperties prop = JourneymapClient.getInstance().getWaypointProperties();
        if (sortButton == this.buttonSortDistance) {
            prop.initialSortOrder.set(WaypointManagerItem.SortType.Distance);
        } else if (sortButton == this.buttonSortName) {
            prop.initialSortOrder.set(WaypointManagerItem.SortType.Name);
        } else if (sortButton == this.buttonSortDeviation) {
            prop.initialSortOrder.set(WaypointManagerItem.SortType.Deviation);
        }
        prop.sortAscending.set(sortButton.sort.ascending);
    }

    static {
        toggled = true;
    }
}

