/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.render.schematic;

import fi.dy.masa.litematica.render.schematic.ChunkRendererSchematicVbo;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.class_1921;
import net.minecraft.class_9801;

public class BuiltBufferCache
implements AutoCloseable {
    private final Map<class_1921, class_9801> layerBuffers = new HashMap<class_1921, class_9801>();
    private final Map<ChunkRendererSchematicVbo.OverlayRenderType, class_9801> overlayBuffers = new HashMap<ChunkRendererSchematicVbo.OverlayRenderType, class_9801>();

    protected BuiltBufferCache() {
    }

    protected boolean hasBuiltBufferByLayer(class_1921 layer) {
        return this.layerBuffers.containsKey(layer);
    }

    protected boolean hasBuiltBufferByType(ChunkRendererSchematicVbo.OverlayRenderType type) {
        return this.overlayBuffers.containsKey((Object)type);
    }

    protected void storeBuiltBufferByLayer(class_1921 layer, @Nonnull class_9801 newBuffer) {
        if (this.hasBuiltBufferByLayer(layer)) {
            this.layerBuffers.get(layer).close();
        }
        this.layerBuffers.put(layer, newBuffer);
    }

    protected void storeBuiltBufferByType(ChunkRendererSchematicVbo.OverlayRenderType type, @Nonnull class_9801 newBuffer) {
        if (this.hasBuiltBufferByType(type)) {
            this.overlayBuffers.get((Object)type).close();
        }
        this.overlayBuffers.put(type, newBuffer);
    }

    public class_9801 getBuiltBufferByLayer(class_1921 layer) {
        return this.layerBuffers.get(layer);
    }

    protected class_9801 getBuiltBufferByType(ChunkRendererSchematicVbo.OverlayRenderType type) {
        return this.overlayBuffers.get((Object)type);
    }

    protected void closeByLayer(class_1921 layer) {
        try {
            if (this.layerBuffers.containsKey(layer)) {
                this.layerBuffers.get(layer).close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.layerBuffers.remove(layer);
    }

    protected void closeByType(ChunkRendererSchematicVbo.OverlayRenderType type) {
        try {
            if (this.overlayBuffers.containsKey((Object)type)) {
                this.overlayBuffers.get((Object)type).close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.overlayBuffers.remove((Object)type);
    }

    protected void closeAll() {
        try {
            this.layerBuffers.values().forEach(class_9801::close);
            this.overlayBuffers.values().forEach(class_9801::close);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.layerBuffers.clear();
        this.overlayBuffers.clear();
    }

    @Override
    public void close() throws Exception {
        this.closeAll();
    }
}

