/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.render.schematic;

import com.google.common.primitives.Doubles;
import fi.dy.masa.litematica.Litematica;
import fi.dy.masa.litematica.render.schematic.BufferAllocatorCache;
import fi.dy.masa.litematica.render.schematic.ChunkRenderDataSchematic;
import fi.dy.masa.litematica.render.schematic.ChunkRendererSchematicVbo;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import net.minecraft.class_243;

public class ChunkRenderTaskSchematic
implements Comparable<ChunkRenderTaskSchematic> {
    private final ChunkRendererSchematicVbo chunkRenderer;
    private final Type type;
    private final ConcurrentLinkedQueue<Runnable> finishRunnables = new ConcurrentLinkedQueue();
    private final Supplier<class_243> cameraPosSupplier;
    private final double distanceSq;
    private BufferAllocatorCache allocatorCache;
    private ChunkRenderDataSchematic chunkRenderData;
    private final AtomicReference<Status> status = new AtomicReference<Status>(Status.PENDING);

    public ChunkRenderTaskSchematic(ChunkRendererSchematicVbo renderChunkIn, Type typeIn, Supplier<class_243> cameraPosSupplier, double distanceSqIn) {
        this.chunkRenderer = renderChunkIn;
        this.type = typeIn;
        this.cameraPosSupplier = cameraPosSupplier;
        this.distanceSq = distanceSqIn;
    }

    public Supplier<class_243> getCameraPosSupplier() {
        return this.cameraPosSupplier;
    }

    public Status getStatus() {
        return this.status.get();
    }

    protected ChunkRendererSchematicVbo getRenderChunk() {
        return this.chunkRenderer;
    }

    protected ChunkRenderDataSchematic getChunkRenderData() {
        return this.chunkRenderData;
    }

    protected void setChunkRenderData(ChunkRenderDataSchematic chunkRenderData) {
        if (this.chunkRenderData != null) {
            this.chunkRenderData.clearAll();
        }
        this.chunkRenderData = chunkRenderData;
    }

    public BufferAllocatorCache getAllocatorCache() {
        return this.allocatorCache;
    }

    public boolean setRegionRenderCacheBuilder(BufferAllocatorCache allocatorCache) {
        if (allocatorCache == null) {
            Litematica.logger.error("setRegionRenderCacheBuilder() [Task] allocatorCache is null");
            return false;
        }
        this.allocatorCache = allocatorCache;
        return true;
    }

    protected Status casStatus(Status expected, Status nStatus) {
        return this.status.compareAndExchange(expected, nStatus);
    }

    protected void finish() {
        Status current = this.status.get();
        if (current == Status.DONE) {
            return;
        }
        if (this.status.compareAndSet(current, Status.DONE)) {
            Runnable runnable;
            while ((runnable = this.finishRunnables.poll()) != null) {
                runnable.run();
            }
        }
    }

    protected void addFinishRunnable(Runnable runnable) {
        if (this.status.get() == Status.DONE) {
            runnable.run();
            return;
        }
        this.finishRunnables.add(runnable);
        if (this.status.get() == Status.DONE && (runnable = this.finishRunnables.poll()) != null) {
            runnable.run();
        }
    }

    protected Type getType() {
        return this.type;
    }

    @Override
    public int compareTo(ChunkRenderTaskSchematic other) {
        return Doubles.compare((double)this.distanceSq, (double)other.distanceSq);
    }

    public double getDistanceSq() {
        return this.distanceSq;
    }

    public static enum Status {
        PENDING,
        COMPILING,
        UPLOADING,
        DONE;

    }

    public static enum Type {
        REBUILD_CHUNK,
        RESORT_TRANSPARENCY;

    }
}

