/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import fi.dy.masa.malilib.config.ConfigUtils;
import fi.dy.masa.malilib.config.IConfigHandler;
import fi.dy.masa.malilib.config.IConfigValue;
import fi.dy.masa.malilib.config.options.ConfigBoolean;
import fi.dy.masa.malilib.config.options.ConfigHotkey;
import fi.dy.masa.malilib.util.FileUtils;
import fi.dy.masa.malilib.util.JsonUtils;
import java.io.File;

public class MaLiLibConfigs
implements IConfigHandler {
    private static final String CONFIG_FILE_NAME = "malilib.json";

    public static void loadFromFile() {
        JsonElement element;
        File configFile = new File(FileUtils.getConfigDirectory(), CONFIG_FILE_NAME);
        if (configFile.exists() && configFile.isFile() && configFile.canRead() && (element = JsonUtils.parseJsonFile(configFile)) != null && element.isJsonObject()) {
            JsonObject root = element.getAsJsonObject();
            ConfigUtils.readConfigBase(root, "Generic", Generic.OPTIONS);
            ConfigUtils.readConfigBase(root, "Debug", Debug.OPTIONS);
        }
    }

    public static void saveToFile() {
        File dir = FileUtils.getConfigDirectory();
        if (dir.exists() && dir.isDirectory() || dir.mkdirs()) {
            JsonObject root = new JsonObject();
            ConfigUtils.writeConfigBase(root, "Generic", Generic.OPTIONS);
            ConfigUtils.writeConfigBase(root, "Debug", Debug.OPTIONS);
            JsonUtils.writeJsonToFile(root, new File(dir, CONFIG_FILE_NAME));
        }
    }

    @Override
    public void onConfigsChanged() {
        MaLiLibConfigs.saveToFile();
        MaLiLibConfigs.loadFromFile();
    }

    @Override
    public void load() {
        MaLiLibConfigs.loadFromFile();
    }

    @Override
    public void save() {
        MaLiLibConfigs.saveToFile();
    }

    public static class Generic {
        public static final ConfigHotkey IGNORED_KEYS = new ConfigHotkey("ignoredKeys", "", "Any keys set here will be completely ignored");
        public static final ConfigHotkey OPEN_GUI_CONFIGS = new ConfigHotkey("openGuiConfigs", "A,C", "Open the in-game malilib config GUI");
        public static final ConfigBoolean REALMS_COMMON_CONFIG = new ConfigBoolean("realmsCommonConfig", true, "Whether or not to use a common config file name for all realms servers.\nIf this is disabled, then the server IP and port are used in the generated config file names.\nHowever, apparently the Realms server addresses change regularly, so the config names would change\nall the time and thus the configs wouldn't save properly.\nSo basically leave this enabled if you only play on one Realms server.\nIf you play on multiple Realms... then the configs will get mixed up regardless.\nUnless you play on the different servers on different Minecraft instances\nto keep the configs separated by the Minecraft instance.");
        public static final ImmutableList<IConfigValue> OPTIONS = ImmutableList.of((Object)IGNORED_KEYS, (Object)OPEN_GUI_CONFIGS, (Object)REALMS_COMMON_CONFIG);
    }

    public static class Debug {
        public static final ConfigBoolean DEBUG_MESSAGES = new ConfigBoolean("debugMessages", false, "When enabled, debug level events\nare printed to the game console/log");
        public static final ConfigBoolean INPUT_CANCELLATION_DEBUG = new ConfigBoolean("inputCancellationDebugging", false, "When enabled, then the cancellation reason/source\nfor inputs (keyboard and mouse) is printed out");
        public static final ConfigBoolean KEYBIND_DEBUG = new ConfigBoolean("keybindDebugging", false, "When enabled, key presses and held keys are\nprinted to the game console (and the action bar, if enabled)");
        public static final ConfigBoolean KEYBIND_DEBUG_ACTIONBAR = new ConfigBoolean("keybindDebuggingIngame", false, "If enabled, then the messages from 'keybindDebugging'\nare also printed to the in-game action bar");
        public static final ConfigBoolean MOUSE_SCROLL_DEBUG = new ConfigBoolean("mouseScrollDebug", false, "If enabled, some debug values from mouse scrolling\nare printed to the game console/log");
        public static final ImmutableList<IConfigValue> OPTIONS = ImmutableList.of((Object)DEBUG_MESSAGES, (Object)INPUT_CANCELLATION_DEBUG, (Object)KEYBIND_DEBUG, (Object)KEYBIND_DEBUG_ACTIONBAR, (Object)MOUSE_SCROLL_DEBUG);
    }
}

