/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.network;

import fi.dy.masa.malilib.network.IPluginClientPlayHandler;
import fi.dy.masa.malilib.network.PacketSplitter;
import fi.dy.masa.minihud.MiniHUD;
import fi.dy.masa.minihud.network.ServuxStructuresPacket;
import fi.dy.masa.minihud.util.DataStorage;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_156;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_5819;
import net.minecraft.class_634;
import net.minecraft.class_8710;

@Environment(value=EnvType.CLIENT)
public abstract class ServuxStructuresHandler<T extends class_8710>
implements IPluginClientPlayHandler<T> {
    private static final ServuxStructuresHandler<ServuxStructuresPacket.Payload> INSTANCE = new ServuxStructuresHandler<ServuxStructuresPacket.Payload>(){

        public void receive(ServuxStructuresPacket.Payload payload, ClientPlayNetworking.Context context) {
            INSTANCE.receivePlayPayload(payload, context);
        }
    };
    public static final class_2960 CHANNEL_ID = class_2960.method_60655((String)"servux", (String)"structures");
    private boolean servuxRegistered;
    private boolean payloadRegistered = false;
    private int failures = 0;
    private static final int MAX_FAILURES = 4;
    private long readingSessionKey = -1L;

    public static ServuxStructuresHandler<ServuxStructuresPacket.Payload> getInstance() {
        return INSTANCE;
    }

    public class_2960 getPayloadChannel() {
        return CHANNEL_ID;
    }

    public boolean isPlayRegistered(class_2960 channel) {
        if (channel.equals((Object)CHANNEL_ID)) {
            return this.payloadRegistered;
        }
        return false;
    }

    public void setPlayRegistered(class_2960 channel) {
        if (channel.equals((Object)CHANNEL_ID)) {
            this.payloadRegistered = true;
        }
    }

    public void decodeStructuresPacket(class_2960 channel, ServuxStructuresPacket packet) {
        if (!channel.equals((Object)CHANNEL_ID)) {
            return;
        }
        switch (packet.getType()) {
            case PACKET_S2C_STRUCTURE_DATA: {
                class_2540 fullPacket;
                if (this.readingSessionKey == -1L) {
                    this.readingSessionKey = class_5819.method_43049((long)class_156.method_658()).method_43055();
                }
                if ((fullPacket = PacketSplitter.receive((IPluginClientPlayHandler)this, (long)this.readingSessionKey, (class_2540)packet.getBuffer())) == null) break;
                try {
                    class_2487 nbt = fullPacket.method_10798();
                    this.readingSessionKey = -1L;
                    if (nbt != null) {
                        class_2499 structures = nbt.method_10554("Structures", 10);
                        DataStorage.getInstance().addOrUpdateStructuresFromServer(structures, this.servuxRegistered);
                        break;
                    }
                    MiniHUD.logger.warn("decodeStructuresPacket(): Structures Data: error reading fullBuffer NBT is NULL");
                }
                catch (Exception e) {
                    MiniHUD.logger.error("decodeStructuresPacket(): Structures Data: error reading fullBuffer [{}]", (Object)e.getLocalizedMessage());
                }
                break;
            }
            case PACKET_S2C_METADATA: {
                if (!DataStorage.getInstance().receiveServuxMetadata(packet.getCompound())) break;
                this.servuxRegistered = true;
                break;
            }
            case PACKET_S2C_SPAWN_METADATA: {
                DataStorage.getInstance().receiveSpawnMetadata(packet.getCompound());
                break;
            }
            default: {
                MiniHUD.logger.warn("decodeStructuresPacket(): received unhandled packetType {} of size {} bytes.", (Object)packet.getPacketType(), (Object)packet.getTotalSize());
            }
        }
    }

    public void reset(class_2960 channel) {
        if (channel.equals((Object)CHANNEL_ID) && this.servuxRegistered) {
            this.servuxRegistered = false;
            this.failures = 0;
            this.readingSessionKey = -1L;
        }
    }

    public void resetFailures(class_2960 channel) {
        if (channel.equals((Object)CHANNEL_ID) && this.failures > 0) {
            this.failures = 0;
        }
    }

    public void receivePlayPayload(T payload, ClientPlayNetworking.Context ctx) {
        if (payload.method_56479().comp_2242().equals((Object)CHANNEL_ID)) {
            INSTANCE.decodeStructuresPacket(CHANNEL_ID, ((ServuxStructuresPacket.Payload)payload).data());
        }
    }

    public void encodeWithSplitter(class_2540 buffer, class_634 handler) {
    }

    public void encodeStructuresPacket(ServuxStructuresPacket packet) {
        if (!INSTANCE.sendPlayPayload(new ServuxStructuresPacket.Payload(packet))) {
            if (this.failures > 4) {
                MiniHUD.logger.warn("encodeStructuresPacket(): encountered [{}] sendPayload failures, cancelling any Servux join attempt(s)", (Object)4);
                this.servuxRegistered = false;
                INSTANCE.unregisterPlayReceiver();
                DataStorage.getInstance().onPacketFailure();
            } else {
                ++this.failures;
            }
        }
    }
}

