/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.network;

import fi.dy.masa.malilib.network.IClientPayloadData;
import fi.dy.masa.minihud.MiniHUD;
import fi.dy.masa.minihud.network.ServuxStructuresHandler;
import io.netty.buffer.Unpooled;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_8710;
import net.minecraft.class_9139;

public class ServuxStructuresPacket
implements IClientPayloadData {
    private Type packetType;
    private class_2487 nbt;
    private class_2540 buffer;
    public static final int PROTOCOL_VERSION = 2;

    public ServuxStructuresPacket(Type type, @Nullable class_2487 nbt) {
        this.packetType = type;
        if (nbt != null && !nbt.method_33133()) {
            this.nbt = new class_2487();
            this.nbt.method_10543(nbt);
        }
        if (this.buffer != null) {
            this.buffer.method_52931();
            this.buffer = new class_2540(Unpooled.buffer());
        }
    }

    public ServuxStructuresPacket(Type type, @Nonnull class_2540 packet) {
        this.packetType = type;
        this.nbt = new class_2487();
        this.buffer = packet;
    }

    public int getVersion() {
        return 2;
    }

    public int getPacketType() {
        return this.packetType.get();
    }

    public int getTotalSize() {
        int total = 2;
        if (this.nbt != null && !this.nbt.method_33133()) {
            total += this.nbt.method_47988();
        }
        if (this.buffer != null) {
            total += this.buffer.readableBytes();
        }
        return total;
    }

    public Type getType() {
        return this.packetType;
    }

    public class_2487 getCompound() {
        return this.nbt;
    }

    public class_2540 getBuffer() {
        return this.buffer;
    }

    public boolean hasBuffer() {
        return this.buffer != null && this.buffer.isReadable();
    }

    public boolean hasNbt() {
        return this.nbt != null && !this.nbt.method_33133();
    }

    public boolean isEmpty() {
        return !this.hasBuffer() && !this.hasNbt();
    }

    public void toPacket(class_2540 output) {
        output.method_10804(this.getPacketType());
        if (this.packetType.equals((Object)Type.PACKET_S2C_STRUCTURE_DATA)) {
            try {
                output.method_52975(this.buffer.readBytes(this.buffer.readableBytes()));
            }
            catch (Exception e) {
                MiniHUD.logger.error("ServuxStructuresPacket#toPacket: error writing data to packet: [{}]", (Object)e.getLocalizedMessage());
            }
        } else {
            try {
                output.method_10794((class_2520)this.nbt);
            }
            catch (Exception e) {
                MiniHUD.logger.error("ServuxStructuresPacket#toPacket: error writing NBT to packet: [{}]", (Object)e.getLocalizedMessage());
            }
        }
    }

    @Nullable
    public static ServuxStructuresPacket fromPacket(class_2540 input) {
        int i = input.method_10816();
        Type type = ServuxStructuresPacket.getType(i);
        if (type == null) {
            MiniHUD.logger.warn("ServuxStructuresPacket#fromPacket: invalid packet type received");
        } else if (type.equals((Object)Type.PACKET_S2C_STRUCTURE_DATA)) {
            try {
                return new ServuxStructuresPacket(type, new class_2540(input.readBytes(input.readableBytes())));
            }
            catch (Exception e) {
                MiniHUD.logger.error("ServuxStructuresPacket#fromPacket: error reading Buffer from packet: [{}]", (Object)e.getLocalizedMessage());
            }
        } else {
            try {
                return new ServuxStructuresPacket(type, input.method_10798());
            }
            catch (Exception e) {
                MiniHUD.logger.error("ServuxStructuresPacket#fromPacket: error reading NBT from packet: [{}]", (Object)e.getLocalizedMessage());
            }
        }
        return null;
    }

    public void clear() {
        if (this.nbt != null && !this.nbt.method_33133()) {
            this.nbt = new class_2487();
        }
        if (this.buffer != null && this.buffer.readableBytes() > 0) {
            this.buffer.method_52931();
            this.buffer = new class_2540(Unpooled.buffer());
        }
        this.packetType = null;
    }

    @Nullable
    public static Type getType(int input) {
        for (Type type : Type.values()) {
            if (type.get() != input) continue;
            return type;
        }
        return null;
    }

    public static enum Type {
        PACKET_S2C_METADATA(1),
        PACKET_S2C_STRUCTURE_DATA(2),
        PACKET_C2S_STRUCTURES_REGISTER(3),
        PACKET_C2S_STRUCTURES_UNREGISTER(4),
        PACKET_S2C_STRUCTURE_DATA_START(5),
        PACKET_S2C_SPAWN_METADATA(10),
        PACKET_C2S_REQUEST_SPAWN_METADATA(11);

        private final int type;

        private Type(int type) {
            this.type = type;
        }

        int get() {
            return this.type;
        }
    }

    public record Payload(ServuxStructuresPacket data) implements class_8710
    {
        public static final class_8710.class_9154<Payload> ID = new class_8710.class_9154(ServuxStructuresHandler.CHANNEL_ID);
        public static final class_9139<class_2540, Payload> CODEC = class_8710.method_56484(Payload::write, Payload::new);

        public Payload(class_2540 input) {
            this(ServuxStructuresPacket.fromPacket(input));
        }

        private void write(class_2540 output) {
            this.data.toPacket(output);
        }

        public class_8710.class_9154<Payload> method_56479() {
            return ID;
        }
    }
}

