/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer;

import fi.dy.masa.malilib.config.IConfigBoolean;
import fi.dy.masa.malilib.util.WorldUtils;
import fi.dy.masa.minihud.renderer.OverlayRendererBase;
import fi.dy.masa.minihud.renderer.RenderObjectBase;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_290;
import net.minecraft.class_310;
import net.minecraft.class_631;
import net.minecraft.class_638;

public abstract class BaseBlockRangeOverlay<T extends class_2586>
extends OverlayRendererBase {
    protected final IConfigBoolean renderToggleConfig;
    protected final LongOpenHashSet blockPositions = new LongOpenHashSet();
    protected final class_2591<T> blockEntityType;
    protected final Class<T> blockEntityClass;
    protected boolean needsUpdate;
    private boolean wasEmpty = true;
    protected int updateDistance = 48;

    protected BaseBlockRangeOverlay(IConfigBoolean renderToggleConfig, class_2591<T> blockEntityType, Class<T> blockEntityClass) {
        this.renderToggleConfig = renderToggleConfig;
        this.blockEntityType = blockEntityType;
        this.blockEntityClass = blockEntityClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        LongOpenHashSet longOpenHashSet = this.blockPositions;
        synchronized (longOpenHashSet) {
            this.blockPositions.clear();
        }
    }

    public void setNeedsUpdate() {
        if (!this.renderToggleConfig.getBooleanValue()) {
            this.clear();
            return;
        }
        this.needsUpdate = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onBlockStatusChange(class_2338 pos) {
        if (this.renderToggleConfig.getBooleanValue()) {
            LongOpenHashSet longOpenHashSet = this.blockPositions;
            synchronized (longOpenHashSet) {
                this.blockPositions.add(pos.method_10063());
                this.needsUpdate = true;
            }
        }
    }

    @Override
    public boolean shouldRender(class_310 mc) {
        return this.renderToggleConfig.getBooleanValue();
    }

    @Override
    public boolean needsUpdate(class_1297 cameraEntity, class_310 mc) {
        return this.needsUpdate || this.lastUpdatePos == null || Math.abs(cameraEntity.method_23317() - (double)this.lastUpdatePos.method_10263()) > (double)this.updateDistance || Math.abs(cameraEntity.method_23321() - (double)this.lastUpdatePos.method_10260()) > (double)this.updateDistance;
    }

    @Override
    public void update(class_243 cameraPos, class_1297 entity, class_310 mc) {
        boolean blockPositionsInRange = this.fetchAllTargetBlockEntityPositions(mc.field_1687, entity.method_24515(), mc);
        if (blockPositionsInRange) {
            if (this.wasEmpty) {
                this.allocateGlResources();
                this.wasEmpty = false;
            }
            this.startBuffers();
            this.renderBlockRanges(entity.method_5770(), cameraPos, mc);
            this.uploadBuffers();
        } else {
            this.deleteGlResources();
            this.allocateGlResources();
            this.wasEmpty = true;
        }
        this.needsUpdate = false;
    }

    protected void startBuffers() {
        BUFFER_1 = TESSELLATOR_1.method_60827(((RenderObjectBase)this.renderObjects.get(0)).getGlMode(), class_290.field_1576);
        BUFFER_2 = TESSELLATOR_2.method_60827(((RenderObjectBase)this.renderObjects.get(1)).getGlMode(), class_290.field_1576);
    }

    protected void uploadBuffers() {
        ((RenderObjectBase)this.renderObjects.get(0)).uploadData(BUFFER_1);
        ((RenderObjectBase)this.renderObjects.get(1)).uploadData(BUFFER_2);
    }

    protected boolean fetchAllTargetBlockEntityPositions(class_638 world, class_2338 centerPos, class_310 mc) {
        class_631 chunkManager = world.method_2935();
        int centerCX = centerPos.method_10263() >> 4;
        int centerCZ = centerPos.method_10260() >> 4;
        int chunkRadius = (Integer)mc.field_1690.method_42503().method_41753();
        this.blockPositions.clear();
        for (int cz = centerCZ - chunkRadius; cz <= centerCZ + chunkRadius; ++cz) {
            for (int cx = centerCX - chunkRadius; cx <= centerCX + chunkRadius; ++cx) {
                class_2818 chunk = chunkManager.method_2857(cx, cz, class_2806.field_12803, false);
                if (chunk == null) continue;
                for (class_2586 be : chunk.method_12214().values()) {
                    if (be.method_11017() != this.blockEntityType) continue;
                    this.blockPositions.add(be.method_11016().method_10063());
                }
            }
        }
        return !this.blockPositions.isEmpty() && this.blockPositions.size() > 0;
    }

    protected void renderBlockRanges(class_1937 world, class_243 cameraPos, class_310 mc) {
        LongIterator it = this.blockPositions.iterator();
        class_2338.class_2339 mutablePos = new class_2338.class_2339();
        double max = ((Integer)mc.field_1690.method_42503().method_41753() + 2) * 16;
        max *= max;
        while (it.hasNext()) {
            mutablePos.method_16363(it.nextLong());
            class_2586 be = world.method_8321((class_2338)mutablePos);
            if (be == null || !this.blockEntityClass.isAssignableFrom(be.getClass())) {
                it.remove();
                continue;
            }
            double distSq = (cameraPos.field_1352 - (double)mutablePos.method_10263()) * (cameraPos.field_1352 - (double)mutablePos.method_10263()) + (cameraPos.field_1350 - (double)mutablePos.method_10260()) * (cameraPos.field_1350 - (double)mutablePos.method_10260());
            if (distSq > max) continue;
            class_2586 castBe = (class_2586)this.blockEntityClass.cast(be);
            this.renderBlockRange(world, (class_2338)mutablePos, castBe, cameraPos);
        }
    }

    protected int getTopYOverTerrain(class_1937 world, class_2338 pos, int range) {
        int minX = pos.method_10263() - range;
        int minZ = pos.method_10260() - range;
        int maxX = pos.method_10263() + range;
        int maxZ = pos.method_10260() + range;
        int minCX = minX >> 4;
        int minCZ = minZ >> 4;
        int maxCX = maxX >> 4;
        int maxCZ = maxZ >> 4;
        int maxY = 0;
        for (int cz = minCZ; cz <= maxCZ; ++cz) {
            for (int cx = minCX; cx <= maxCX; ++cx) {
                class_2818 chunk = world.method_8497(cx, cz);
                int height = WorldUtils.getHighestSectionYOffset((class_2791)chunk) + 15;
                if (height <= maxY) continue;
                maxY = height;
            }
        }
        return maxY + 4;
    }

    protected abstract void renderBlockRange(class_1937 var1, class_2338 var2, T var3, class_243 var4);
}

