/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.Color4f;
import fi.dy.masa.malilib.util.EntityUtils;
import fi.dy.masa.malilib.util.JsonUtils;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.config.RendererToggle;
import fi.dy.masa.minihud.renderer.OverlayRendererBase;
import fi.dy.masa.minihud.renderer.RenderObjectBase;
import fi.dy.masa.minihud.util.DataStorage;
import fi.dy.masa.minihud.util.MiscUtils;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_310;
import net.minecraft.class_3532;

public class OverlayRendererSlimeChunks
extends OverlayRendererBase {
    public static double overlayTopY;
    protected static boolean needsUpdate;
    protected boolean wasSeedKnown;
    protected long seed;
    protected double topY;

    @Override
    public String getName() {
        return "OverlayRendererSlimeChunks";
    }

    public static void setNeedsUpdate() {
        needsUpdate = true;
    }

    public static void onEnabled() {
        if (Configs.Generic.SLIME_CHUNK_TOP_TO_PLAYER.getBooleanValue()) {
            class_1297 entity = EntityUtils.getCameraEntity();
            if (entity != null) {
                overlayTopY = entity.method_23318();
            }
        } else {
            overlayTopY = 40.0;
        }
        OverlayRendererSlimeChunks.setNeedsUpdate();
    }

    @Override
    public boolean shouldRender(class_310 mc) {
        return RendererToggle.OVERLAY_SLIME_CHUNKS_OVERLAY.getBooleanValue() && mc.field_1687 != null && DataStorage.getInstance().isWorldSeedKnown((class_1937)mc.field_1687) && MiscUtils.isOverworld((class_1937)mc.field_1687);
    }

    @Override
    public boolean needsUpdate(class_1297 entity, class_310 mc) {
        if (needsUpdate) {
            return true;
        }
        class_1937 world = entity.method_5770();
        boolean isSeedKnown = DataStorage.getInstance().isWorldSeedKnown(world);
        long seed = DataStorage.getInstance().getWorldSeed(world);
        if (this.topY != overlayTopY || this.wasSeedKnown != isSeedKnown || this.seed != seed) {
            return true;
        }
        int ex = (int)Math.floor(entity.method_23317());
        int ez = (int)Math.floor(entity.method_23321());
        int lx = this.lastUpdatePos.method_10263();
        int lz = this.lastUpdatePos.method_10260();
        return Math.abs(lx - ex) > 16 || Math.abs(lz - ez) > 16;
    }

    @Override
    public void update(class_243 cameraPos, class_1297 entity, class_310 mc) {
        DataStorage data = DataStorage.getInstance();
        class_1937 world = entity.method_5770();
        this.topY = overlayTopY;
        this.wasSeedKnown = data.isWorldSeedKnown(world);
        this.seed = data.getWorldSeed(world);
        if (this.wasSeedKnown) {
            int centerX = class_3532.method_15357((double)entity.method_23317()) >> 4;
            int centerZ = class_3532.method_15357((double)entity.method_23321()) >> 4;
            Color4f colorSides = Configs.Colors.SLIME_CHUNKS_OVERLAY_COLOR.getColor();
            Color4f colorLines = Color4f.fromColor((Color4f)colorSides, (float)1.0f);
            class_2338.class_2339 pos1 = new class_2338.class_2339();
            class_2338.class_2339 pos2 = new class_2338.class_2339();
            int r = class_3532.method_15340((int)Configs.Generic.SLIME_CHUNK_OVERLAY_RADIUS.getIntegerValue(), (int)-1, (int)40);
            if (r == -1) {
                r = (Integer)mc.field_1690.method_42503().method_41753();
            }
            RenderObjectBase renderQuads = (RenderObjectBase)this.renderObjects.get(0);
            RenderObjectBase renderLines = (RenderObjectBase)this.renderObjects.get(1);
            BUFFER_1 = TESSELLATOR_1.method_60827(renderQuads.getGlMode(), class_290.field_1576);
            BUFFER_2 = TESSELLATOR_2.method_60827(renderLines.getGlMode(), class_290.field_1576);
            int minY = world != null ? world.method_31607() : -64;
            int topY = (int)Math.floor(this.topY);
            for (int xOff = -r; xOff <= r; ++xOff) {
                for (int zOff = -r; zOff <= r; ++zOff) {
                    int cx = centerX + xOff;
                    int cz = centerZ + zOff;
                    if (!MiscUtils.canSlimeSpawnInChunk(cx, cz, this.seed)) continue;
                    pos1.method_10103(cx << 4, minY, cz << 4);
                    pos2.method_10103((cx << 4) + 15, topY, (cz << 4) + 15);
                    RenderUtils.drawBoxWithEdgesBatched((class_2338)pos1, (class_2338)pos2, (class_243)cameraPos, (Color4f)colorLines, (Color4f)colorSides, (class_287)BUFFER_1, (class_287)BUFFER_2);
                }
            }
            renderQuads.uploadData(BUFFER_1);
            renderLines.uploadData(BUFFER_2);
        }
        needsUpdate = false;
    }

    @Override
    public String getSaveId() {
        return "slime_chunks";
    }

    @Override
    public JsonObject toJson() {
        JsonObject obj = new JsonObject();
        obj.add("y_top", (JsonElement)new JsonPrimitive((Number)overlayTopY));
        return obj;
    }

    @Override
    public void fromJson(JsonObject obj) {
        overlayTopY = JsonUtils.getFloat((JsonObject)obj, (String)"y_top");
    }

    static {
        needsUpdate = true;
    }
}

