/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer;

import fi.dy.masa.malilib.util.Color4f;
import fi.dy.masa.malilib.util.PositionUtils;
import fi.dy.masa.minihud.MiniHUD;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.config.RendererToggle;
import fi.dy.masa.minihud.renderer.OverlayRendererBase;
import fi.dy.masa.minihud.renderer.RenderObjectBase;
import fi.dy.masa.minihud.renderer.RenderUtils;
import fi.dy.masa.minihud.util.DataStorage;
import fi.dy.masa.minihud.util.MiscUtils;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_310;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.tuple.Pair;

public class OverlayRendererSpawnChunks
extends OverlayRendererBase {
    protected static boolean needsUpdate = true;
    protected final RendererToggle toggle;
    protected final boolean isPlayerFollowing;

    public OverlayRendererSpawnChunks(RendererToggle toggle) {
        this.toggle = toggle;
        this.isPlayerFollowing = toggle == RendererToggle.OVERLAY_SPAWN_CHUNK_OVERLAY_PLAYER;
    }

    @Override
    public String getName() {
        return "OverlayRendererSpawnChunks";
    }

    public static void setNeedsUpdate() {
        needsUpdate = true;
    }

    @Override
    public boolean shouldRender(class_310 mc) {
        return this.toggle.getBooleanValue() && (this.isPlayerFollowing || mc.field_1687 != null && MiscUtils.isOverworld((class_1937)mc.field_1687) && DataStorage.getInstance().isWorldSpawnKnown());
    }

    @Override
    public boolean needsUpdate(class_1297 entity, class_310 mc) {
        if (needsUpdate) {
            return true;
        }
        entity = this.isPlayerFollowing ? mc.field_1724 : entity;
        int ex = (int)Math.floor(entity.method_23317());
        int ez = (int)Math.floor(entity.method_23321());
        int lx = this.lastUpdatePos.method_10263();
        int lz = this.lastUpdatePos.method_10260();
        if (this.isPlayerFollowing) {
            return ex != lx || ez != lz;
        }
        int range = (Integer)mc.field_1690.method_42503().method_41753() * 16;
        return Math.abs(lx - ex) > range || Math.abs(lz - ez) > range;
    }

    @Override
    public void update(class_243 cameraPos, class_1297 entity, class_310 mc) {
        int brown;
        int green;
        int red;
        class_2338 spawn;
        entity = this.isPlayerFollowing ? mc.field_1724 : entity;
        DataStorage data = DataStorage.getInstance();
        if (this.isPlayerFollowing) {
            spawn = PositionUtils.getEntityBlockPos((class_1297)entity);
            int spawnChunkRadius = this.getSimulationDistance();
            red = spawnChunkRadius + 1;
            green = spawnChunkRadius - 1;
            brown = red + 11;
        } else {
            spawn = data.getWorldSpawn();
            int spawnChunkRadius = data.getSpawnChunkRadius();
            if (spawnChunkRadius < 0) {
                spawnChunkRadius = this.getSpawnChunkRadius((MinecraftServer)mc.method_1576());
                data.setSpawnChunkRadiusIfUnknown(spawnChunkRadius);
            }
            if (spawnChunkRadius < 0) {
                spawnChunkRadius = 2;
            }
            if (spawnChunkRadius == 0) {
                MiniHUD.logger.warn("overlaySpawnChunkReal: toggling feature OFF since SPAWN_CHUNK_RADIUS is set to 0 (Nothing to render)");
                RendererToggle.OVERLAY_SPAWN_CHUNK_OVERLAY_REAL.setBooleanValue(false);
                needsUpdate = false;
                return;
            }
            red = spawnChunkRadius + 1;
            green = spawnChunkRadius - 1;
            brown = red + 11;
        }
        RenderObjectBase renderQuads = (RenderObjectBase)this.renderObjects.get(0);
        RenderObjectBase renderLines = (RenderObjectBase)this.renderObjects.get(1);
        BUFFER_1 = TESSELLATOR_1.method_60827(renderQuads.getGlMode(), class_290.field_1576);
        BUFFER_2 = TESSELLATOR_2.method_60827(renderLines.getGlMode(), class_290.field_1576);
        Color4f colorEntity = this.isPlayerFollowing ? Configs.Colors.SPAWN_PLAYER_ENTITY_OVERLAY_COLOR.getColor() : Configs.Colors.SPAWN_REAL_ENTITY_OVERLAY_COLOR.getColor();
        Color4f colorLazy = this.isPlayerFollowing ? Configs.Colors.SPAWN_PLAYER_LAZY_OVERLAY_COLOR.getColor() : Configs.Colors.SPAWN_REAL_LAZY_OVERLAY_COLOR.getColor();
        Color4f colorOuter = this.isPlayerFollowing ? Configs.Colors.SPAWN_PLAYER_OUTER_OVERLAY_COLOR.getColor() : Configs.Colors.SPAWN_REAL_OUTER_OVERLAY_COLOR.getColor();
        fi.dy.masa.malilib.render.RenderUtils.drawBlockBoundingBoxOutlinesBatchedLines((class_2338)spawn, (class_243)cameraPos, (Color4f)colorEntity, (double)0.001, (class_287)BUFFER_2);
        OverlayRendererSpawnChunks.drawBlockBoundingBoxSidesBatchedQuads(spawn, cameraPos, colorEntity, 0.001, BUFFER_1);
        Pair<class_2338, class_2338> corners = this.getSpawnChunkCorners(spawn, brown, (class_1937)mc.field_1687);
        RenderUtils.renderWallsWithLines((class_2338)corners.getLeft(), (class_2338)corners.getRight(), cameraPos, 16.0, 16.0, true, colorOuter, BUFFER_1, BUFFER_2);
        corners = this.getSpawnChunkCorners(spawn, red, (class_1937)mc.field_1687);
        RenderUtils.renderWallsWithLines((class_2338)corners.getLeft(), (class_2338)corners.getRight(), cameraPos, 16.0, 16.0, true, colorLazy, BUFFER_1, BUFFER_2);
        corners = this.getSpawnChunkCorners(spawn, green, (class_1937)mc.field_1687);
        RenderUtils.renderWallsWithLines((class_2338)corners.getLeft(), (class_2338)corners.getRight(), cameraPos, 16.0, 16.0, true, colorEntity, BUFFER_1, BUFFER_2);
        renderQuads.uploadData(BUFFER_1);
        renderLines.uploadData(BUFFER_2);
        needsUpdate = false;
    }

    protected Pair<class_2338, class_2338> getSpawnChunkCorners(class_2338 worldSpawn, int chunkRange, class_1937 world) {
        int cx = worldSpawn.method_10263() >> 4;
        int cz = worldSpawn.method_10260() >> 4;
        int minY = world != null ? world.method_31607() : -64;
        int maxY = world != null ? world.method_31600() : 320;
        class_2338 pos1 = new class_2338(cx - chunkRange << 4, minY, cz - chunkRange << 4);
        class_2338 pos2 = new class_2338((cx + chunkRange << 4) + 15, maxY, (cz + chunkRange << 4) + 15);
        return Pair.of((Object)pos1, (Object)pos2);
    }

    protected int getSpawnChunkRadius(@Nullable MinecraftServer server) {
        if (server != null) {
            return server.method_30002().method_8450().method_8356(class_1928.field_48374);
        }
        if (DataStorage.getInstance().isSpawnChunkRadiusKnown()) {
            return DataStorage.getInstance().getSpawnChunkRadius();
        }
        return 2;
    }

    protected int getSimulationDistance() {
        if (DataStorage.getInstance().isSimulationDistanceKnown()) {
            return DataStorage.getInstance().getSimulationDistance();
        }
        return 10;
    }

    public static void drawBlockBoundingBoxSidesBatchedQuads(class_2338 pos, class_243 cameraPos, Color4f color, double expand, class_287 buffer) {
        float minX = (float)((double)pos.method_10263() - cameraPos.field_1352 - expand);
        float minY = (float)((double)pos.method_10264() - cameraPos.field_1351 - expand);
        float minZ = (float)((double)pos.method_10260() - cameraPos.field_1350 - expand);
        float maxX = (float)((double)pos.method_10263() - cameraPos.field_1352 + expand + 1.0);
        float maxY = (float)((double)pos.method_10264() - cameraPos.field_1351 + expand + 1.0);
        float maxZ = (float)((double)pos.method_10260() - cameraPos.field_1350 + expand + 1.0);
        fi.dy.masa.malilib.render.RenderUtils.drawBoxAllSidesBatchedQuads((float)minX, (float)minY, (float)minZ, (float)maxX, (float)maxY, (float)maxZ, (Color4f)color, (class_287)buffer);
    }
}

