/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.util;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Queues;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.network.ClientPlayHandler;
import fi.dy.masa.malilib.network.IPluginClientPlayHandler;
import fi.dy.masa.malilib.util.InfoUtils;
import fi.dy.masa.malilib.util.JsonUtils;
import fi.dy.masa.malilib.util.PositionUtils;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.minihud.MiniHUD;
import fi.dy.masa.minihud.Reference;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.config.RendererToggle;
import fi.dy.masa.minihud.data.MobCapDataHandler;
import fi.dy.masa.minihud.network.ServuxStructuresHandler;
import fi.dy.masa.minihud.network.ServuxStructuresPacket;
import fi.dy.masa.minihud.renderer.OverlayRendererBeaconRange;
import fi.dy.masa.minihud.renderer.OverlayRendererBiomeBorders;
import fi.dy.masa.minihud.renderer.OverlayRendererConduitRange;
import fi.dy.masa.minihud.renderer.OverlayRendererLightLevel;
import fi.dy.masa.minihud.renderer.OverlayRendererSpawnChunks;
import fi.dy.masa.minihud.renderer.OverlayRendererSpawnableColumnHeights;
import fi.dy.masa.minihud.renderer.shapes.ShapeManager;
import fi.dy.masa.minihud.renderer.worker.ChunkTask;
import fi.dy.masa.minihud.renderer.worker.ThreadWorker;
import fi.dy.masa.minihud.util.MiscUtils;
import fi.dy.masa.minihud.util.StructureData;
import fi.dy.masa.minihud.util.StructureType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1132;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3449;
import net.minecraft.class_3738;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_7417;
import net.minecraft.class_7924;
import net.minecraft.class_8828;
import net.minecraft.server.MinecraftServer;

public class DataStorage {
    private static final ThreadFactory THREAD_FACTORY = new ThreadFactoryBuilder().setNameFormat("MiniHUD Worker Thread %d").setDaemon(true).build();
    private static final Pattern PATTERN_CARPET_TPS = Pattern.compile("TPS: (?<tps>[0-9]+[\\.,][0-9]) MSPT: (?<mspt>[0-9]+[\\.,][0-9])");
    private static final DataStorage INSTANCE = new DataStorage();
    private final MobCapDataHandler mobCapData = new MobCapDataHandler();
    private static final ServuxStructuresHandler<ServuxStructuresPacket.Payload> HANDLER = ServuxStructuresHandler.getInstance();
    private boolean worldSeedValid = false;
    private boolean carpetServer = false;
    private boolean servuxServer = false;
    private boolean hasInValidServux = false;
    private boolean hasIntegratedServer = false;
    private int spawnChunkRadius = -1;
    private boolean spawnChunkRadiusValid = false;
    private int simulationDistance = -1;
    private boolean worldSpawnValid = false;
    private int structureDataTimeout = 600;
    private boolean serverTPSValid;
    private boolean hasSyncedTime;
    private String servuxVersion;
    private int servuxTimeout;
    private boolean hasStructureDataFromServer;
    private boolean structureRendererNeedsUpdate;
    private boolean structuresNeedUpdating;
    private boolean shouldRegisterStructureChannel;
    private long worldSeed;
    private long lastServerTick;
    private long lastServerTimeUpdate;
    private class_2338 lastStructureUpdatePos;
    private double serverTPS;
    private double serverMSPT;
    private class_243 distanceReferencePoint = class_243.field_1353;
    private final int[] blockBreakCounter = new int[100];
    private final ArrayListMultimap<StructureType, StructureData> structures = ArrayListMultimap.create();
    private final class_310 mc = class_310.method_1551();
    private class_5455 registryManager = class_5455.field_40585;
    private class_2338 worldSpawn = class_2338.field_10980;
    private final PriorityBlockingQueue<ChunkTask> taskQueue = Queues.newPriorityBlockingQueue();
    private final Thread workerThread;
    private final ThreadWorker worker = new ThreadWorker();

    private DataStorage() {
        this.workerThread = THREAD_FACTORY.newThread(this.worker);
        this.workerThread.start();
    }

    public static DataStorage getInstance() {
        return INSTANCE;
    }

    public void onGameInit() {
        ClientPlayHandler.getInstance().registerClientPlayHandler(HANDLER);
        HANDLER.registerPlayPayload(ServuxStructuresPacket.Payload.ID, ServuxStructuresPacket.Payload.CODEC, 6);
    }

    public class_2960 getNetworkChannel() {
        return ServuxStructuresHandler.CHANNEL_ID;
    }

    public IPluginClientPlayHandler<ServuxStructuresPacket.Payload> getPacketHandler() {
        return HANDLER;
    }

    public MobCapDataHandler getMobCapData() {
        return this.mobCapData;
    }

    public void reset(boolean isLogout) {
        if (isLogout) {
            MiniHUD.printDebug("DataStorage#reset() - log-out", new Object[0]);
            HANDLER.reset(this.getNetworkChannel());
            HANDLER.resetFailures(this.getNetworkChannel());
            this.servuxServer = false;
            this.hasInValidServux = false;
            this.structureDataTimeout = 600;
            this.spawnChunkRadius = -1;
            this.registryManager = class_5455.field_40585;
            this.worldSpawn = class_2338.field_10980;
            this.carpetServer = false;
            this.worldSpawnValid = false;
            this.spawnChunkRadiusValid = false;
            this.setHasIntegratedServer(false);
        } else {
            MiniHUD.printDebug("DataStorage#reset() - dimension change or log-in", new Object[0]);
        }
        this.mobCapData.clear();
        this.serverTPSValid = false;
        this.hasSyncedTime = false;
        this.structuresNeedUpdating = true;
        this.hasStructureDataFromServer = false;
        this.structureRendererNeedsUpdate = true;
        this.lastStructureUpdatePos = null;
        this.structures.clear();
        this.clearTasks();
        this.servuxTimeout = -1;
        ShapeManager.INSTANCE.clear();
        OverlayRendererBeaconRange.INSTANCE.clear();
        OverlayRendererConduitRange.INSTANCE.clear();
        OverlayRendererBiomeBorders.INSTANCE.clear();
        OverlayRendererLightLevel.reset();
        if (isLogout || !Configs.Generic.DONT_RESET_SEED_ON_DIMENSION_CHANGE.getBooleanValue()) {
            this.worldSeedValid = false;
            this.worldSeed = 0L;
        }
    }

    public void clearTasks() {
        this.taskQueue.clear();
    }

    public ChunkTask getNextTask() throws InterruptedException {
        return this.taskQueue.take();
    }

    public void addTask(Runnable task, class_1923 pos, class_2382 playerPos) {
        if (this.taskQueue.size() < 64000) {
            this.taskQueue.offer(new ChunkTask(task, pos, playerPos));
        }
    }

    public void setIsServuxServer() {
        this.servuxServer = true;
        if (this.hasInValidServux) {
            this.hasInValidServux = false;
        }
    }

    public void setServuxVersion(String ver) {
        this.servuxVersion = ver != null && !ver.isEmpty() ? ver : "unknown";
    }

    public boolean hasIntegratedServer() {
        return this.hasIntegratedServer;
    }

    public void setHasIntegratedServer(boolean toggle) {
        this.hasIntegratedServer = toggle;
    }

    public void onWorldPre() {
        if (!this.hasIntegratedServer) {
            HANDLER.registerPlayReceiver(ServuxStructuresPacket.Payload.ID, HANDLER::receivePlayPayload);
        }
    }

    public void onWorldJoin() {
        MiniHUD.printDebug("DataStorage#onWorldJoin()", new Object[0]);
        OverlayRendererBeaconRange.INSTANCE.setNeedsUpdate();
        OverlayRendererConduitRange.INSTANCE.setNeedsUpdate();
        OverlayRendererSpawnChunks.setNeedsUpdate();
        if (!this.hasIntegratedServer) {
            if (RendererToggle.OVERLAY_STRUCTURE_MAIN_TOGGLE.getBooleanValue()) {
                this.registerStructureChannel();
                this.structuresNeedUpdating = true;
            } else {
                this.unregisterStructureChannel();
            }
        }
    }

    public void setWorldRegistryManager(class_5455 manager) {
        this.registryManager = manager != null && manager != class_5455.field_40585 ? manager : class_5455.field_40585;
    }

    public class_5455 getWorldRegistryManager() {
        if (this.registryManager != class_5455.field_40585) {
            return this.registryManager;
        }
        return class_5455.field_40585;
    }

    public void requestSpawnMetadata() {
        if (!this.hasIntegratedServer && this.hasServuxServer()) {
            class_2487 nbt = new class_2487();
            nbt.method_10582("version", Reference.MOD_STRING);
            HANDLER.encodeStructuresPacket(new ServuxStructuresPacket(ServuxStructuresPacket.Type.PACKET_C2S_REQUEST_SPAWN_METADATA, nbt));
        }
    }

    public void setWorldSeed(long seed) {
        if (this.worldSeed != seed) {
            MiniHUD.printDebug("DataStorage#setWorldSeed(): set world seed [{}] -> [{}]", this.worldSeed, seed);
        }
        this.worldSeed = seed;
        this.worldSeedValid = true;
    }

    public void setWorldSpawn(class_2338 spawn) {
        if (!this.worldSpawn.equals((Object)spawn)) {
            OverlayRendererSpawnChunks.setNeedsUpdate();
            MiniHUD.printDebug("DataStorage#setWorldSpawn(): set world spawn [{}] -> [{}]", this.worldSpawn.method_23854(), spawn.method_23854());
        }
        this.worldSpawn = spawn;
        this.worldSpawnValid = true;
    }

    public void setSpawnChunkRadius(int radius, boolean message) {
        if (radius >= 0 && radius <= 32) {
            if (this.spawnChunkRadius != radius) {
                if (message) {
                    String strRadius = radius > 0 ? GuiBase.TXT_GREEN + String.format("%d", radius) + GuiBase.TXT_RST : GuiBase.TXT_RED + String.format("%d", radius) + GuiBase.TXT_RST;
                    InfoUtils.printActionbarMessage((String)StringUtils.translate((String)"minihud.message.spawn_chunk_radius_set", (Object[])new Object[]{strRadius}), (Object[])new Object[0]);
                }
                OverlayRendererSpawnChunks.setNeedsUpdate();
                MiniHUD.printDebug("DataStorage#setSpawnChunkRadius(): set spawn chunk radius [{}] -> [{}]", this.spawnChunkRadius, radius);
            }
            this.spawnChunkRadius = radius;
            this.spawnChunkRadiusValid = true;
        } else {
            this.spawnChunkRadius = -1;
            this.spawnChunkRadiusValid = false;
        }
    }

    public void setWorldSpawnIfUnknown(class_2338 spawn) {
        if (!this.worldSpawnValid) {
            this.setWorldSpawn(spawn);
            OverlayRendererSpawnChunks.setNeedsUpdate();
        }
    }

    public void setSpawnChunkRadiusIfUnknown(int radius) {
        if (!this.spawnChunkRadiusValid) {
            this.setSpawnChunkRadius(radius, true);
            OverlayRendererSpawnChunks.setNeedsUpdate();
        }
    }

    public void setSimulationDistance(int distance) {
        if (distance >= 0) {
            if (this.simulationDistance != distance) {
                OverlayRendererSpawnChunks.setNeedsUpdate();
            }
            this.simulationDistance = distance;
        } else {
            this.simulationDistance = -1;
        }
    }

    public boolean isWorldSeedKnown(class_1937 world) {
        if (this.worldSeedValid) {
            return true;
        }
        if (this.mc.method_1496()) {
            class_1132 server = this.mc.method_1576();
            class_3218 worldTmp = server.method_3847(world.method_27983());
            return worldTmp != null;
        }
        return false;
    }

    public boolean hasStoredWorldSeed() {
        return this.worldSeedValid;
    }

    public long getWorldSeed(class_1937 world) {
        class_1132 server;
        class_3218 worldTmp;
        if (!this.worldSeedValid && this.mc.method_1496() && (worldTmp = (server = this.mc.method_1576()).method_3847(world.method_27983())) != null) {
            this.setWorldSeed(worldTmp.method_8412());
        }
        return this.worldSeed;
    }

    public void checkWorldSeed(MinecraftServer server) {
        long seedTmp;
        class_3218 worldTmp;
        if (this.hasIntegratedServer && (worldTmp = server.method_30002()) != null && (seedTmp = worldTmp.method_8412()) != this.worldSeed) {
            this.setWorldSeed(seedTmp);
        }
    }

    public boolean isWorldSpawnKnown() {
        return this.worldSpawnValid;
    }

    public class_2338 getWorldSpawn() {
        return this.worldSpawn;
    }

    public boolean isSpawnChunkRadiusKnown() {
        return this.spawnChunkRadiusValid;
    }

    public int getSpawnChunkRadius() {
        if (this.spawnChunkRadius > -1) {
            return this.spawnChunkRadius;
        }
        return 2;
    }

    public boolean isSimulationDistanceKnown() {
        return this.simulationDistance >= 0;
    }

    public int getSimulationDistance() {
        if (this.simulationDistance > 0) {
            return this.simulationDistance;
        }
        return 10;
    }

    public boolean hasTPSData() {
        return this.serverTPSValid;
    }

    public boolean hasCarpetServer() {
        return this.carpetServer;
    }

    public boolean hasServuxServer() {
        return this.servuxServer;
    }

    public double getServerTPS() {
        return this.serverTPS;
    }

    public double getServerMSPT() {
        return this.serverMSPT;
    }

    public boolean structureRendererNeedsUpdate() {
        return this.structureRendererNeedsUpdate;
    }

    public void setStructuresNeedUpdating() {
        this.structuresNeedUpdating = true;
    }

    public void setStructureRendererNeedsUpdate() {
        this.structureRendererNeedsUpdate = true;
    }

    public class_243 getDistanceReferencePoint() {
        return this.distanceReferencePoint;
    }

    public void setDistanceReferencePoint(class_243 pos) {
        this.distanceReferencePoint = pos;
        String str = String.format("x: %.2f, y: %.2f, z: %.2f", pos.field_1352, pos.field_1351, pos.field_1350);
        InfoUtils.printActionbarMessage((String)"minihud.message.distance_reference_point_set", (Object[])new Object[]{str});
    }

    public void markChunkForHeightmapCheck(int chunkX, int chunkZ) {
        class_1297 entity = class_310.method_1551().method_1560();
        if (entity != null) {
            class_243 pos = entity.method_19538();
            if (Math.abs(pos.field_1352 - (double)(chunkX << 4) - 8.0) <= 48.0 || Math.abs(pos.field_1350 - (double)(chunkZ << 4) - 8.0) <= 48.0) {
                OverlayRendererSpawnableColumnHeights.markChunkChanged(chunkX, chunkZ);
                OverlayRendererLightLevel.setNeedsUpdate();
            }
        }
    }

    public void onClientTickPre(class_310 mc) {
        if (mc.field_1687 != null) {
            int tick = (int)(mc.field_1687.method_8510() % (long)this.blockBreakCounter.length);
            this.blockBreakCounter[tick] = 0;
        }
    }

    public void onPlayerBlockBreak(class_310 mc) {
        if (mc.field_1687 != null) {
            int tick;
            int n = tick = (int)(mc.field_1687.method_8510() % (long)this.blockBreakCounter.length);
            this.blockBreakCounter[n] = this.blockBreakCounter[n] + 1;
        }
    }

    public double getBlockBreakingSpeed() {
        return MiscUtils.intAverage(this.blockBreakCounter) * 20.0;
    }

    public boolean onSendChatMessage(String message) {
        String[] parts = message.split(" ");
        if (parts.length > 0 && (parts[0].equals("minihud-seed") || parts[0].equals("/minihud-seed"))) {
            if (parts.length == 2) {
                try {
                    this.setWorldSeed(Long.parseLong(parts[1]));
                    InfoUtils.printActionbarMessage((String)"minihud.message.seed_set", (Object[])new Object[]{this.worldSeed});
                }
                catch (NumberFormatException e) {
                    InfoUtils.printActionbarMessage((String)"minihud.message.error.invalid_seed", (Object[])new Object[0]);
                }
            } else if (parts.length == 1) {
                if (this.worldSeedValid) {
                    InfoUtils.printActionbarMessage((String)"minihud.message.seed_is", (Object[])new Object[]{this.worldSeed});
                } else {
                    InfoUtils.printActionbarMessage((String)"minihud.message.no_seed", (Object[])new Object[0]);
                }
            }
            return true;
        }
        if (parts.length > 0 && (parts[0].equals("minihud-spawnchunkradius") || parts[0].equals("/minihud-spawnchunkradius"))) {
            block17: {
                if (parts.length == 2) {
                    try {
                        int radius = Integer.parseInt(parts[1]);
                        if (radius >= 0 && radius <= 32) {
                            this.setSpawnChunkRadius(radius, true);
                            break block17;
                        }
                        InfoUtils.printActionbarMessage((String)"minihud.message.error.invalid_spawn_chunk_radius", (Object[])new Object[0]);
                    }
                    catch (NumberFormatException e) {
                        InfoUtils.printActionbarMessage((String)"minihud.message.error.invalid_spawn_chunk_radius", (Object[])new Object[0]);
                    }
                } else if (parts.length == 1) {
                    if (this.spawnChunkRadiusValid) {
                        String strRadius = this.spawnChunkRadius > 0 ? GuiBase.TXT_GREEN + String.format("%d", this.spawnChunkRadius) + GuiBase.TXT_RST : GuiBase.TXT_RED + String.format("%d", this.spawnChunkRadius) + GuiBase.TXT_RST;
                        InfoUtils.printActionbarMessage((String)StringUtils.translate((String)"minihud.message.spawn_chunk_radius_is", (Object[])new Object[]{strRadius}), (Object[])new Object[0]);
                    } else {
                        InfoUtils.printActionbarMessage((String)"minihud.message.no_spawn_chunk_radius", (Object[])new Object[0]);
                    }
                }
            }
            return true;
        }
        return false;
    }

    public void onChatMessage(class_2561 message) {
        class_5250 mutableText;
        class_7417 class_74172;
        if (message instanceof class_5250 && (class_74172 = (mutableText = (class_5250)message).method_10851()) instanceof class_2588) {
            class_2588 text = (class_2588)class_74172;
            if ("commands.seed.success".equals(text.method_11022()) && text.method_11023().length == 1) {
                try {
                    class_5250 m = (class_5250)text.method_11023()[0];
                    class_2588 t = (class_2588)m.method_10851();
                    class_8828.class_2585 l = (class_8828.class_2585)((class_5250)t.method_11023()[0]).method_10851();
                    String str = l.comp_737();
                    this.setWorldSeed(Long.parseLong(str));
                    MiniHUD.logger.info("Received world seed from the vanilla /seed command: {}", (Object)this.worldSeed);
                    InfoUtils.printActionbarMessage((String)"minihud.message.seed_set", (Object[])new Object[]{this.worldSeed});
                }
                catch (Exception e) {
                    MiniHUD.logger.warn("Failed to read the world seed from '{}'", text.method_11023()[0]);
                }
            } else if ("jed.commands.seed.success".equals(text.method_11022())) {
                try {
                    this.setWorldSeed(Long.parseLong(text.method_11023()[1].toString()));
                    MiniHUD.logger.info("Received world seed from the JED '/jed seed' command: {}", (Object)this.worldSeed);
                    InfoUtils.printActionbarMessage((String)"minihud.message.seed_set", (Object[])new Object[]{this.worldSeed});
                }
                catch (Exception e) {
                    MiniHUD.logger.warn("Failed to read the world seed from '{}'", text.method_11023()[1], (Object)e);
                }
            } else if ("commands.setworldspawn.success".equals(text.method_11022()) && text.method_11023().length == 4) {
                try {
                    o = text.method_11023();
                    int x = Integer.parseInt(o[0].toString());
                    int y = Integer.parseInt(o[1].toString());
                    int z = Integer.parseInt(o[2].toString());
                    this.setWorldSpawn(new class_2338(x, y, z));
                    String spawnStr = String.format("x: %d, y: %d, z: %d", this.worldSpawn.method_10263(), this.worldSpawn.method_10264(), this.worldSpawn.method_10260());
                    MiniHUD.logger.info("Received world spawn from the vanilla /setworldspawn command: {}", (Object)spawnStr);
                    InfoUtils.printActionbarMessage((String)"minihud.message.spawn_set", (Object[])new Object[]{spawnStr});
                }
                catch (Exception e) {
                    MiniHUD.logger.warn("Failed to read the world spawn point from '{}'", (Object)text.method_11023(), (Object)e);
                }
            } else if (("commands.gamerule.set".equals(text.method_11022()) || "commands.gamerule.query".equals(text.method_11022())) && text.method_11023().length == 2) {
                try {
                    o = text.method_11023();
                    String rule = o[0].toString();
                    if (rule.equals("spawnChunkRadius")) {
                        int value = Integer.parseInt(o[1].toString());
                        if (this.spawnChunkRadius != value) {
                            MiniHUD.logger.info("Received spawn chunk radius from the vanilla /gamerule command: {}", (Object)this.spawnChunkRadius);
                            this.setSpawnChunkRadius(value, true);
                        } else {
                            String strRadius = this.spawnChunkRadius > 0 ? GuiBase.TXT_GREEN + String.format("%d", this.spawnChunkRadius) + GuiBase.TXT_RST : GuiBase.TXT_RED + String.format("%d", this.spawnChunkRadius) + GuiBase.TXT_RST;
                            InfoUtils.printActionbarMessage((String)StringUtils.translate((String)"minihud.message.spawn_chunk_radius_is", (Object[])new Object[]{strRadius}), (Object[])new Object[0]);
                        }
                    }
                }
                catch (Exception e) {
                    MiniHUD.logger.warn("Failed to read the spawn chunk radius from '{}'", (Object)text.method_11023(), (Object)e);
                }
            }
        }
    }

    public void onServerTimeUpdate(long totalWorldTime) {
        if (!this.carpetServer && !this.mc.method_1542()) {
            long elapsedTicks;
            long currentTime = System.nanoTime();
            if (this.hasSyncedTime && (elapsedTicks = totalWorldTime - this.lastServerTick) > 0L) {
                this.serverMSPT = (double)(currentTime - this.lastServerTimeUpdate) / (double)elapsedTicks / 1000000.0;
                this.serverTPS = this.serverMSPT <= 50.0 ? 20.0 : 1000.0 / this.serverMSPT;
                this.serverTPSValid = true;
            }
            this.lastServerTick = totalWorldTime;
            this.lastServerTimeUpdate = currentTime;
            this.hasSyncedTime = true;
        }
    }

    public void updateIntegratedServerTPS() {
        if (this.mc != null && this.mc.field_1724 != null && this.mc.method_1576() != null) {
            this.serverMSPT = (double)MiscUtils.longAverage(this.mc.method_1576().method_54835()) / 1000000.0;
            this.serverTPS = this.serverMSPT <= 50.0 ? 20.0 : 1000.0 / this.serverMSPT;
            this.serverTPSValid = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayListMultimap<StructureType, StructureData> getCopyOfStructureData() {
        ArrayListMultimap copy = ArrayListMultimap.create();
        if (!RendererToggle.OVERLAY_STRUCTURE_MAIN_TOGGLE.getBooleanValue()) {
            return copy;
        }
        ArrayListMultimap<StructureType, StructureData> arrayListMultimap = this.structures;
        synchronized (arrayListMultimap) {
            for (StructureType type : StructureType.VALUES) {
                List values = this.structures.get((Object)type);
                if (values.isEmpty()) continue;
                copy.putAll((Object)type, (Iterable)values);
            }
            this.structureRendererNeedsUpdate = false;
        }
        return copy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayListMultimap<StructureType, StructureData> getCopyOfStructureDataWithinRange(class_2338 pos, int maxRange) {
        ArrayListMultimap copy = ArrayListMultimap.create();
        if (!RendererToggle.OVERLAY_STRUCTURE_MAIN_TOGGLE.getBooleanValue()) {
            return copy;
        }
        ArrayListMultimap<StructureType, StructureData> arrayListMultimap = this.structures;
        synchronized (arrayListMultimap) {
            for (StructureType type : StructureType.VALUES) {
                List values = this.structures.get((Object)type);
                ArrayList<StructureData> valuesCopy = new ArrayList<StructureData>();
                if (values.isEmpty()) continue;
                for (StructureData structure : values) {
                    if (!MiscUtils.isStructureWithinRange(structure.getBoundingBox(), pos, maxRange)) continue;
                    valuesCopy.add(structure);
                }
                copy.putAll((Object)type, valuesCopy);
            }
            this.structureRendererNeedsUpdate = false;
        }
        return copy;
    }

    public void updateStructureData() {
        long currentTime;
        if (this.mc != null && this.mc.field_1687 != null && this.mc.field_1724 != null && (currentTime = this.mc.field_1687.method_8510()) % 20L == 0L) {
            if (this.mc.method_1496()) {
                class_2338 playerPos;
                if (RendererToggle.OVERLAY_STRUCTURE_MAIN_TOGGLE.getBooleanValue() && this.structuresNeedUpdating(playerPos = PositionUtils.getEntityBlockPos((class_1297)this.mc.field_1724), 32)) {
                    this.updateStructureDataFromIntegratedServer(playerPos);
                }
            } else if (this.hasStructureDataFromServer) {
                this.removeExpiredStructures(currentTime, this.structureDataTimeout);
            } else if (this.shouldRegisterStructureChannel && this.mc.method_1562() != null) {
                if (RendererToggle.OVERLAY_STRUCTURE_MAIN_TOGGLE.getBooleanValue()) {
                    this.registerStructureChannel();
                    this.structuresNeedUpdating = true;
                }
                this.shouldRegisterStructureChannel = false;
            }
        }
    }

    public void registerStructureChannel() {
        this.shouldRegisterStructureChannel = true;
        if (!(this.servuxServer || this.hasIntegratedServer || this.hasInValidServux)) {
            if (HANDLER.isPlayRegistered(this.getNetworkChannel())) {
                MiniHUD.printDebug("DataStorage#registerStructureChannel(): sending STRUCTURES_REGISTER to Servux", new Object[0]);
                class_2487 nbt = new class_2487();
                nbt.method_10582("version", Reference.MOD_STRING);
                HANDLER.encodeStructuresPacket(new ServuxStructuresPacket(ServuxStructuresPacket.Type.PACKET_C2S_STRUCTURES_REGISTER, nbt));
            }
        } else {
            this.shouldRegisterStructureChannel = false;
        }
    }

    public boolean receiveServuxMetadata(class_2487 data) {
        if (!this.servuxServer && !this.hasIntegratedServer && this.shouldRegisterStructureChannel) {
            MiniHUD.printDebug("DataStorage#checkServuxMetadata(): received METADATA from Servux", new Object[0]);
            if (data.method_10550("version") != 2) {
                MiniHUD.logger.warn("structureChannel: Mis-matched protocol version!");
            }
            this.servuxTimeout = data.method_10550("timeout");
            this.setServuxVersion(data.method_10558("servux"));
            this.setWorldSpawn(new class_2338(data.method_10550("spawnPosX"), data.method_10550("spawnPosY"), data.method_10550("spawnPosZ")));
            this.setSpawnChunkRadius(data.method_10550("spawnChunkRadius"), true);
            this.setIsServuxServer();
            if (RendererToggle.OVERLAY_STRUCTURE_MAIN_TOGGLE.getBooleanValue()) {
                this.registerStructureChannel();
                return true;
            }
            this.unregisterStructureChannel();
        }
        return false;
    }

    public void receiveSpawnMetadata(class_2487 data) {
        if (!this.hasIntegratedServer) {
            MiniHUD.printDebug("DataStorage#receiveSpawnMetadata(): from Servux", new Object[0]);
            this.setServuxVersion(data.method_10558("servux"));
            this.setWorldSpawn(new class_2338(data.method_10550("spawnPosX"), data.method_10550("spawnPosY"), data.method_10550("spawnPosZ")));
            this.setSpawnChunkRadius(data.method_10550("spawnChunkRadius"), true);
            if (this.hasInValidServux) {
                this.hasInValidServux = false;
            }
        }
    }

    public void unregisterStructureChannel() {
        if (this.servuxServer || !RendererToggle.OVERLAY_STRUCTURE_MAIN_TOGGLE.getBooleanValue()) {
            this.servuxServer = false;
            if (!this.hasInValidServux) {
                MiniHUD.printDebug("DataStorage#unregisterStructureChannel(): for {}", this.servuxVersion != null ? this.servuxVersion : "<unknown>");
                HANDLER.encodeStructuresPacket(new ServuxStructuresPacket(ServuxStructuresPacket.Type.PACKET_C2S_STRUCTURES_UNREGISTER, new class_2487()));
                HANDLER.reset(this.getNetworkChannel());
            }
        }
        this.shouldRegisterStructureChannel = false;
    }

    public void onPacketFailure() {
        this.shouldRegisterStructureChannel = false;
        this.servuxServer = false;
        this.hasInValidServux = true;
    }

    private boolean structuresNeedUpdating(class_2338 playerPos, int hysteresis) {
        return this.structuresNeedUpdating || this.lastStructureUpdatePos == null || Math.abs(playerPos.method_10263() - this.lastStructureUpdatePos.method_10263()) >= hysteresis || Math.abs(playerPos.method_10264() - this.lastStructureUpdatePos.method_10264()) >= hysteresis || Math.abs(playerPos.method_10260() - this.lastStructureUpdatePos.method_10260()) >= hysteresis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateStructureDataFromIntegratedServer(class_2338 playerPos) {
        class_5321 worldId = this.mc.field_1724.method_5770().method_27983();
        class_3218 world = this.mc.method_1576().method_3847(worldId);
        if (world != null) {
            class_1132 server = this.mc.method_1576();
            int maxChunkRange = this.mc.field_1690.method_38521();
            server.method_18858((Runnable)new class_3738(server.method_3780(), () -> {
                ArrayListMultimap<StructureType, StructureData> arrayListMultimap = this.structures;
                synchronized (arrayListMultimap) {
                    this.addStructureDataFromGenerator(world, playerPos, maxChunkRange);
                }
            }));
        } else {
            ArrayListMultimap<StructureType, StructureData> arrayListMultimap = this.structures;
            synchronized (arrayListMultimap) {
                this.structures.clear();
            }
        }
        this.lastStructureUpdatePos = playerPos;
        this.structuresNeedUpdating = false;
    }

    public void addOrUpdateStructuresFromServer(class_2499 structures, boolean isServux) {
        if (!isServux) {
            MiniHUD.printDebug("DataStorage#addOrUpdateStructuresFromServer(): Ignoring structure data when isServux is false", new Object[0]);
            return;
        }
        if (structures.method_10601() == 10) {
            this.structureDataTimeout = this.servuxTimeout + 300;
            long currentTime = this.mc.field_1687.method_8510();
            int count = structures.size();
            int oldCount = this.structures.size();
            this.removeExpiredStructures(currentTime, this.structureDataTimeout);
            for (int i = 0; i < count; ++i) {
                class_2487 tag = structures.method_10602(i);
                StructureData data = StructureData.fromStructureStartTag(tag, currentTime);
                if (data == null) continue;
                if (this.structures.containsEntry((Object)data.getStructureType(), (Object)data)) {
                    this.structures.remove((Object)data.getStructureType(), (Object)data);
                }
                this.structures.put((Object)data.getStructureType(), (Object)data);
            }
            MiniHUD.printDebug("addOrUpdateStructuresFromServer: received {} structures // total size {} -> {}", count, oldCount, this.structures.size());
            this.structureRendererNeedsUpdate = true;
            this.hasStructureDataFromServer = true;
        }
    }

    private void removeExpiredStructures(long currentTime, int timeout) {
        int countBefore = this.structures.values().size();
        this.structures.values().removeIf(data -> currentTime > data.getRefreshTime() + (long)timeout);
        int countAfter = this.structures.values().size();
        if (countBefore != countAfter) {
            MiniHUD.printDebug("removeExpiredStructures: from server: {} -> {} structures", countBefore, countAfter);
        }
    }

    private void addStructureDataFromGenerator(class_3218 world, class_2338 playerPos, int maxChunkRange) {
        int lastCount = this.structures.size();
        this.structures.clear();
        int minCX = (playerPos.method_10263() >> 4) - maxChunkRange;
        int minCZ = (playerPos.method_10260() >> 4) - maxChunkRange;
        int maxCX = (playerPos.method_10263() >> 4) + maxChunkRange;
        int maxCZ = (playerPos.method_10260() >> 4) + maxChunkRange;
        for (int cz = minCZ; cz <= maxCZ; ++cz) {
            for (int cx = minCX; cx <= maxCX; ++cx) {
                class_2791 chunk;
                try {
                    chunk = world.method_8402(cx, cz, class_2806.field_12803, false);
                }
                catch (Exception ignored) {
                    continue;
                }
                if (chunk == null) continue;
                for (Map.Entry entry : chunk.method_12016().entrySet()) {
                    class_3195 structure = (class_3195)entry.getKey();
                    class_3449 start = (class_3449)entry.getValue();
                    class_2960 id = world.method_30349().method_30530(class_7924.field_41246).method_10221((Object)structure);
                    StructureType type = StructureType.fromStructureId(id != null ? id.toString() : "?");
                    if (!type.isEnabled() || !start.method_16657() || !MiscUtils.isStructureWithinRange(start.method_14969(), playerPos, maxChunkRange << 4)) continue;
                    this.structures.put((Object)type, (Object)StructureData.fromStructureStart(type, start));
                }
            }
        }
        MiniHUD.printDebug("addStructureDataFromGenerator: updated from the integrated server: {} -> {} structures", lastCount, this.structures.size());
        this.structureRendererNeedsUpdate = true;
    }

    public void handleCarpetServerTPSData(class_2561 textComponent) {
        if (!textComponent.getString().isEmpty()) {
            String[] lines;
            String text = class_124.method_539((String)textComponent.getString());
            for (String line : lines = text.split("\n")) {
                Matcher matcher = PATTERN_CARPET_TPS.matcher(line);
                if (!matcher.matches()) continue;
                try {
                    this.serverTPS = Double.parseDouble(matcher.group("tps"));
                    this.serverMSPT = Double.parseDouble(matcher.group("mspt"));
                    this.serverTPSValid = true;
                    this.carpetServer = true;
                    return;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    public JsonObject toJson() {
        JsonObject obj = new JsonObject();
        obj.add("distance_pos", (JsonElement)JsonUtils.vec3dToJson((class_243)this.distanceReferencePoint));
        if (this.worldSeedValid) {
            obj.add("seed", (JsonElement)new JsonPrimitive((Number)this.worldSeed));
        }
        if (this.isSpawnChunkRadiusKnown()) {
            obj.add("spawn_chunk_radius", (JsonElement)new JsonPrimitive((Number)this.spawnChunkRadius));
        }
        return obj;
    }

    public void fromJson(JsonObject obj) {
        class_243 pos = JsonUtils.vec3dFromJson((JsonObject)obj, (String)"distance_pos");
        this.distanceReferencePoint = Objects.requireNonNullElse(pos, class_243.field_1353);
        if (JsonUtils.hasLong((JsonObject)obj, (String)"seed")) {
            long seedTmp = JsonUtils.getLong((JsonObject)obj, (String)"seed");
            if (this.hasIntegratedServer && this.hasStoredWorldSeed() && this.worldSeed != seedTmp) {
                MiniHUD.printDebug("DataStorage#fromJson(): ignoring stale WorldSeed [{}], keeping [{}] as valid from the integrated server", seedTmp, this.worldSeed);
            } else {
                this.setWorldSeed(seedTmp);
            }
        }
        if (JsonUtils.hasInteger((JsonObject)obj, (String)"spawn_chunk_radius")) {
            int spawnRadiusTmp = JsonUtils.getIntegerOrDefault((JsonObject)obj, (String)"spawn_chunk_radius", (int)2);
            if (this.hasIntegratedServer && this.isSpawnChunkRadiusKnown() && this.spawnChunkRadius != spawnRadiusTmp) {
                MiniHUD.printDebug("DataStorage#fromJson(): ignoring stale Spawn Chunk Radius [{}], keeping [{}] as valid from the integrated server", spawnRadiusTmp, this.spawnChunkRadius);
            } else {
                this.setSpawnChunkRadius(spawnRadiusTmp, false);
            }
            if (this.getSpawnChunkRadius() == 0 && RendererToggle.OVERLAY_SPAWN_CHUNK_OVERLAY_REAL.getBooleanValue()) {
                MiniHUD.logger.warn("DataStorage#fromJson(): toggling feature OFF since SPAWN_CHUNK_RADIUS is set to 0");
                RendererToggle.OVERLAY_SPAWN_CHUNK_OVERLAY_REAL.setBooleanValue(false);
                OverlayRendererSpawnChunks.setNeedsUpdate();
            }
        }
    }
}

