/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.config;

import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import org.jetbrains.annotations.NotNull;
import su.plo.config.Config;
import su.plo.config.ConfigField;
import su.plo.config.entry.BooleanConfigEntry;
import su.plo.config.entry.ConfigEntry;
import su.plo.config.entry.DoubleConfigEntry;
import su.plo.config.entry.EnumConfigEntry;
import su.plo.config.entry.IntConfigEntry;
import su.plo.config.entry.SerializableConfigEntry;
import su.plo.config.provider.ConfigurationProvider;
import su.plo.config.provider.toml.TomlConfiguration;
import su.plo.voice.api.client.config.ClientConfig;
import su.plo.voice.api.client.config.IconPosition;
import su.plo.voice.api.client.config.overlay.OverlayPosition;
import su.plo.voice.api.client.config.overlay.OverlaySourceState;
import su.plo.voice.api.client.config.overlay.OverlayStyle;
import su.plo.voice.client.config.capture.ConfigClientActivation;
import su.plo.voice.client.config.keybind.ConfigKeyBindings;
import su.plo.voice.proto.data.audio.capture.Activation;
import su.plo.voice.proto.data.audio.line.SourceLine;

@Config
public final class VoiceClientConfig
implements ClientConfig {
    private static final TomlConfiguration toml = (TomlConfiguration)ConfigurationProvider.getProvider(TomlConfiguration.class);
    @ConfigField
    private BooleanConfigEntry debug = new BooleanConfigEntry(false);
    @ConfigField
    private BooleanConfigEntry disableCrowdin = new BooleanConfigEntry(false);
    @ConfigField
    private BooleanConfigEntry checkForUpdates = new BooleanConfigEntry(true);
    @ConfigField
    private Voice voice = new Voice();
    @ConfigField
    private Advanced advanced = new Advanced();
    @ConfigField
    private Activations activations = new Activations();
    @ConfigField
    private Overlay overlay = new Overlay();
    @ConfigField
    private ConfigKeyBindings keyBindings = new ConfigKeyBindings();
    @ConfigField
    private Servers servers = new Servers();
    @ConfigField
    private Addons addons = new Addons();
    private File configFile;
    private ExecutorService asyncExecutor;

    public void save(boolean async) {
        if (this.configFile == null) {
            throw new IllegalStateException("configFile is null");
        }
        if (async && this.asyncExecutor != null && !this.asyncExecutor.isShutdown()) {
            this.asyncExecutor.execute(this::save);
        } else {
            this.save();
        }
    }

    private synchronized void save() {
        try {
            toml.save(VoiceClientConfig.class, this, this.configFile);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to save the config", e);
        }
    }

    @Override
    public BooleanConfigEntry getDebug() {
        return this.debug;
    }

    @Override
    public BooleanConfigEntry getDisableCrowdin() {
        return this.disableCrowdin;
    }

    @Override
    public BooleanConfigEntry getCheckForUpdates() {
        return this.checkForUpdates;
    }

    @Override
    public Voice getVoice() {
        return this.voice;
    }

    @Override
    public Advanced getAdvanced() {
        return this.advanced;
    }

    public Activations getActivations() {
        return this.activations;
    }

    public Overlay getOverlay() {
        return this.overlay;
    }

    public ConfigKeyBindings getKeyBindings() {
        return this.keyBindings;
    }

    public Servers getServers() {
        return this.servers;
    }

    public Addons getAddons() {
        return this.addons;
    }

    public void setDebug(BooleanConfigEntry debug) {
        this.debug = debug;
    }

    public void setDisableCrowdin(BooleanConfigEntry disableCrowdin) {
        this.disableCrowdin = disableCrowdin;
    }

    public void setCheckForUpdates(BooleanConfigEntry checkForUpdates) {
        this.checkForUpdates = checkForUpdates;
    }

    public void setVoice(Voice voice) {
        this.voice = voice;
    }

    public void setAdvanced(Advanced advanced) {
        this.advanced = advanced;
    }

    public void setActivations(Activations activations) {
        this.activations = activations;
    }

    public void setOverlay(Overlay overlay) {
        this.overlay = overlay;
    }

    public void setKeyBindings(ConfigKeyBindings keyBindings) {
        this.keyBindings = keyBindings;
    }

    public void setServers(Servers servers) {
        this.servers = servers;
    }

    public void setAddons(Addons addons) {
        this.addons = addons;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VoiceClientConfig)) {
            return false;
        }
        VoiceClientConfig other = (VoiceClientConfig)o;
        BooleanConfigEntry this$debug = this.getDebug();
        BooleanConfigEntry other$debug = other.getDebug();
        if (this$debug == null ? other$debug != null : !this$debug.equals(other$debug)) {
            return false;
        }
        BooleanConfigEntry this$disableCrowdin = this.getDisableCrowdin();
        BooleanConfigEntry other$disableCrowdin = other.getDisableCrowdin();
        if (this$disableCrowdin == null ? other$disableCrowdin != null : !this$disableCrowdin.equals(other$disableCrowdin)) {
            return false;
        }
        BooleanConfigEntry this$checkForUpdates = this.getCheckForUpdates();
        BooleanConfigEntry other$checkForUpdates = other.getCheckForUpdates();
        if (this$checkForUpdates == null ? other$checkForUpdates != null : !this$checkForUpdates.equals(other$checkForUpdates)) {
            return false;
        }
        Voice this$voice = this.getVoice();
        Voice other$voice = other.getVoice();
        if (this$voice == null ? other$voice != null : !((Object)this$voice).equals(other$voice)) {
            return false;
        }
        Advanced this$advanced = this.getAdvanced();
        Advanced other$advanced = other.getAdvanced();
        if (this$advanced == null ? other$advanced != null : !((Object)this$advanced).equals(other$advanced)) {
            return false;
        }
        Activations this$activations = this.getActivations();
        Activations other$activations = other.getActivations();
        if (this$activations == null ? other$activations != null : !((Object)this$activations).equals(other$activations)) {
            return false;
        }
        Overlay this$overlay = this.getOverlay();
        Overlay other$overlay = other.getOverlay();
        if (this$overlay == null ? other$overlay != null : !((Object)this$overlay).equals(other$overlay)) {
            return false;
        }
        ConfigKeyBindings this$keyBindings = this.getKeyBindings();
        ConfigKeyBindings other$keyBindings = other.getKeyBindings();
        if (this$keyBindings == null ? other$keyBindings != null : !this$keyBindings.equals(other$keyBindings)) {
            return false;
        }
        Servers this$servers = this.getServers();
        Servers other$servers = other.getServers();
        if (this$servers == null ? other$servers != null : !((Object)this$servers).equals(other$servers)) {
            return false;
        }
        Addons this$addons = this.getAddons();
        Addons other$addons = other.getAddons();
        if (this$addons == null ? other$addons != null : !((Object)this$addons).equals(other$addons)) {
            return false;
        }
        File this$configFile = this.getConfigFile();
        File other$configFile = other.getConfigFile();
        if (this$configFile == null ? other$configFile != null : !((Object)this$configFile).equals(other$configFile)) {
            return false;
        }
        ExecutorService this$asyncExecutor = this.getAsyncExecutor();
        ExecutorService other$asyncExecutor = other.getAsyncExecutor();
        return !(this$asyncExecutor == null ? other$asyncExecutor != null : !this$asyncExecutor.equals(other$asyncExecutor));
    }

    public int hashCode() {
        int PRIME = 59;
        int result2 = 1;
        BooleanConfigEntry $debug = this.getDebug();
        result2 = result2 * 59 + ($debug == null ? 43 : $debug.hashCode());
        BooleanConfigEntry $disableCrowdin = this.getDisableCrowdin();
        result2 = result2 * 59 + ($disableCrowdin == null ? 43 : $disableCrowdin.hashCode());
        BooleanConfigEntry $checkForUpdates = this.getCheckForUpdates();
        result2 = result2 * 59 + ($checkForUpdates == null ? 43 : $checkForUpdates.hashCode());
        Voice $voice = this.getVoice();
        result2 = result2 * 59 + ($voice == null ? 43 : ((Object)$voice).hashCode());
        Advanced $advanced = this.getAdvanced();
        result2 = result2 * 59 + ($advanced == null ? 43 : ((Object)$advanced).hashCode());
        Activations $activations = this.getActivations();
        result2 = result2 * 59 + ($activations == null ? 43 : ((Object)$activations).hashCode());
        Overlay $overlay = this.getOverlay();
        result2 = result2 * 59 + ($overlay == null ? 43 : ((Object)$overlay).hashCode());
        ConfigKeyBindings $keyBindings = this.getKeyBindings();
        result2 = result2 * 59 + ($keyBindings == null ? 43 : $keyBindings.hashCode());
        Servers $servers = this.getServers();
        result2 = result2 * 59 + ($servers == null ? 43 : ((Object)$servers).hashCode());
        Addons $addons = this.getAddons();
        result2 = result2 * 59 + ($addons == null ? 43 : ((Object)$addons).hashCode());
        File $configFile = this.getConfigFile();
        result2 = result2 * 59 + ($configFile == null ? 43 : ((Object)$configFile).hashCode());
        ExecutorService $asyncExecutor = this.getAsyncExecutor();
        result2 = result2 * 59 + ($asyncExecutor == null ? 43 : $asyncExecutor.hashCode());
        return result2;
    }

    public String toString() {
        return "VoiceClientConfig(debug=" + String.valueOf(this.getDebug()) + ", disableCrowdin=" + String.valueOf(this.getDisableCrowdin()) + ", checkForUpdates=" + String.valueOf(this.getCheckForUpdates()) + ", voice=" + String.valueOf(this.getVoice()) + ", advanced=" + String.valueOf(this.getAdvanced()) + ", activations=" + String.valueOf(this.getActivations()) + ", overlay=" + String.valueOf(this.getOverlay()) + ", keyBindings=" + String.valueOf(this.getKeyBindings()) + ", servers=" + String.valueOf(this.getServers()) + ", addons=" + String.valueOf(this.getAddons()) + ", configFile=" + String.valueOf(this.getConfigFile()) + ", asyncExecutor=" + String.valueOf(this.getAsyncExecutor()) + ")";
    }

    public File getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(File configFile) {
        this.configFile = configFile;
    }

    private ExecutorService getAsyncExecutor() {
        return this.asyncExecutor;
    }

    public void setAsyncExecutor(ExecutorService asyncExecutor) {
        this.asyncExecutor = asyncExecutor;
    }

    @Config
    public static class Voice
    implements ClientConfig.Voice {
        @ConfigField
        private BooleanConfigEntry disabled = new BooleanConfigEntry(false);
        @ConfigField
        private BooleanConfigEntry microphoneDisabled = new BooleanConfigEntry(false);
        @ConfigField
        private DoubleConfigEntry activationThreshold = new DoubleConfigEntry(-30.0, -60.0, 0.0);
        @ConfigField
        private ConfigEntry<String> inputDevice = new ConfigEntry<String>("");
        @ConfigField
        private ConfigEntry<String> outputDevice = new ConfigEntry<String>("");
        @ConfigField
        private BooleanConfigEntry disableInputDevice = new BooleanConfigEntry(false);
        @ConfigField
        private BooleanConfigEntry useJavaxInput = new BooleanConfigEntry(false);
        @ConfigField
        private DoubleConfigEntry microphoneVolume = new DoubleConfigEntry(1.0, 0.0, 2.0);
        @ConfigField
        private BooleanConfigEntry noiseSuppression = new BooleanConfigEntry(false);
        @ConfigField
        private DoubleConfigEntry volume = new DoubleConfigEntry(1.0, 0.0, 2.0);
        @ConfigField
        private BooleanConfigEntry compressorLimiter = new BooleanConfigEntry(true);
        @ConfigField
        private BooleanConfigEntry soundOcclusion = new BooleanConfigEntry(false);
        @ConfigField
        private BooleanConfigEntry directionalSources = new BooleanConfigEntry(false);
        @ConfigField
        private BooleanConfigEntry hrtf = new BooleanConfigEntry(false);
        @ConfigField
        private BooleanConfigEntry stereoCapture = new BooleanConfigEntry(false);
        @ConfigField
        private SourceLineVolumes volumes = new SourceLineVolumes();

        @Override
        public BooleanConfigEntry getDisabled() {
            return this.disabled;
        }

        @Override
        public BooleanConfigEntry getMicrophoneDisabled() {
            return this.microphoneDisabled;
        }

        @Override
        public DoubleConfigEntry getActivationThreshold() {
            return this.activationThreshold;
        }

        @Override
        public ConfigEntry<String> getInputDevice() {
            return this.inputDevice;
        }

        @Override
        public ConfigEntry<String> getOutputDevice() {
            return this.outputDevice;
        }

        public BooleanConfigEntry getDisableInputDevice() {
            return this.disableInputDevice;
        }

        @Override
        public BooleanConfigEntry getUseJavaxInput() {
            return this.useJavaxInput;
        }

        @Override
        public DoubleConfigEntry getMicrophoneVolume() {
            return this.microphoneVolume;
        }

        @Override
        public BooleanConfigEntry getNoiseSuppression() {
            return this.noiseSuppression;
        }

        @Override
        public DoubleConfigEntry getVolume() {
            return this.volume;
        }

        public BooleanConfigEntry getCompressorLimiter() {
            return this.compressorLimiter;
        }

        @Override
        public BooleanConfigEntry getSoundOcclusion() {
            return this.soundOcclusion;
        }

        @Override
        public BooleanConfigEntry getDirectionalSources() {
            return this.directionalSources;
        }

        @Override
        public BooleanConfigEntry getHrtf() {
            return this.hrtf;
        }

        @Override
        public BooleanConfigEntry getStereoCapture() {
            return this.stereoCapture;
        }

        @Override
        public SourceLineVolumes getVolumes() {
            return this.volumes;
        }

        public void setDisabled(BooleanConfigEntry disabled) {
            this.disabled = disabled;
        }

        public void setMicrophoneDisabled(BooleanConfigEntry microphoneDisabled) {
            this.microphoneDisabled = microphoneDisabled;
        }

        public void setActivationThreshold(DoubleConfigEntry activationThreshold) {
            this.activationThreshold = activationThreshold;
        }

        public void setInputDevice(ConfigEntry<String> inputDevice) {
            this.inputDevice = inputDevice;
        }

        public void setOutputDevice(ConfigEntry<String> outputDevice) {
            this.outputDevice = outputDevice;
        }

        public void setDisableInputDevice(BooleanConfigEntry disableInputDevice) {
            this.disableInputDevice = disableInputDevice;
        }

        public void setUseJavaxInput(BooleanConfigEntry useJavaxInput) {
            this.useJavaxInput = useJavaxInput;
        }

        public void setMicrophoneVolume(DoubleConfigEntry microphoneVolume) {
            this.microphoneVolume = microphoneVolume;
        }

        public void setNoiseSuppression(BooleanConfigEntry noiseSuppression) {
            this.noiseSuppression = noiseSuppression;
        }

        public void setVolume(DoubleConfigEntry volume) {
            this.volume = volume;
        }

        public void setCompressorLimiter(BooleanConfigEntry compressorLimiter) {
            this.compressorLimiter = compressorLimiter;
        }

        public void setSoundOcclusion(BooleanConfigEntry soundOcclusion) {
            this.soundOcclusion = soundOcclusion;
        }

        public void setDirectionalSources(BooleanConfigEntry directionalSources) {
            this.directionalSources = directionalSources;
        }

        public void setHrtf(BooleanConfigEntry hrtf) {
            this.hrtf = hrtf;
        }

        public void setStereoCapture(BooleanConfigEntry stereoCapture) {
            this.stereoCapture = stereoCapture;
        }

        public void setVolumes(SourceLineVolumes volumes) {
            this.volumes = volumes;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Voice)) {
                return false;
            }
            Voice other = (Voice)o;
            if (!other.canEqual(this)) {
                return false;
            }
            BooleanConfigEntry this$disabled = this.getDisabled();
            BooleanConfigEntry other$disabled = other.getDisabled();
            if (this$disabled == null ? other$disabled != null : !this$disabled.equals(other$disabled)) {
                return false;
            }
            BooleanConfigEntry this$microphoneDisabled = this.getMicrophoneDisabled();
            BooleanConfigEntry other$microphoneDisabled = other.getMicrophoneDisabled();
            if (this$microphoneDisabled == null ? other$microphoneDisabled != null : !this$microphoneDisabled.equals(other$microphoneDisabled)) {
                return false;
            }
            DoubleConfigEntry this$activationThreshold = this.getActivationThreshold();
            DoubleConfigEntry other$activationThreshold = other.getActivationThreshold();
            if (this$activationThreshold == null ? other$activationThreshold != null : !this$activationThreshold.equals(other$activationThreshold)) {
                return false;
            }
            ConfigEntry<String> this$inputDevice = this.getInputDevice();
            ConfigEntry<String> other$inputDevice = other.getInputDevice();
            if (this$inputDevice == null ? other$inputDevice != null : !this$inputDevice.equals(other$inputDevice)) {
                return false;
            }
            ConfigEntry<String> this$outputDevice = this.getOutputDevice();
            ConfigEntry<String> other$outputDevice = other.getOutputDevice();
            if (this$outputDevice == null ? other$outputDevice != null : !this$outputDevice.equals(other$outputDevice)) {
                return false;
            }
            BooleanConfigEntry this$disableInputDevice = this.getDisableInputDevice();
            BooleanConfigEntry other$disableInputDevice = other.getDisableInputDevice();
            if (this$disableInputDevice == null ? other$disableInputDevice != null : !this$disableInputDevice.equals(other$disableInputDevice)) {
                return false;
            }
            BooleanConfigEntry this$useJavaxInput = this.getUseJavaxInput();
            BooleanConfigEntry other$useJavaxInput = other.getUseJavaxInput();
            if (this$useJavaxInput == null ? other$useJavaxInput != null : !this$useJavaxInput.equals(other$useJavaxInput)) {
                return false;
            }
            DoubleConfigEntry this$microphoneVolume = this.getMicrophoneVolume();
            DoubleConfigEntry other$microphoneVolume = other.getMicrophoneVolume();
            if (this$microphoneVolume == null ? other$microphoneVolume != null : !this$microphoneVolume.equals(other$microphoneVolume)) {
                return false;
            }
            BooleanConfigEntry this$noiseSuppression = this.getNoiseSuppression();
            BooleanConfigEntry other$noiseSuppression = other.getNoiseSuppression();
            if (this$noiseSuppression == null ? other$noiseSuppression != null : !this$noiseSuppression.equals(other$noiseSuppression)) {
                return false;
            }
            DoubleConfigEntry this$volume = this.getVolume();
            DoubleConfigEntry other$volume = other.getVolume();
            if (this$volume == null ? other$volume != null : !this$volume.equals(other$volume)) {
                return false;
            }
            BooleanConfigEntry this$compressorLimiter = this.getCompressorLimiter();
            BooleanConfigEntry other$compressorLimiter = other.getCompressorLimiter();
            if (this$compressorLimiter == null ? other$compressorLimiter != null : !this$compressorLimiter.equals(other$compressorLimiter)) {
                return false;
            }
            BooleanConfigEntry this$soundOcclusion = this.getSoundOcclusion();
            BooleanConfigEntry other$soundOcclusion = other.getSoundOcclusion();
            if (this$soundOcclusion == null ? other$soundOcclusion != null : !this$soundOcclusion.equals(other$soundOcclusion)) {
                return false;
            }
            BooleanConfigEntry this$directionalSources = this.getDirectionalSources();
            BooleanConfigEntry other$directionalSources = other.getDirectionalSources();
            if (this$directionalSources == null ? other$directionalSources != null : !this$directionalSources.equals(other$directionalSources)) {
                return false;
            }
            BooleanConfigEntry this$hrtf = this.getHrtf();
            BooleanConfigEntry other$hrtf = other.getHrtf();
            if (this$hrtf == null ? other$hrtf != null : !this$hrtf.equals(other$hrtf)) {
                return false;
            }
            BooleanConfigEntry this$stereoCapture = this.getStereoCapture();
            BooleanConfigEntry other$stereoCapture = other.getStereoCapture();
            if (this$stereoCapture == null ? other$stereoCapture != null : !this$stereoCapture.equals(other$stereoCapture)) {
                return false;
            }
            SourceLineVolumes this$volumes = this.getVolumes();
            SourceLineVolumes other$volumes = other.getVolumes();
            return !(this$volumes == null ? other$volumes != null : !((Object)this$volumes).equals(other$volumes));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Voice;
        }

        public int hashCode() {
            int PRIME = 59;
            int result2 = 1;
            BooleanConfigEntry $disabled = this.getDisabled();
            result2 = result2 * 59 + ($disabled == null ? 43 : $disabled.hashCode());
            BooleanConfigEntry $microphoneDisabled = this.getMicrophoneDisabled();
            result2 = result2 * 59 + ($microphoneDisabled == null ? 43 : $microphoneDisabled.hashCode());
            DoubleConfigEntry $activationThreshold = this.getActivationThreshold();
            result2 = result2 * 59 + ($activationThreshold == null ? 43 : $activationThreshold.hashCode());
            ConfigEntry<String> $inputDevice = this.getInputDevice();
            result2 = result2 * 59 + ($inputDevice == null ? 43 : $inputDevice.hashCode());
            ConfigEntry<String> $outputDevice = this.getOutputDevice();
            result2 = result2 * 59 + ($outputDevice == null ? 43 : $outputDevice.hashCode());
            BooleanConfigEntry $disableInputDevice = this.getDisableInputDevice();
            result2 = result2 * 59 + ($disableInputDevice == null ? 43 : $disableInputDevice.hashCode());
            BooleanConfigEntry $useJavaxInput = this.getUseJavaxInput();
            result2 = result2 * 59 + ($useJavaxInput == null ? 43 : $useJavaxInput.hashCode());
            DoubleConfigEntry $microphoneVolume = this.getMicrophoneVolume();
            result2 = result2 * 59 + ($microphoneVolume == null ? 43 : $microphoneVolume.hashCode());
            BooleanConfigEntry $noiseSuppression = this.getNoiseSuppression();
            result2 = result2 * 59 + ($noiseSuppression == null ? 43 : $noiseSuppression.hashCode());
            DoubleConfigEntry $volume = this.getVolume();
            result2 = result2 * 59 + ($volume == null ? 43 : $volume.hashCode());
            BooleanConfigEntry $compressorLimiter = this.getCompressorLimiter();
            result2 = result2 * 59 + ($compressorLimiter == null ? 43 : $compressorLimiter.hashCode());
            BooleanConfigEntry $soundOcclusion = this.getSoundOcclusion();
            result2 = result2 * 59 + ($soundOcclusion == null ? 43 : $soundOcclusion.hashCode());
            BooleanConfigEntry $directionalSources = this.getDirectionalSources();
            result2 = result2 * 59 + ($directionalSources == null ? 43 : $directionalSources.hashCode());
            BooleanConfigEntry $hrtf = this.getHrtf();
            result2 = result2 * 59 + ($hrtf == null ? 43 : $hrtf.hashCode());
            BooleanConfigEntry $stereoCapture = this.getStereoCapture();
            result2 = result2 * 59 + ($stereoCapture == null ? 43 : $stereoCapture.hashCode());
            SourceLineVolumes $volumes = this.getVolumes();
            result2 = result2 * 59 + ($volumes == null ? 43 : ((Object)$volumes).hashCode());
            return result2;
        }

        public String toString() {
            return "VoiceClientConfig.Voice(disabled=" + String.valueOf(this.getDisabled()) + ", microphoneDisabled=" + String.valueOf(this.getMicrophoneDisabled()) + ", activationThreshold=" + String.valueOf(this.getActivationThreshold()) + ", inputDevice=" + String.valueOf(this.getInputDevice()) + ", outputDevice=" + String.valueOf(this.getOutputDevice()) + ", disableInputDevice=" + String.valueOf(this.getDisableInputDevice()) + ", useJavaxInput=" + String.valueOf(this.getUseJavaxInput()) + ", microphoneVolume=" + String.valueOf(this.getMicrophoneVolume()) + ", noiseSuppression=" + String.valueOf(this.getNoiseSuppression()) + ", volume=" + String.valueOf(this.getVolume()) + ", compressorLimiter=" + String.valueOf(this.getCompressorLimiter()) + ", soundOcclusion=" + String.valueOf(this.getSoundOcclusion()) + ", directionalSources=" + String.valueOf(this.getDirectionalSources()) + ", hrtf=" + String.valueOf(this.getHrtf()) + ", stereoCapture=" + String.valueOf(this.getStereoCapture()) + ", volumes=" + String.valueOf(this.getVolumes()) + ")";
        }

        public static class SourceLineVolumes
        implements SerializableConfigEntry,
        ClientConfig.Voice.Volumes {
            private Map<String, DoubleConfigEntry> volumeByLineName = Maps.newHashMap();
            private Map<String, BooleanConfigEntry> muteByLineName = Maps.newHashMap();

            @Override
            public synchronized void setVolume(@NotNull String lineName, double volume) {
                this.getVolume(lineName).set(volume);
            }

            @Override
            public synchronized DoubleConfigEntry getVolume(@NotNull String lineName) {
                return this.volumeByLineName.computeIfAbsent(lineName, c -> new DoubleConfigEntry(1.0, 0.0, 2.0));
            }

            @Override
            public synchronized void setMute(@NotNull String lineName, boolean muted) {
                this.getMute(lineName).set(muted);
            }

            @Override
            public synchronized BooleanConfigEntry getMute(@NotNull String lineName) {
                return this.muteByLineName.computeIfAbsent(lineName, c -> new BooleanConfigEntry(false));
            }

            @Override
            public synchronized void deserialize(Object object) {
                try {
                    Map map2 = (Map)object;
                    map2.forEach((key, serialized) -> {
                        Map value = (Map)serialized;
                        if (value.containsKey("volume")) {
                            this.setVolume((String)key, (Double)value.get("volume"));
                        }
                        if (value.containsKey("muted")) {
                            this.setMute((String)key, (Boolean)value.get("muted"));
                        }
                    });
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }

            @Override
            public synchronized Object serialize() {
                HashMap serialized = Maps.newHashMap();
                this.volumeByLineName.forEach((key, entry) -> {
                    HashMap value = Maps.newHashMap();
                    value.put("volume", entry.value());
                    serialized.put(key, value);
                });
                this.muteByLineName.forEach((key, entry) -> {
                    Map value = serialized.getOrDefault(key, Maps.newHashMap());
                    if (!entry.isDefault()) {
                        value.put("muted", entry.value());
                        serialized.put(key, value);
                    }
                });
                return serialized;
            }

            public Map<String, DoubleConfigEntry> getVolumeByLineName() {
                return this.volumeByLineName;
            }

            public Map<String, BooleanConfigEntry> getMuteByLineName() {
                return this.muteByLineName;
            }

            public void setVolumeByLineName(Map<String, DoubleConfigEntry> volumeByLineName) {
                this.volumeByLineName = volumeByLineName;
            }

            public void setMuteByLineName(Map<String, BooleanConfigEntry> muteByLineName) {
                this.muteByLineName = muteByLineName;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof SourceLineVolumes)) {
                    return false;
                }
                SourceLineVolumes other = (SourceLineVolumes)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Map<String, DoubleConfigEntry> this$volumeByLineName = this.getVolumeByLineName();
                Map<String, DoubleConfigEntry> other$volumeByLineName = other.getVolumeByLineName();
                if (this$volumeByLineName == null ? other$volumeByLineName != null : !((Object)this$volumeByLineName).equals(other$volumeByLineName)) {
                    return false;
                }
                Map<String, BooleanConfigEntry> this$muteByLineName = this.getMuteByLineName();
                Map<String, BooleanConfigEntry> other$muteByLineName = other.getMuteByLineName();
                return !(this$muteByLineName == null ? other$muteByLineName != null : !((Object)this$muteByLineName).equals(other$muteByLineName));
            }

            protected boolean canEqual(Object other) {
                return other instanceof SourceLineVolumes;
            }

            public int hashCode() {
                int PRIME = 59;
                int result2 = 1;
                Map<String, DoubleConfigEntry> $volumeByLineName = this.getVolumeByLineName();
                result2 = result2 * 59 + ($volumeByLineName == null ? 43 : ((Object)$volumeByLineName).hashCode());
                Map<String, BooleanConfigEntry> $muteByLineName = this.getMuteByLineName();
                result2 = result2 * 59 + ($muteByLineName == null ? 43 : ((Object)$muteByLineName).hashCode());
                return result2;
            }

            public String toString() {
                return "VoiceClientConfig.Voice.SourceLineVolumes(volumeByLineName=" + String.valueOf(this.getVolumeByLineName()) + ", muteByLineName=" + String.valueOf(this.getMuteByLineName()) + ")";
            }
        }
    }

    @Config
    public static class Advanced
    implements ClientConfig.Advanced {
        @ConfigField
        private BooleanConfigEntry visualizeVoiceDistance = new BooleanConfigEntry(true);
        @ConfigField
        private BooleanConfigEntry visualizeVoiceDistanceOnJoin = new BooleanConfigEntry(false);
        @ConfigField
        private IntConfigEntry compressorThreshold = new IntConfigEntry(-10, -60, 0);
        @ConfigField
        private IntConfigEntry limiterThreshold = new IntConfigEntry(-6, -60, 0);
        @ConfigField
        private IntConfigEntry directionalSourcesAngle = new IntConfigEntry(145, 100, 360);
        @ConfigField
        private BooleanConfigEntry stereoSourcesToMono = new BooleanConfigEntry(false);
        @ConfigField
        private BooleanConfigEntry panning = new BooleanConfigEntry(true);
        @ConfigField
        private BooleanConfigEntry cameraSoundListener = new BooleanConfigEntry(true);
        @ConfigField
        private BooleanConfigEntry exponentialVolumeSlider = new BooleanConfigEntry(true);
        @ConfigField
        private BooleanConfigEntry exponentialDistanceGain = new BooleanConfigEntry(true);

        @Override
        public BooleanConfigEntry getVisualizeVoiceDistance() {
            return this.visualizeVoiceDistance;
        }

        @Override
        public BooleanConfigEntry getVisualizeVoiceDistanceOnJoin() {
            return this.visualizeVoiceDistanceOnJoin;
        }

        public IntConfigEntry getCompressorThreshold() {
            return this.compressorThreshold;
        }

        public IntConfigEntry getLimiterThreshold() {
            return this.limiterThreshold;
        }

        @Override
        public IntConfigEntry getDirectionalSourcesAngle() {
            return this.directionalSourcesAngle;
        }

        @Override
        public BooleanConfigEntry getStereoSourcesToMono() {
            return this.stereoSourcesToMono;
        }

        @Override
        public BooleanConfigEntry getPanning() {
            return this.panning;
        }

        @Override
        public BooleanConfigEntry getCameraSoundListener() {
            return this.cameraSoundListener;
        }

        @Override
        public BooleanConfigEntry getExponentialVolumeSlider() {
            return this.exponentialVolumeSlider;
        }

        @Override
        public BooleanConfigEntry getExponentialDistanceGain() {
            return this.exponentialDistanceGain;
        }

        public void setVisualizeVoiceDistance(BooleanConfigEntry visualizeVoiceDistance) {
            this.visualizeVoiceDistance = visualizeVoiceDistance;
        }

        public void setVisualizeVoiceDistanceOnJoin(BooleanConfigEntry visualizeVoiceDistanceOnJoin) {
            this.visualizeVoiceDistanceOnJoin = visualizeVoiceDistanceOnJoin;
        }

        public void setCompressorThreshold(IntConfigEntry compressorThreshold) {
            this.compressorThreshold = compressorThreshold;
        }

        public void setLimiterThreshold(IntConfigEntry limiterThreshold) {
            this.limiterThreshold = limiterThreshold;
        }

        public void setDirectionalSourcesAngle(IntConfigEntry directionalSourcesAngle) {
            this.directionalSourcesAngle = directionalSourcesAngle;
        }

        public void setStereoSourcesToMono(BooleanConfigEntry stereoSourcesToMono) {
            this.stereoSourcesToMono = stereoSourcesToMono;
        }

        public void setPanning(BooleanConfigEntry panning) {
            this.panning = panning;
        }

        public void setCameraSoundListener(BooleanConfigEntry cameraSoundListener) {
            this.cameraSoundListener = cameraSoundListener;
        }

        public void setExponentialVolumeSlider(BooleanConfigEntry exponentialVolumeSlider) {
            this.exponentialVolumeSlider = exponentialVolumeSlider;
        }

        public void setExponentialDistanceGain(BooleanConfigEntry exponentialDistanceGain) {
            this.exponentialDistanceGain = exponentialDistanceGain;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Advanced)) {
                return false;
            }
            Advanced other = (Advanced)o;
            if (!other.canEqual(this)) {
                return false;
            }
            BooleanConfigEntry this$visualizeVoiceDistance = this.getVisualizeVoiceDistance();
            BooleanConfigEntry other$visualizeVoiceDistance = other.getVisualizeVoiceDistance();
            if (this$visualizeVoiceDistance == null ? other$visualizeVoiceDistance != null : !this$visualizeVoiceDistance.equals(other$visualizeVoiceDistance)) {
                return false;
            }
            BooleanConfigEntry this$visualizeVoiceDistanceOnJoin = this.getVisualizeVoiceDistanceOnJoin();
            BooleanConfigEntry other$visualizeVoiceDistanceOnJoin = other.getVisualizeVoiceDistanceOnJoin();
            if (this$visualizeVoiceDistanceOnJoin == null ? other$visualizeVoiceDistanceOnJoin != null : !this$visualizeVoiceDistanceOnJoin.equals(other$visualizeVoiceDistanceOnJoin)) {
                return false;
            }
            IntConfigEntry this$compressorThreshold = this.getCompressorThreshold();
            IntConfigEntry other$compressorThreshold = other.getCompressorThreshold();
            if (this$compressorThreshold == null ? other$compressorThreshold != null : !this$compressorThreshold.equals(other$compressorThreshold)) {
                return false;
            }
            IntConfigEntry this$limiterThreshold = this.getLimiterThreshold();
            IntConfigEntry other$limiterThreshold = other.getLimiterThreshold();
            if (this$limiterThreshold == null ? other$limiterThreshold != null : !this$limiterThreshold.equals(other$limiterThreshold)) {
                return false;
            }
            IntConfigEntry this$directionalSourcesAngle = this.getDirectionalSourcesAngle();
            IntConfigEntry other$directionalSourcesAngle = other.getDirectionalSourcesAngle();
            if (this$directionalSourcesAngle == null ? other$directionalSourcesAngle != null : !this$directionalSourcesAngle.equals(other$directionalSourcesAngle)) {
                return false;
            }
            BooleanConfigEntry this$stereoSourcesToMono = this.getStereoSourcesToMono();
            BooleanConfigEntry other$stereoSourcesToMono = other.getStereoSourcesToMono();
            if (this$stereoSourcesToMono == null ? other$stereoSourcesToMono != null : !this$stereoSourcesToMono.equals(other$stereoSourcesToMono)) {
                return false;
            }
            BooleanConfigEntry this$panning = this.getPanning();
            BooleanConfigEntry other$panning = other.getPanning();
            if (this$panning == null ? other$panning != null : !this$panning.equals(other$panning)) {
                return false;
            }
            BooleanConfigEntry this$cameraSoundListener = this.getCameraSoundListener();
            BooleanConfigEntry other$cameraSoundListener = other.getCameraSoundListener();
            if (this$cameraSoundListener == null ? other$cameraSoundListener != null : !this$cameraSoundListener.equals(other$cameraSoundListener)) {
                return false;
            }
            BooleanConfigEntry this$exponentialVolumeSlider = this.getExponentialVolumeSlider();
            BooleanConfigEntry other$exponentialVolumeSlider = other.getExponentialVolumeSlider();
            if (this$exponentialVolumeSlider == null ? other$exponentialVolumeSlider != null : !this$exponentialVolumeSlider.equals(other$exponentialVolumeSlider)) {
                return false;
            }
            BooleanConfigEntry this$exponentialDistanceGain = this.getExponentialDistanceGain();
            BooleanConfigEntry other$exponentialDistanceGain = other.getExponentialDistanceGain();
            return !(this$exponentialDistanceGain == null ? other$exponentialDistanceGain != null : !this$exponentialDistanceGain.equals(other$exponentialDistanceGain));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Advanced;
        }

        public int hashCode() {
            int PRIME = 59;
            int result2 = 1;
            BooleanConfigEntry $visualizeVoiceDistance = this.getVisualizeVoiceDistance();
            result2 = result2 * 59 + ($visualizeVoiceDistance == null ? 43 : $visualizeVoiceDistance.hashCode());
            BooleanConfigEntry $visualizeVoiceDistanceOnJoin = this.getVisualizeVoiceDistanceOnJoin();
            result2 = result2 * 59 + ($visualizeVoiceDistanceOnJoin == null ? 43 : $visualizeVoiceDistanceOnJoin.hashCode());
            IntConfigEntry $compressorThreshold = this.getCompressorThreshold();
            result2 = result2 * 59 + ($compressorThreshold == null ? 43 : $compressorThreshold.hashCode());
            IntConfigEntry $limiterThreshold = this.getLimiterThreshold();
            result2 = result2 * 59 + ($limiterThreshold == null ? 43 : $limiterThreshold.hashCode());
            IntConfigEntry $directionalSourcesAngle = this.getDirectionalSourcesAngle();
            result2 = result2 * 59 + ($directionalSourcesAngle == null ? 43 : $directionalSourcesAngle.hashCode());
            BooleanConfigEntry $stereoSourcesToMono = this.getStereoSourcesToMono();
            result2 = result2 * 59 + ($stereoSourcesToMono == null ? 43 : $stereoSourcesToMono.hashCode());
            BooleanConfigEntry $panning = this.getPanning();
            result2 = result2 * 59 + ($panning == null ? 43 : $panning.hashCode());
            BooleanConfigEntry $cameraSoundListener = this.getCameraSoundListener();
            result2 = result2 * 59 + ($cameraSoundListener == null ? 43 : $cameraSoundListener.hashCode());
            BooleanConfigEntry $exponentialVolumeSlider = this.getExponentialVolumeSlider();
            result2 = result2 * 59 + ($exponentialVolumeSlider == null ? 43 : $exponentialVolumeSlider.hashCode());
            BooleanConfigEntry $exponentialDistanceGain = this.getExponentialDistanceGain();
            result2 = result2 * 59 + ($exponentialDistanceGain == null ? 43 : $exponentialDistanceGain.hashCode());
            return result2;
        }

        public String toString() {
            return "VoiceClientConfig.Advanced(visualizeVoiceDistance=" + String.valueOf(this.getVisualizeVoiceDistance()) + ", visualizeVoiceDistanceOnJoin=" + String.valueOf(this.getVisualizeVoiceDistanceOnJoin()) + ", compressorThreshold=" + String.valueOf(this.getCompressorThreshold()) + ", limiterThreshold=" + String.valueOf(this.getLimiterThreshold()) + ", directionalSourcesAngle=" + String.valueOf(this.getDirectionalSourcesAngle()) + ", stereoSourcesToMono=" + String.valueOf(this.getStereoSourcesToMono()) + ", panning=" + String.valueOf(this.getPanning()) + ", cameraSoundListener=" + String.valueOf(this.getCameraSoundListener()) + ", exponentialVolumeSlider=" + String.valueOf(this.getExponentialVolumeSlider()) + ", exponentialDistanceGain=" + String.valueOf(this.getExponentialDistanceGain()) + ")";
        }
    }

    public static class Activations
    implements SerializableConfigEntry {
        private Map<UUID, ConfigClientActivation> activationById = Maps.newConcurrentMap();

        public void put(UUID activationId, ConfigClientActivation activation) {
            this.activationById.put(activationId, activation);
        }

        public Optional<ConfigClientActivation> getActivation(UUID id) {
            return Optional.ofNullable(this.activationById.get(id));
        }

        public ConfigClientActivation getActivation(UUID id, Activation serverActivation) {
            return this.activationById.computeIfAbsent(id, activationId -> new ConfigClientActivation());
        }

        @Override
        public void deserialize(Object o) {
            Map serialized = (Map)o;
            serialized.forEach((id, serializedActivation) -> {
                ConfigClientActivation activation = new ConfigClientActivation();
                toml.deserialize(activation, serializedActivation);
                this.put(UUID.fromString(id), activation);
            });
        }

        @Override
        public Object serialize() {
            HashMap serialized = Maps.newHashMap();
            for (Map.Entry<UUID, ConfigClientActivation> entry : this.activationById.entrySet()) {
                UUID activationId = entry.getKey();
                ConfigClientActivation activation = entry.getValue();
                if (activation.isDefault()) continue;
                serialized.put(activationId.toString(), toml.serialize(activation));
            }
            return serialized;
        }

        public void setActivationById(Map<UUID, ConfigClientActivation> activationById) {
            this.activationById = activationById;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Activations)) {
                return false;
            }
            Activations other = (Activations)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Map<UUID, ConfigClientActivation> this$activationById = this.getActivationById();
            Map<UUID, ConfigClientActivation> other$activationById = other.getActivationById();
            return !(this$activationById == null ? other$activationById != null : !((Object)this$activationById).equals(other$activationById));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Activations;
        }

        public int hashCode() {
            int PRIME = 59;
            int result2 = 1;
            Map<UUID, ConfigClientActivation> $activationById = this.getActivationById();
            result2 = result2 * 59 + ($activationById == null ? 43 : ((Object)$activationById).hashCode());
            return result2;
        }

        public String toString() {
            return "VoiceClientConfig.Activations(activationById=" + String.valueOf(this.getActivationById()) + ")";
        }

        private Map<UUID, ConfigClientActivation> getActivationById() {
            return this.activationById;
        }
    }

    @Config
    public static class Overlay {
        @ConfigField
        private BooleanConfigEntry showActivationIcon = new BooleanConfigEntry(true);
        @ConfigField
        private EnumConfigEntry<IconPosition> activationIconPosition = new EnumConfigEntry<IconPosition>(IconPosition.class, IconPosition.BOTTOM_CENTER);
        @ConfigField
        private IntConfigEntry showSourceIcons = new IntConfigEntry(0, 0, 2);
        @ConfigField
        private BooleanConfigEntry showStaticSourceIcons = new BooleanConfigEntry(true);
        @ConfigField
        private BooleanConfigEntry overlayEnabled = new BooleanConfigEntry(true);
        @ConfigField
        private EnumConfigEntry<OverlayPosition> overlayPosition = new EnumConfigEntry<OverlayPosition>(OverlayPosition.class, OverlayPosition.TOP_LEFT);
        @ConfigField
        private EnumConfigEntry<OverlayStyle> overlayStyle = new EnumConfigEntry<OverlayStyle>(OverlayStyle.class, OverlayStyle.NAME_SKIN);
        @ConfigField
        private SourceStates sourceStates = new SourceStates();

        public BooleanConfigEntry getShowActivationIcon() {
            return this.showActivationIcon;
        }

        public EnumConfigEntry<IconPosition> getActivationIconPosition() {
            return this.activationIconPosition;
        }

        public IntConfigEntry getShowSourceIcons() {
            return this.showSourceIcons;
        }

        public BooleanConfigEntry getShowStaticSourceIcons() {
            return this.showStaticSourceIcons;
        }

        public BooleanConfigEntry getOverlayEnabled() {
            return this.overlayEnabled;
        }

        public EnumConfigEntry<OverlayPosition> getOverlayPosition() {
            return this.overlayPosition;
        }

        public EnumConfigEntry<OverlayStyle> getOverlayStyle() {
            return this.overlayStyle;
        }

        public SourceStates getSourceStates() {
            return this.sourceStates;
        }

        public void setShowActivationIcon(BooleanConfigEntry showActivationIcon) {
            this.showActivationIcon = showActivationIcon;
        }

        public void setActivationIconPosition(EnumConfigEntry<IconPosition> activationIconPosition) {
            this.activationIconPosition = activationIconPosition;
        }

        public void setShowSourceIcons(IntConfigEntry showSourceIcons) {
            this.showSourceIcons = showSourceIcons;
        }

        public void setShowStaticSourceIcons(BooleanConfigEntry showStaticSourceIcons) {
            this.showStaticSourceIcons = showStaticSourceIcons;
        }

        public void setOverlayEnabled(BooleanConfigEntry overlayEnabled) {
            this.overlayEnabled = overlayEnabled;
        }

        public void setOverlayPosition(EnumConfigEntry<OverlayPosition> overlayPosition) {
            this.overlayPosition = overlayPosition;
        }

        public void setOverlayStyle(EnumConfigEntry<OverlayStyle> overlayStyle) {
            this.overlayStyle = overlayStyle;
        }

        public void setSourceStates(SourceStates sourceStates) {
            this.sourceStates = sourceStates;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Overlay)) {
                return false;
            }
            Overlay other = (Overlay)o;
            if (!other.canEqual(this)) {
                return false;
            }
            BooleanConfigEntry this$showActivationIcon = this.getShowActivationIcon();
            BooleanConfigEntry other$showActivationIcon = other.getShowActivationIcon();
            if (this$showActivationIcon == null ? other$showActivationIcon != null : !this$showActivationIcon.equals(other$showActivationIcon)) {
                return false;
            }
            EnumConfigEntry<IconPosition> this$activationIconPosition = this.getActivationIconPosition();
            EnumConfigEntry<IconPosition> other$activationIconPosition = other.getActivationIconPosition();
            if (this$activationIconPosition == null ? other$activationIconPosition != null : !this$activationIconPosition.equals(other$activationIconPosition)) {
                return false;
            }
            IntConfigEntry this$showSourceIcons = this.getShowSourceIcons();
            IntConfigEntry other$showSourceIcons = other.getShowSourceIcons();
            if (this$showSourceIcons == null ? other$showSourceIcons != null : !this$showSourceIcons.equals(other$showSourceIcons)) {
                return false;
            }
            BooleanConfigEntry this$showStaticSourceIcons = this.getShowStaticSourceIcons();
            BooleanConfigEntry other$showStaticSourceIcons = other.getShowStaticSourceIcons();
            if (this$showStaticSourceIcons == null ? other$showStaticSourceIcons != null : !this$showStaticSourceIcons.equals(other$showStaticSourceIcons)) {
                return false;
            }
            BooleanConfigEntry this$overlayEnabled = this.getOverlayEnabled();
            BooleanConfigEntry other$overlayEnabled = other.getOverlayEnabled();
            if (this$overlayEnabled == null ? other$overlayEnabled != null : !this$overlayEnabled.equals(other$overlayEnabled)) {
                return false;
            }
            EnumConfigEntry<OverlayPosition> this$overlayPosition = this.getOverlayPosition();
            EnumConfigEntry<OverlayPosition> other$overlayPosition = other.getOverlayPosition();
            if (this$overlayPosition == null ? other$overlayPosition != null : !this$overlayPosition.equals(other$overlayPosition)) {
                return false;
            }
            EnumConfigEntry<OverlayStyle> this$overlayStyle = this.getOverlayStyle();
            EnumConfigEntry<OverlayStyle> other$overlayStyle = other.getOverlayStyle();
            if (this$overlayStyle == null ? other$overlayStyle != null : !this$overlayStyle.equals(other$overlayStyle)) {
                return false;
            }
            SourceStates this$sourceStates = this.getSourceStates();
            SourceStates other$sourceStates = other.getSourceStates();
            return !(this$sourceStates == null ? other$sourceStates != null : !((Object)this$sourceStates).equals(other$sourceStates));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Overlay;
        }

        public int hashCode() {
            int PRIME = 59;
            int result2 = 1;
            BooleanConfigEntry $showActivationIcon = this.getShowActivationIcon();
            result2 = result2 * 59 + ($showActivationIcon == null ? 43 : $showActivationIcon.hashCode());
            EnumConfigEntry<IconPosition> $activationIconPosition = this.getActivationIconPosition();
            result2 = result2 * 59 + ($activationIconPosition == null ? 43 : $activationIconPosition.hashCode());
            IntConfigEntry $showSourceIcons = this.getShowSourceIcons();
            result2 = result2 * 59 + ($showSourceIcons == null ? 43 : $showSourceIcons.hashCode());
            BooleanConfigEntry $showStaticSourceIcons = this.getShowStaticSourceIcons();
            result2 = result2 * 59 + ($showStaticSourceIcons == null ? 43 : $showStaticSourceIcons.hashCode());
            BooleanConfigEntry $overlayEnabled = this.getOverlayEnabled();
            result2 = result2 * 59 + ($overlayEnabled == null ? 43 : $overlayEnabled.hashCode());
            EnumConfigEntry<OverlayPosition> $overlayPosition = this.getOverlayPosition();
            result2 = result2 * 59 + ($overlayPosition == null ? 43 : $overlayPosition.hashCode());
            EnumConfigEntry<OverlayStyle> $overlayStyle = this.getOverlayStyle();
            result2 = result2 * 59 + ($overlayStyle == null ? 43 : $overlayStyle.hashCode());
            SourceStates $sourceStates = this.getSourceStates();
            result2 = result2 * 59 + ($sourceStates == null ? 43 : ((Object)$sourceStates).hashCode());
            return result2;
        }

        public String toString() {
            return "VoiceClientConfig.Overlay(showActivationIcon=" + String.valueOf(this.getShowActivationIcon()) + ", activationIconPosition=" + String.valueOf(this.getActivationIconPosition()) + ", showSourceIcons=" + String.valueOf(this.getShowSourceIcons()) + ", showStaticSourceIcons=" + String.valueOf(this.getShowStaticSourceIcons()) + ", overlayEnabled=" + String.valueOf(this.getOverlayEnabled()) + ", overlayPosition=" + String.valueOf(this.getOverlayPosition()) + ", overlayStyle=" + String.valueOf(this.getOverlayStyle()) + ", sourceStates=" + String.valueOf(this.getSourceStates()) + ")";
        }

        public static class SourceStates
        implements SerializableConfigEntry,
        ClientConfig.Overlay.SourceStates {
            private Map<String, EnumConfigEntry<OverlaySourceState>> stateByLineName = Maps.newHashMap();

            @Override
            public synchronized void setState(@NotNull String lineName, @NotNull OverlaySourceState state) {
                this.getState(lineName).set(state);
            }

            @Override
            public synchronized EnumConfigEntry<OverlaySourceState> getState(@NotNull String lineName) {
                return this.stateByLineName.computeIfAbsent(lineName, c -> new EnumConfigEntry<OverlaySourceState>(OverlaySourceState.class, OverlaySourceState.OFF));
            }

            public synchronized EnumConfigEntry<OverlaySourceState> getState(@NotNull SourceLine sourceLine) {
                return this.stateByLineName.computeIfAbsent(sourceLine.getName(), c -> new EnumConfigEntry<OverlaySourceState>(OverlaySourceState.class, sourceLine.hasPlayers() ? OverlaySourceState.WHEN_TALKING : OverlaySourceState.OFF));
            }

            @Override
            public synchronized void deserialize(Object object) {
                try {
                    Map map2 = (Map)object;
                    map2.forEach((key, value) -> this.setState((String)key, OverlaySourceState.valueOf((String)value)));
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }

            @Override
            public synchronized Object serialize() {
                HashMap serialized = Maps.newHashMap();
                this.stateByLineName.forEach((key, entry) -> serialized.put(key, ((OverlaySourceState)((Object)((Object)entry.value()))).name()));
                return serialized;
            }

            public Map<String, EnumConfigEntry<OverlaySourceState>> getStateByLineName() {
                return this.stateByLineName;
            }

            public void setStateByLineName(Map<String, EnumConfigEntry<OverlaySourceState>> stateByLineName) {
                this.stateByLineName = stateByLineName;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof SourceStates)) {
                    return false;
                }
                SourceStates other = (SourceStates)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Map<String, EnumConfigEntry<OverlaySourceState>> this$stateByLineName = this.getStateByLineName();
                Map<String, EnumConfigEntry<OverlaySourceState>> other$stateByLineName = other.getStateByLineName();
                return !(this$stateByLineName == null ? other$stateByLineName != null : !((Object)this$stateByLineName).equals(other$stateByLineName));
            }

            protected boolean canEqual(Object other) {
                return other instanceof SourceStates;
            }

            public int hashCode() {
                int PRIME = 59;
                int result2 = 1;
                Map<String, EnumConfigEntry<OverlaySourceState>> $stateByLineName = this.getStateByLineName();
                result2 = result2 * 59 + ($stateByLineName == null ? 43 : ((Object)$stateByLineName).hashCode());
                return result2;
            }

            public String toString() {
                return "VoiceClientConfig.Overlay.SourceStates(stateByLineName=" + String.valueOf(this.getStateByLineName()) + ")";
            }
        }
    }

    public static class Servers
    implements SerializableConfigEntry {
        private final Map<UUID, Server> serverById = Maps.newConcurrentMap();

        public void put(@NotNull UUID serverId, Server server) {
            this.serverById.put(serverId, server);
        }

        public Optional<Server> getById(@NotNull UUID serverId) {
            return Optional.ofNullable(this.serverById.get(serverId));
        }

        @Override
        public void deserialize(Object object) {
            Map serialized = (Map)object;
            for (Map.Entry entry : serialized.entrySet()) {
                Server server = new Server();
                toml.deserialize(server, entry.getValue());
                this.put(UUID.fromString((String)entry.getKey()), server);
            }
        }

        @Override
        public Object serialize() {
            HashMap serialized = Maps.newHashMap();
            this.serverById.forEach((serverId, server) -> serialized.put(serverId.toString(), toml.serialize(server)));
            return serialized;
        }

        public Map<UUID, Server> getServerById() {
            return this.serverById;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Servers)) {
                return false;
            }
            Servers other = (Servers)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Map<UUID, Server> this$serverById = this.getServerById();
            Map<UUID, Server> other$serverById = other.getServerById();
            return !(this$serverById == null ? other$serverById != null : !((Object)this$serverById).equals(other$serverById));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Servers;
        }

        public int hashCode() {
            int PRIME = 59;
            int result2 = 1;
            Map<UUID, Server> $serverById = this.getServerById();
            result2 = result2 * 59 + ($serverById == null ? 43 : ((Object)$serverById).hashCode());
            return result2;
        }

        public String toString() {
            return "VoiceClientConfig.Servers(serverById=" + String.valueOf(this.getServerById()) + ")";
        }
    }

    public static class Addons
    implements SerializableConfigEntry {
        private final Map<String, Addon> addons = Maps.newHashMap();

        @NotNull
        public synchronized Addon getAddon(@NotNull String addonId) {
            return this.addons.computeIfAbsent(addonId, aId -> new Addon());
        }

        @Override
        public synchronized void deserialize(Object object) {
            Map map2 = (Map)object;
            map2.forEach((key, value) -> {
                Addon addon = new Addon();
                addon.deserialize(value);
                this.addons.put((String)key, addon);
            });
        }

        @Override
        public synchronized Object serialize() {
            HashMap serialized = Maps.newHashMap();
            this.addons.forEach((key, value) -> {
                if (value.entries.size() > 0) {
                    serialized.put(key, value.serialize());
                }
            });
            return serialized;
        }

        public Map<String, Addon> getAddons() {
            return this.addons;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Addons)) {
                return false;
            }
            Addons other = (Addons)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Map<String, Addon> this$addons = this.getAddons();
            Map<String, Addon> other$addons = other.getAddons();
            return !(this$addons == null ? other$addons != null : !((Object)this$addons).equals(other$addons));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Addons;
        }

        public int hashCode() {
            int PRIME = 59;
            int result2 = 1;
            Map<String, Addon> $addons = this.getAddons();
            result2 = result2 * 59 + ($addons == null ? 43 : ((Object)$addons).hashCode());
            return result2;
        }

        public String toString() {
            return "VoiceClientConfig.Addons(addons=" + String.valueOf(this.getAddons()) + ")";
        }

        public static class Addon
        implements SerializableConfigEntry {
            private final Map<String, ConfigEntry<?>> entries = Maps.newHashMap();

            public synchronized void setEntry(@NotNull String key, @NotNull ConfigEntry<?> entry) {
                this.entries.put(key, entry);
            }

            public synchronized Optional<ConfigEntry<?>> getEntry(@NotNull String key) {
                return Optional.ofNullable(this.entries.get(key));
            }

            @Override
            public synchronized void deserialize(Object object) {
                Map map2 = (Map)object;
                map2.forEach((key, value) -> {
                    key = key.replaceAll("(^\")|(\"$)", "");
                    if (value instanceof Boolean) {
                        this.entries.put((String)key, new BooleanConfigEntry((Boolean)value));
                    } else if (value instanceof Long) {
                        this.entries.put((String)key, new IntConfigEntry(((Long)value).intValue(), 0, 0));
                    } else if (value instanceof Double) {
                        this.entries.put((String)key, new DoubleConfigEntry((Double)value, 0.0, 0.0));
                    } else if (value instanceof String) {
                        this.entries.put((String)key, new ConfigEntry<Object>(value));
                    }
                });
            }

            @Override
            public synchronized Object serialize() {
                HashMap serialized = Maps.newHashMap();
                this.entries.forEach((key, entry) -> serialized.put(key, entry.value()));
                return serialized;
            }

            public Map<String, ConfigEntry<?>> getEntries() {
                return this.entries;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Addon)) {
                    return false;
                }
                Addon other = (Addon)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Map<String, ConfigEntry<?>> this$entries = this.getEntries();
                Map<String, ConfigEntry<?>> other$entries = other.getEntries();
                return !(this$entries == null ? other$entries != null : !((Object)this$entries).equals(other$entries));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Addon;
            }

            public int hashCode() {
                int PRIME = 59;
                int result2 = 1;
                Map<String, ConfigEntry<?>> $entries = this.getEntries();
                result2 = result2 * 59 + ($entries == null ? 43 : ((Object)$entries).hashCode());
                return result2;
            }

            public String toString() {
                return "VoiceClientConfig.Addons.Addon(entries=" + String.valueOf(this.getEntries()) + ")";
            }
        }
    }

    public static class Server
    implements SerializableConfigEntry {
        private Map<UUID, IntConfigEntry> activationDistances = Maps.newConcurrentMap();

        public void put(UUID activationId, IntConfigEntry distance) {
            this.activationDistances.put(activationId, distance);
        }

        public Optional<IntConfigEntry> getActivationDistance(UUID id) {
            return Optional.ofNullable(this.activationDistances.get(id));
        }

        public IntConfigEntry getActivationDistance(UUID id, Activation serverActivation) {
            return this.activationDistances.computeIfAbsent(id, activationId -> this.createActivationDistance(serverActivation));
        }

        @Override
        public void deserialize(Object o) {
            Map serialized = (Map)o;
            if (serialized.containsKey("distances")) {
                Map distances = (Map)serialized.get("distances");
                distances.forEach((activationId, distance) -> {
                    IntConfigEntry entry = new IntConfigEntry(0, 0, Short.MAX_VALUE);
                    entry.set(((Long)distance).intValue());
                    this.put(UUID.fromString(activationId), entry);
                });
            }
        }

        @Override
        public Object serialize() {
            HashMap serialized = Maps.newHashMap();
            HashMap distances = Maps.newHashMap();
            this.activationDistances.forEach((activationId, entry) -> {
                if (entry.isDefault()) {
                    return;
                }
                distances.put(activationId.toString(), entry.value());
            });
            if (distances.size() > 0) {
                serialized.put("distances", distances);
            }
            return serialized;
        }

        private IntConfigEntry createActivationDistance(Activation serverActivation) {
            return new IntConfigEntry(serverActivation.getDefaultDistance(), serverActivation.getMinDistance(), serverActivation.getMaxDistance());
        }

        public Map<UUID, IntConfigEntry> getActivationDistances() {
            return this.activationDistances;
        }

        public void setActivationDistances(Map<UUID, IntConfigEntry> activationDistances) {
            this.activationDistances = activationDistances;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Server)) {
                return false;
            }
            Server other = (Server)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Map<UUID, IntConfigEntry> this$activationDistances = this.getActivationDistances();
            Map<UUID, IntConfigEntry> other$activationDistances = other.getActivationDistances();
            return !(this$activationDistances == null ? other$activationDistances != null : !((Object)this$activationDistances).equals(other$activationDistances));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Server;
        }

        public int hashCode() {
            int PRIME = 59;
            int result2 = 1;
            Map<UUID, IntConfigEntry> $activationDistances = this.getActivationDistances();
            result2 = result2 * 59 + ($activationDistances == null ? 43 : ((Object)$activationDistances).hashCode());
            return result2;
        }

        public String toString() {
            return "VoiceClientConfig.Server(activationDistances=" + String.valueOf(this.getActivationDistances()) + ")";
        }
    }
}

