/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.connection;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.sound.sampled.AudioFormat;
import lombok.NonNull;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.voice.api.audio.codec.AudioEncoder;
import su.plo.voice.api.client.PlasmoVoiceClient;
import su.plo.voice.api.client.connection.ServerInfo;
import su.plo.voice.api.encryption.Encryption;
import su.plo.voice.proto.data.audio.capture.Activation;
import su.plo.voice.proto.data.audio.capture.CaptureInfo;
import su.plo.voice.proto.data.audio.codec.CodecInfo;
import su.plo.voice.proto.data.audio.codec.opus.OpusDecoderInfo;
import su.plo.voice.proto.data.audio.line.SourceLine;
import su.plo.voice.proto.packets.tcp.clientbound.ConfigPacket;

public final class VoiceServerInfo
implements ServerInfo {
    private final PlasmoVoiceClient voiceClient;
    private final UUID serverId;
    private final UUID secret;
    @NotNull
    private InetSocketAddress remoteAddress;
    @NotNull
    private ServerInfo.VoiceInfo voiceInfo;
    @NotNull
    private ServerInfo.PlayerInfo playerInfo;
    @Nullable
    private Encryption encryption;

    public VoiceServerInfo(@NonNull PlasmoVoiceClient voiceClient, @NonNull UUID serverId, @NonNull UUID secret, @NonNull InetSocketAddress remoteAddress, @Nullable Encryption encryption, @NonNull ConfigPacket config) {
        if (voiceClient == null) {
            throw new NullPointerException("voiceClient is marked non-null but is null");
        }
        if (serverId == null) {
            throw new NullPointerException("serverId is marked non-null but is null");
        }
        if (secret == null) {
            throw new NullPointerException("secret is marked non-null but is null");
        }
        if (remoteAddress == null) {
            throw new NullPointerException("remoteAddress is marked non-null but is null");
        }
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        this.voiceClient = voiceClient;
        this.serverId = serverId;
        this.secret = secret;
        this.encryption = encryption;
        this.remoteAddress = remoteAddress;
        this.voiceInfo = new VoiceServerVoiceInfo(config.getCaptureInfo(), new ArrayList<SourceLine>(config.getSourceLines()), new ArrayList<Activation>(config.getActivations()));
        this.playerInfo = new VoiceServerPlayerInfo(config.getPermissions());
    }

    @Override
    public Optional<Encryption> getEncryption() {
        return Optional.ofNullable(this.encryption);
    }

    @Override
    @NotNull
    public AudioEncoder createOpusEncoder(boolean stereo) {
        CodecInfo codecInfo = this.voiceInfo.getCaptureInfo().getEncoderInfo();
        if (codecInfo == null) {
            throw new IllegalStateException("server codec info is empty");
        }
        int sampleRate = this.voiceInfo.getCaptureInfo().getSampleRate();
        return this.voiceClient.getCodecManager().createEncoder(codecInfo, sampleRate, stereo, sampleRate / 1000 * 20, this.voiceInfo.getCaptureInfo().getMtuSize());
    }

    @Override
    @NotNull
    public AudioEncoder createOpusDecoder(boolean stereo) {
        if (this.voiceInfo.getCaptureInfo().getEncoderInfo() == null) {
            throw new IllegalStateException("server codec info is empty");
        }
        int sampleRate = this.voiceInfo.getCaptureInfo().getSampleRate();
        return (AudioEncoder)this.voiceClient.getCodecManager().createDecoder(new OpusDecoderInfo(), sampleRate, stereo, sampleRate / 1000 * 20, this.voiceInfo.getCaptureInfo().getMtuSize());
    }

    public String toString() {
        return "VoiceServerInfo(voiceClient=" + String.valueOf(this.voiceClient) + ", serverId=" + String.valueOf(this.getServerId()) + ", secret=" + String.valueOf(this.getSecret()) + ", remoteAddress=" + String.valueOf(this.getRemoteAddress()) + ", voiceInfo=" + String.valueOf(this.getVoiceInfo()) + ", playerInfo=" + String.valueOf(this.getPlayerInfo()) + ", encryption=" + String.valueOf(this.getEncryption()) + ")";
    }

    @Override
    public UUID getServerId() {
        return this.serverId;
    }

    @Override
    public UUID getSecret() {
        return this.secret;
    }

    @Override
    @NotNull
    public InetSocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public void setRemoteAddress(@NotNull InetSocketAddress remoteAddress) {
        if (remoteAddress == null) {
            throw new NullPointerException("remoteAddress is marked non-null but is null");
        }
        this.remoteAddress = remoteAddress;
    }

    @Override
    @NotNull
    public ServerInfo.VoiceInfo getVoiceInfo() {
        return this.voiceInfo;
    }

    public void setVoiceInfo(@NotNull ServerInfo.VoiceInfo voiceInfo) {
        if (voiceInfo == null) {
            throw new NullPointerException("voiceInfo is marked non-null but is null");
        }
        this.voiceInfo = voiceInfo;
    }

    @Override
    @NotNull
    public ServerInfo.PlayerInfo getPlayerInfo() {
        return this.playerInfo;
    }

    public void setPlayerInfo(@NotNull ServerInfo.PlayerInfo playerInfo) {
        if (playerInfo == null) {
            throw new NullPointerException("playerInfo is marked non-null but is null");
        }
        this.playerInfo = playerInfo;
    }

    public void setEncryption(@Nullable Encryption encryption) {
        this.encryption = encryption;
    }

    static final class VoiceServerVoiceInfo
    implements ServerInfo.VoiceInfo {
        private CaptureInfo captureInfo;
        private List<SourceLine> sourceLines;
        private List<Activation> activations;

        @Override
        @NotNull
        public AudioFormat getFormat(boolean stereo) {
            return new AudioFormat(this.captureInfo.getSampleRate(), 16, stereo ? 2 : 1, true, false);
        }

        @Override
        public int getBufferSize() {
            return this.captureInfo.getSampleRate() / 1000 * 20;
        }

        public VoiceServerVoiceInfo(CaptureInfo captureInfo, List<SourceLine> sourceLines, List<Activation> activations) {
            this.captureInfo = captureInfo;
            this.sourceLines = sourceLines;
            this.activations = activations;
        }

        public String toString() {
            return "VoiceServerInfo.VoiceServerVoiceInfo(captureInfo=" + String.valueOf(this.getCaptureInfo()) + ", sourceLines=" + String.valueOf(this.getSourceLines()) + ", activations=" + String.valueOf(this.getActivations()) + ")";
        }

        @Override
        public CaptureInfo getCaptureInfo() {
            return this.captureInfo;
        }

        public List<SourceLine> getSourceLines() {
            return this.sourceLines;
        }

        public List<Activation> getActivations() {
            return this.activations;
        }

        public void setCaptureInfo(CaptureInfo captureInfo) {
            this.captureInfo = captureInfo;
        }

        public void setSourceLines(List<SourceLine> sourceLines) {
            this.sourceLines = sourceLines;
        }

        public void setActivations(List<Activation> activations) {
            this.activations = activations;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VoiceServerVoiceInfo)) {
                return false;
            }
            VoiceServerVoiceInfo other = (VoiceServerVoiceInfo)o;
            CaptureInfo this$captureInfo = this.getCaptureInfo();
            CaptureInfo other$captureInfo = other.getCaptureInfo();
            if (this$captureInfo == null ? other$captureInfo != null : !this$captureInfo.equals(other$captureInfo)) {
                return false;
            }
            Collection this$sourceLines = this.getSourceLines();
            Collection other$sourceLines = other.getSourceLines();
            if (this$sourceLines == null ? other$sourceLines != null : !((Object)this$sourceLines).equals(other$sourceLines)) {
                return false;
            }
            Collection this$activations = this.getActivations();
            Collection other$activations = other.getActivations();
            return !(this$activations == null ? other$activations != null : !((Object)this$activations).equals(other$activations));
        }

        public int hashCode() {
            int PRIME = 59;
            int result2 = 1;
            CaptureInfo $captureInfo = this.getCaptureInfo();
            result2 = result2 * 59 + ($captureInfo == null ? 43 : $captureInfo.hashCode());
            Collection $sourceLines = this.getSourceLines();
            result2 = result2 * 59 + ($sourceLines == null ? 43 : ((Object)$sourceLines).hashCode());
            Collection $activations = this.getActivations();
            result2 = result2 * 59 + ($activations == null ? 43 : ((Object)$activations).hashCode());
            return result2;
        }
    }

    static final class VoiceServerPlayerInfo
    implements ServerInfo.PlayerInfo {
        private final Map<String, Boolean> permissions = Maps.newConcurrentMap();

        public VoiceServerPlayerInfo(@NotNull Map<String, Boolean> permissions) {
            this.permissions.putAll((Map)Preconditions.checkNotNull(permissions, (Object)"permissions"));
        }

        @Override
        public Optional<Boolean> get(@NotNull String key) {
            return Optional.ofNullable(this.permissions.get(Preconditions.checkNotNull((Object)key)));
        }

        public void update(@NotNull Map<String, Boolean> permissions) {
            this.permissions.putAll(permissions);
        }

        public String toString() {
            return "VoiceServerInfo.VoiceServerPlayerInfo(permissions=" + String.valueOf(this.permissions) + ")";
        }
    }
}

