/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.gui.settings.widget;

import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import su.plo.config.entry.IntConfigEntry;
import su.plo.lib.api.MathLib;
import su.plo.lib.api.chat.MinecraftTextComponent;
import su.plo.lib.mod.client.gui.components.AbstractSlider;
import su.plo.voice.api.client.audio.capture.ClientActivation;
import su.plo.voice.client.gui.settings.widget.UpdatableWidget;

public final class DistanceSliderWidget
extends AbstractSlider
implements UpdatableWidget {
    private final ClientActivation activation;
    private final IntConfigEntry entry;

    public DistanceSliderWidget(@NotNull ClientActivation activation, @NotNull IntConfigEntry entry, int x, int y, int width, int height) {
        super(x, y, width, height);
        this.activation = activation;
        this.entry = entry;
        this.updateValue();
    }

    @Override
    protected void updateText() {
        this.text = MinecraftTextComponent.literal(String.valueOf(this.calculateValue(this.value)));
    }

    @Override
    protected void applyValue() {
        this.entry.set(this.calculateValue(this.value));
        this.updateValue();
    }

    @Override
    public void updateValue() {
        this.value = (float)this.activation.getDistances().indexOf(this.entry.value()) / (float)(this.activation.getDistances().size() - 1);
        this.updateText();
    }

    private int calculateValue(double ratio) {
        double value = this.adjust(MathLib.lerp(MathLib.clamp(ratio, 0.0, 1.0), (double)this.activation.getMinDistance(), (double)this.activation.getMaxDistance()));
        return this.activation.getDistances().stream().min(Comparator.comparingInt(i -> Math.abs(i - (int)value))).orElseGet(this.activation::getMinDistance);
    }

    private double adjust(double value) {
        return MathLib.clamp(value, (double)this.activation.getMinDistance(), (double)this.activation.getMaxDistance());
    }
}

