/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.gui.settings.widget;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.config.entry.ConfigEntry;
import su.plo.lib.api.chat.MinecraftTextComponent;
import su.plo.lib.mod.client.gui.widget.GuiAbstractWidget;
import su.plo.lib.mod.client.gui.widget.GuiWidgetTexture;
import su.plo.lib.mod.client.render.RenderUtil;
import su.plo.voice.universal.UGraphics;
import su.plo.voice.universal.UMatrixStack;

public final class ToggleButton
extends GuiAbstractWidget {
    private static final MinecraftTextComponent ON = MinecraftTextComponent.translatable("message.plasmovoice.on", new Object[0]);
    private static final MinecraftTextComponent OFF = MinecraftTextComponent.translatable("message.plasmovoice.off", new Object[0]);
    @Nullable
    private final PressAction action;
    private final ConfigEntry<Boolean> entry;

    public ToggleButton(@NotNull ConfigEntry<Boolean> entry, int x, int y, int width, int height) {
        this(entry, x, y, width, height, null);
    }

    public ToggleButton(@NotNull ConfigEntry<Boolean> entry, int x, int y, int width, int height, @Nullable PressAction action) {
        super(x, y, width, height);
        this.entry = entry;
        this.action = action;
        this.active = !entry.isDisabled();
    }

    @Override
    public MinecraftTextComponent getText() {
        return this.entry.value() != false ? ON : OFF;
    }

    @Override
    public void onClick(double mouseX, double mouseY) {
        this.invertToggle();
    }

    @Override
    @NotNull
    protected GuiWidgetTexture getButtonTexture(boolean hovered) {
        return GuiWidgetTexture.BUTTON_DISABLED;
    }

    @Override
    protected void renderBackground(@NotNull UMatrixStack stack, int mouseX, int mouseY) {
        GuiWidgetTexture sprite = this.isHoveredOrFocused() && this.active ? GuiWidgetTexture.BUTTON_ACTIVE : GuiWidgetTexture.BUTTON_DEFAULT;
        UGraphics.bindTexture(0, sprite.getLocation());
        if (this.entry.value().booleanValue()) {
            int x0 = this.x + (int)((double)(this.width - 8));
            RenderUtil.blitSprite(stack, sprite, x0, this.y, 0, 0, 4, 20);
            RenderUtil.blitSprite(stack, sprite, x0 + 4, this.y, sprite.getSpriteWidth() - 4, 0, 4, 20);
        } else {
            RenderUtil.blitSprite(stack, sprite, this.x, this.y, 0, 0, 4, 20);
            RenderUtil.blitSprite(stack, sprite, this.x + 4, this.y, sprite.getSpriteWidth() - 4, 0, 4, 20);
        }
    }

    public void invertToggle() {
        this.entry.set(this.entry.value() == false);
        if (this.action != null) {
            this.action.onToggle(this.entry.value());
        }
    }

    public static interface PressAction {
        public void onToggle(boolean var1);
    }
}

