/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.event;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.jetbrains.annotations.NotNull;
import su.plo.voice.BaseVoice;
import su.plo.voice.api.PlasmoVoice;
import su.plo.voice.api.event.Event;
import su.plo.voice.api.event.EventBus;
import su.plo.voice.api.event.EventCancellable;
import su.plo.voice.api.event.EventHandler;
import su.plo.voice.api.event.EventPriority;
import su.plo.voice.api.event.EventSubscribe;

public final class VoiceEventBus
implements EventBus {
    private final Map<Object, List<EventHandler<?>>> registeredListeners = Maps.newConcurrentMap();
    private final Map<Object, List<Object>> registeredAddonListeners = Maps.newConcurrentMap();
    private final Map<Object, List<EventHandler<?>>> registeredAddonHandlers = Maps.newConcurrentMap();
    private final Map<Class<?>, EnumMap<EventPriority, List<EventHandler<?>>>> handlers = Maps.newConcurrentMap();
    private final Executor asyncExecutor = Executors.newSingleThreadExecutor();
    private final PlasmoVoice voice;

    public VoiceEventBus(@NotNull PlasmoVoice voice) {
        this.voice = voice;
    }

    @Override
    public <E extends Event> boolean call(@NotNull E event) {
        if (!this.handlers.containsKey(event.getClass())) {
            return true;
        }
        for (Map.Entry<EventPriority, List<EventHandler<?>>> entry : this.handlers.get(event.getClass()).entrySet()) {
            List<EventHandler<?>> listeners = entry.getValue();
            for (EventHandler<?> listener : listeners) {
                listener.execute(event);
            }
        }
        if (event instanceof EventCancellable) {
            return !((EventCancellable)((Object)event)).isCancelled();
        }
        return true;
    }

    @Override
    public <E extends Event> CompletableFuture<E> callAsync(@NotNull E event) {
        CompletableFuture future = new CompletableFuture();
        this.asyncExecutor.execute(() -> {
            this.call(event);
            future.complete(event);
        });
        return future;
    }

    @Override
    public void register(@NotNull Object addon, @NotNull Object listener) {
        this.checkIfAddon(addon);
        Method[] publicMethods = listener.getClass().getMethods();
        Method[] privateMethods = listener.getClass().getDeclaredMethods();
        HashSet methods = new HashSet(publicMethods.length + privateMethods.length);
        Collections.addAll(methods, publicMethods);
        Collections.addAll(methods, privateMethods);
        for (Method method : methods) {
            Class<?>[] params;
            EventSubscribe entry = method.getAnnotation(EventSubscribe.class);
            if (entry == null || method.isBridge() || method.isSynthetic() || (params = method.getParameterTypes()).length < 1) continue;
            Class<?> clazz = params[0];
            if (params.length != 1 || !Event.class.isAssignableFrom(clazz)) continue;
            Class<Event> eventClass = clazz.asSubclass(Event.class);
            method.setAccessible(true);
            EventHandler<Event> handler = event -> {
                if (entry.ignoreCancelled() && event instanceof EventCancellable && ((EventCancellable)((Object)event)).isCancelled()) {
                    return;
                }
                try {
                    method.invoke(listener, event);
                }
                catch (Throwable e) {
                    BaseVoice.LOGGER.warn("Failed to fire an event:");
                    e.printStackTrace();
                }
            };
            EnumMap<EventPriority, List<EventHandler<Object>>> listeners = this.handlers.get(eventClass);
            if (listeners == null) {
                listeners = new EnumMap(EventPriority.class);
                this.handlers.put(eventClass, listeners);
            }
            listeners.compute(entry.priority(), (p, eventHandlers) -> {
                if (eventHandlers == null) {
                    eventHandlers = new CopyOnWriteArrayList<EventHandler>();
                }
                eventHandlers.add(handler);
                return eventHandlers;
            });
            this.registeredListeners.compute(listener, (l, listenerHandlers) -> {
                if (listenerHandlers == null) {
                    listenerHandlers = new CopyOnWriteArrayList<EventHandler>();
                }
                listenerHandlers.add(handler);
                return listenerHandlers;
            });
        }
        if (this.registeredListeners.containsKey(listener)) {
            this.registeredAddonListeners.compute(addon, (a, addonListeners) -> {
                if (addonListeners == null) {
                    addonListeners = new CopyOnWriteArrayList<Object>();
                }
                addonListeners.add(listener);
                return addonListeners;
            });
        }
    }

    @Override
    public <E extends Event> void register(@NotNull Object addon, Class<E> eventClass, EventPriority priority, @NotNull EventHandler<E> handler) {
        this.checkIfAddon(addon);
        EnumMap<EventPriority, List<EventHandler<Object>>> listeners = this.handlers.get(eventClass);
        if (listeners == null) {
            listeners = new EnumMap(EventPriority.class);
            this.handlers.put(eventClass, listeners);
        }
        listeners.compute(priority, (p, eventHandlers) -> {
            if (eventHandlers == null) {
                eventHandlers = new CopyOnWriteArrayList<EventHandler>();
            }
            eventHandlers.add(handler);
            return eventHandlers;
        });
        this.registeredAddonHandlers.compute(addon, (a, addonHandlers) -> {
            if (addonHandlers == null) {
                addonHandlers = new CopyOnWriteArrayList<EventHandler>();
            }
            addonHandlers.add(handler);
            return addonHandlers;
        });
    }

    @Override
    public void unregister(@NotNull Object addon) {
        List<EventHandler<?>> addonHandlers;
        this.checkIfAddon(addon);
        ArrayList handlersToRemove = new ArrayList();
        List<Object> addonListeners = this.registeredAddonListeners.remove(addon);
        if (addonListeners != null) {
            for (Object listener : addonListeners) {
                List<EventHandler<?>> handlers = this.registeredListeners.remove(listener);
                if (handlers == null) continue;
                handlersToRemove.addAll(handlers);
            }
        }
        if ((addonHandlers = this.registeredAddonHandlers.remove(addon)) != null) {
            handlersToRemove.addAll(addonHandlers);
        }
        if (handlersToRemove.size() > 0) {
            this.removeHandlers(handlersToRemove);
        }
    }

    @Override
    public void unregister(@NotNull Object addon, @NotNull Object listener) {
        List<EventHandler<?>> listenerHandlers;
        this.checkIfAddon(addon);
        List<Object> addonListeners = this.registeredAddonListeners.get(addon);
        if (addonListeners != null) {
            addonListeners.remove(listener);
            if (addonListeners.size() == 0) {
                this.registeredAddonListeners.remove(addon);
            }
        }
        if ((listenerHandlers = this.registeredListeners.remove(listener)) != null && listenerHandlers.size() > 0) {
            this.removeHandlers(listenerHandlers);
        }
    }

    @Override
    public void unregister(@NotNull Object addon, @NotNull EventHandler<?> handler) {
        this.checkIfAddon(addon);
        List<EventHandler<?>> addonHandlers = this.registeredAddonHandlers.get(addon);
        addonHandlers.remove(handler);
        if (addonHandlers.size() == 0) {
            this.registeredAddonHandlers.remove(addon);
        }
        this.removeHandlers((List<EventHandler<?>>)ImmutableList.of(handler));
    }

    private void checkIfAddon(@NotNull Object addon) {
        this.voice.getAddonManager().getAddon(addon).orElseThrow(() -> new IllegalArgumentException("object " + addon.getClass() + " is not annotated with @Addon"));
    }

    private void removeHandlers(List<EventHandler<?>> handlersToRemove) {
        ArrayList eventsToRemove = new ArrayList();
        this.handlers.forEach((eventClass, listeners) -> {
            ArrayList listenersToRemove = new ArrayList();
            listeners.forEach((priority, handlers) -> {
                handlers.removeAll(handlersToRemove);
                if (handlers.size() == 0) {
                    listenersToRemove.add(priority);
                }
            });
            listenersToRemove.forEach(listeners::remove);
            if (listeners.size() == 0) {
                eventsToRemove.add(eventClass);
            }
        });
        eventsToRemove.forEach(this.handlers::remove);
    }

    private Annotation getAnnotation(AccessibleObject object, Class annotationClass) {
        for (Annotation a : object.getAnnotations()) {
            if (!a.annotationType().getCanonicalName().equals(annotationClass.getCanonicalName())) continue;
            return a;
        }
        return null;
    }

    private <T> T getAnnotationFieldWithReflection(Annotation annotation, String fieldName) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        return (T)annotation.annotationType().getMethod(fieldName, new Class[0]).invoke((Object)annotation, new Object[0]);
    }
}

