/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.proto.data.audio.codec.opus;

import com.google.common.io.ByteArrayDataOutput;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import su.plo.voice.libs.kotlin.Metadata;
import su.plo.voice.libs.kotlin.jvm.internal.Intrinsics;
import su.plo.voice.libs.kotlin.jvm.internal.MutablePropertyReference1Impl;
import su.plo.voice.libs.kotlin.jvm.internal.Reflection;
import su.plo.voice.libs.kotlin.jvm.internal.SourceDebugExtension;
import su.plo.voice.libs.kotlin.properties.Delegates;
import su.plo.voice.libs.kotlin.properties.ReadWriteProperty;
import su.plo.voice.libs.kotlin.reflect.KProperty;
import su.plo.voice.proto.data.audio.codec.CodecInfo;
import su.plo.voice.proto.data.audio.codec.opus.OpusMode;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u000f\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0010\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R+\u0010\u0004\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00058F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001c"}, d2={"Lsu/plo/voice/proto/data/audio/codec/opus/OpusEncoderInfo;", "Lsu/plo/voice/proto/data/audio/codec/CodecInfo;", "mode", "Lsu/plo/voice/proto/data/audio/codec/opus/OpusMode;", "bitrate", "", "(Lsu/plo/voice/proto/data/audio/codec/opus/OpusMode;I)V", "codecInfo", "(Lsu/plo/voice/proto/data/audio/codec/CodecInfo;)V", "<set-?>", "getBitrate", "()I", "setBitrate", "(I)V", "bitrate$delegate", "Lsu/plo/voice/libs/kotlin/properties/ReadWriteProperty;", "getMode", "()Lsu/plo/voice/proto/data/audio/codec/opus/OpusMode;", "setMode", "(Lsu/plo/voice/proto/data/audio/codec/opus/OpusMode;)V", "serialize", "", "out", "Lcom/google/common/io/ByteArrayDataOutput;", "validateBitrate", "validateStringBitrate", "rawBitrate", "", "protocol"})
@SourceDebugExtension(value={"SMAP\nOpusEncoderInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpusEncoderInfo.kt\nsu/plo/voice/proto/data/audio/codec/opus/OpusEncoderInfo\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,76:1\n1#2:77\n*E\n"})
public final class OpusEncoderInfo
extends CodecInfo {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private OpusMode mode;
    @NotNull
    private final ReadWriteProperty bitrate$delegate;

    public OpusEncoderInfo(@NotNull OpusMode mode, int bitrate) {
        Intrinsics.checkNotNullParameter((Object)mode, "mode");
        this.bitrate$delegate = Delegates.INSTANCE.notNull();
        this.name = "opus";
        this.mode = mode;
        this.setBitrate(this.validateBitrate(bitrate));
    }

    public OpusEncoderInfo(@NotNull CodecInfo codecInfo) throws IOException {
        String it;
        OpusEncoderInfo opusEncoderInfo;
        Object object;
        block6: {
            block5: {
                Intrinsics.checkNotNullParameter(codecInfo, "codecInfo");
                this.bitrate$delegate = Delegates.INSTANCE.notNull();
                this.name = "opus";
                if (!Intrinsics.areEqual(codecInfo.getName(), "opus")) {
                    throw new IOException("name is not opus");
                }
                OpusEncoderInfo opusEncoderInfo2 = this;
                object = codecInfo.getParams().get("mode");
                if (object == null) break block5;
                String string = object;
                opusEncoderInfo = opusEncoderInfo2;
                boolean bl = false;
                OpusMode opusMode = OpusMode.valueOf(it);
                opusEncoderInfo2 = opusEncoderInfo;
                object = opusMode;
                if (opusMode != null) break block6;
            }
            throw new IOException("mode not found in params");
        }
        opusEncoderInfo2.mode = object;
        String string = codecInfo.getParams().get("bitrate");
        if (string == null) {
            throw new IOException("bad opus bitrate");
        }
        it = string;
        opusEncoderInfo = this;
        boolean bl = false;
        int n = this.validateStringBitrate(it);
        opusEncoderInfo.setBitrate(n);
    }

    @NotNull
    public final OpusMode getMode() {
        return this.mode;
    }

    public final void setMode(@NotNull OpusMode opusMode) {
        Intrinsics.checkNotNullParameter((Object)opusMode, "<set-?>");
        this.mode = opusMode;
    }

    public final int getBitrate() {
        return ((Number)this.bitrate$delegate.getValue(this, $$delegatedProperties[0])).intValue();
    }

    public final void setBitrate(int n) {
        this.bitrate$delegate.setValue(this, $$delegatedProperties[0], n);
    }

    @Override
    public void serialize(@NotNull ByteArrayDataOutput out) {
        Intrinsics.checkNotNullParameter(out, "out");
        out.writeUTF("opus");
        out.writeInt(2);
        out.writeUTF("mode");
        out.writeUTF(this.mode.toString());
        out.writeUTF("bitrate");
        out.writeUTF(String.valueOf(this.getBitrate()));
    }

    private final int validateStringBitrate(String rawBitrate) {
        int n;
        try {
            int bitrate = Integer.parseInt(rawBitrate);
            if (bitrate < 0) {
                if (bitrate != -1 && bitrate != -1000) {
                    bitrate = -1000;
                }
            } else if (bitrate > 512000) {
                bitrate = 512000;
            }
        }
        catch (NumberFormatException ignored) {
            n = -1000;
        }
        return n;
    }

    private final int validateBitrate(int bitrate) {
        if (bitrate < 0) {
            if (bitrate != -1 && bitrate != -1000) {
                return -1000;
            }
        } else if (bitrate > 512000) {
            return 512000;
        }
        return bitrate;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1(new MutablePropertyReference1Impl(OpusEncoderInfo.class, "bitrate", "getBitrate()I", 0))};
        $$delegatedProperties = kPropertyArray;
    }
}

