/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.server;

import com.google.common.base.Preconditions;
import com.mojang.brigadier.CommandDispatcher;
import java.io.File;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.S2CPlayChannelEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.util.TriState;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_9139;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import su.plo.lib.api.server.MinecraftServerLib;
import su.plo.lib.api.server.event.player.PlayerJoinEvent;
import su.plo.lib.api.server.event.player.PlayerQuitEvent;
import su.plo.lib.api.server.permission.PermissionDefault;
import su.plo.lib.api.server.permission.PermissionTristate;
import su.plo.lib.mod.server.ModServerLib;
import su.plo.voice.codec.PacketServicePayload;
import su.plo.voice.codec.PacketServicePayloadCodec;
import su.plo.voice.codec.PacketTcpPayload;
import su.plo.voice.codec.PacketTcpPayloadCodec;
import su.plo.voice.server.BaseVoiceServer;
import su.plo.voice.server.connection.ModServerChannelHandler;
import su.plo.voice.server.connection.ModServerServiceChannelHandler;
import su.plo.voice.server.player.PermissionSupplier;
import su.plo.voice.util.version.ModrinthLoader;

public final class ModVoiceServer
extends BaseVoiceServer {
    public static final class_2960 CHANNEL = class_2960.method_12829((String)"plasmo:voice/v2");
    public static final class_2960 FLAG_CHANNEL = class_2960.method_12829((String)"plasmo:voice/v2/installed");
    public static final class_2960 SERVICE_CHANNEL = class_2960.method_12829((String)"plasmo:voice/v2/service");
    private final String modId = "plasmovoice";
    private final ModServerLib minecraftServerLib = new ModServerLib(this::getLanguages);
    private MinecraftServer server;
    private ModServerChannelHandler handler;
    private ModServerServiceChannelHandler serviceHandler;

    public ModVoiceServer(@NotNull ModrinthLoader loader) {
        super(loader);
    }

    private void onInitialize(MinecraftServer server) {
        this.server = server;
        this.minecraftServerLib.setServer(server);
        this.minecraftServerLib.setPermissions(this.createPermissionSupplier());
        this.minecraftServerLib.onInitialize();
        super.onInitialize();
    }

    private void onShutdown(MinecraftServer server) {
        super.onShutdown();
        this.server = null;
        this.minecraftServerLib.onShutdown();
        this.handler.clear();
    }

    private void onCommandRegister(@NotNull CommandDispatcher<class_2168> dispatcher) {
        this.registerDefaultCommandsAndPermissions();
        this.minecraftServerLib.getCommandManager().registerCommands(dispatcher);
    }

    @Override
    @NotNull
    public File getConfigFolder() {
        return new File("config/plasmovoice/server");
    }

    @Override
    @NotNull
    public File getConfigsFolder() {
        return new File("config");
    }

    @Override
    @NotNull
    public MinecraftServerLib getMinecraftServer() {
        return this.minecraftServerLib;
    }

    @Override
    public void onInitialize() {
        PayloadTypeRegistry.playC2S().register(PacketTcpPayload.TYPE, (class_9139)new PacketTcpPayloadCodec());
        PayloadTypeRegistry.playS2C().register(PacketTcpPayload.TYPE, (class_9139)new PacketTcpPayloadCodec());
        PayloadTypeRegistry.playC2S().register(PacketServicePayload.TYPE, (class_9139)new PacketServicePayloadCodec());
        PayloadTypeRegistry.playS2C().register(PacketServicePayload.TYPE, (class_9139)new PacketServicePayloadCodec());
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            if (this.handler == null) {
                this.handler = new ModServerChannelHandler(this);
                S2CPlayChannelEvents.REGISTER.register((Object)this.handler);
                ServerPlayNetworking.registerGlobalReceiver(PacketTcpPayload.TYPE, (ServerPlayNetworking.PlayPayloadHandler)this.handler);
            }
            if (this.serviceHandler == null) {
                this.serviceHandler = new ModServerServiceChannelHandler(this);
                ServerPlayNetworking.registerGlobalReceiver(PacketServicePayload.TYPE, (ServerPlayNetworking.PlayPayloadHandler)this.serviceHandler);
            }
            this.onInitialize(server);
            this.eventBus.register(this, this.handler);
        });
        ServerLifecycleEvents.SERVER_STOPPING.register(this::onShutdown);
        ServerPlayConnectionEvents.JOIN.register((handler, sender, mcServer) -> ((PlayerJoinEvent.Callback)PlayerJoinEvent.INSTANCE.getInvoker()).onPlayerJoin(this.minecraftServerLib.getPlayerByInstance(handler.method_32311())));
        ServerPlayConnectionEvents.DISCONNECT.register((handler, mcServer) -> ((PlayerQuitEvent.Callback)PlayerQuitEvent.INSTANCE.getInvoker()).onPlayerQuit(this.minecraftServerLib.getPlayerByInstance(handler.method_32311())));
        CommandRegistrationCallback.EVENT.register((dispatcher, dedicated, selection) -> this.onCommandRegister((CommandDispatcher<class_2168>)dispatcher));
    }

    @Override
    @NotNull
    public String getVersion() {
        ModContainer modContainer = FabricLoader.getInstance().getModContainer("plasmovoice").orElse(null);
        Preconditions.checkNotNull((Object)modContainer, (Object)"modContainer cannot be null");
        return modContainer.getMetadata().getVersion().getFriendlyString();
    }

    @Override
    protected PermissionSupplier createPermissionSupplier() {
        return new PermissionSupplier(){

            @Override
            public boolean hasPermission(@NotNull Object player, @NotNull String permission) {
                if (!(player instanceof class_3222)) {
                    throw new IllegalArgumentException("player is not " + String.valueOf(class_3222.class));
                }
                class_3222 serverPlayer = (class_3222)player;
                PermissionDefault permissionDefault = ModVoiceServer.this.minecraftServerLib.getPermissionsManager().getPermissionDefault(permission);
                boolean isOp = ModVoiceServer.this.server.method_3760().method_14569(serverPlayer.method_7334());
                return this.getPermission(serverPlayer, permission).booleanValue(permissionDefault.getValue(isOp));
            }

            @Override
            @NotNull
            public PermissionTristate getPermission(@NotNull Object player, @NotNull String permission) {
                if (!(player instanceof class_3222)) {
                    throw new IllegalArgumentException("player is not " + String.valueOf(class_3222.class));
                }
                class_3222 serverPlayer = (class_3222)player;
                return this.toPermissionTristate(Permissions.getPermissionValue((class_1297)serverPlayer, (String)permission));
            }

            private PermissionTristate toPermissionTristate(TriState triState) {
                return switch (triState) {
                    default -> throw new MatchException(null, null);
                    case TriState.TRUE -> PermissionTristate.TRUE;
                    case TriState.FALSE -> PermissionTristate.FALSE;
                    case TriState.DEFAULT -> PermissionTristate.UNDEFINED;
                };
            }
        };
    }
}

