/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.server.audio.line;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import su.plo.voice.api.addon.AddonContainer;
import su.plo.voice.api.server.PlasmoBaseVoiceServer;
import su.plo.voice.api.server.audio.line.BaseServerSourceLine;
import su.plo.voice.api.server.audio.line.BaseServerSourceLineManager;
import su.plo.voice.api.server.audio.line.ServerSourceLinePlayersSets;
import su.plo.voice.api.server.connection.ConnectionManager;
import su.plo.voice.api.server.player.VoicePlayer;
import su.plo.voice.libs.kotlin.Metadata;
import su.plo.voice.libs.kotlin.jvm.internal.Intrinsics;
import su.plo.voice.libs.kotlin.jvm.internal.SourceDebugExtension;
import su.plo.voice.proto.data.audio.capture.VoiceActivation;
import su.plo.voice.proto.data.audio.line.SourceLine;
import su.plo.voice.proto.data.audio.line.VoiceSourceLine;
import su.plo.voice.proto.packets.tcp.clientbound.ClientPacketTcpHandler;
import su.plo.voice.proto.packets.tcp.clientbound.SourceLineUnregisterPacket;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001,B#\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0014\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\b\u0001\u0012\u00020\t0\u0007\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0014\u001a\u00020\u0015H\u0016J6\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016JE\u0010 \u001a\u00028\u00002\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H$\u00a2\u0006\u0002\u0010'J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000(2\u0006\u0010)\u001a\u00020\rH\u0016J\u0016\u0010*\u001a\b\u0012\u0004\u0012\u00028\u00000(2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010+\u001a\u00020$2\u0006\u0010)\u001a\u00020\rH\u0016J\u0010\u0010+\u001a\u00020$2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R \u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00028\u00000\fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\b\u0001\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lsu/plo/voice/server/audio/line/VoiceBaseServerSourceLineManager;", "T", "Lsu/plo/voice/api/server/audio/line/BaseServerSourceLine;", "Lsu/plo/voice/api/server/audio/line/BaseServerSourceLineManager;", "voiceServer", "Lsu/plo/voice/api/server/PlasmoBaseVoiceServer;", "tcpConnections", "Lsu/plo/voice/api/server/connection/ConnectionManager;", "Lsu/plo/voice/proto/packets/tcp/clientbound/ClientPacketTcpHandler;", "Lsu/plo/voice/api/server/player/VoicePlayer;", "(Lsu/plo/voice/api/server/PlasmoBaseVoiceServer;Lsu/plo/voice/api/server/connection/ConnectionManager;)V", "lineById", "", "Ljava/util/UUID;", "getLineById", "()Ljava/util/Map;", "lines", "", "getLines", "()Ljava/util/Collection;", "clear", "", "createBuilder", "Lsu/plo/voice/api/server/audio/line/BaseServerSourceLine$Builder;", "addonObject", "", "name", "", "translation", "icon", "weight", "", "createSourceLine", "addon", "Lsu/plo/voice/api/addon/AddonContainer;", "withPlayers", "", "defaultVolume", "", "(Lsu/plo/voice/api/addon/AddonContainer;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;IZD)Lsu/plo/voice/api/server/audio/line/BaseServerSourceLine;", "Ljava/util/Optional;", "id", "getLineByName", "unregister", "Builder", "server-common"})
@SourceDebugExtension(value={"SMAP\nVoiceBaseServerSourceLineManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VoiceBaseServerSourceLineManager.kt\nsu/plo/voice/server/audio/line/VoiceBaseServerSourceLineManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,119:1\n1#2:120\n1855#3,2:121\n*S KotlinDebug\n*F\n+ 1 VoiceBaseServerSourceLineManager.kt\nsu/plo/voice/server/audio/line/VoiceBaseServerSourceLineManager\n*L\n49#1:121,2\n*E\n"})
public abstract class VoiceBaseServerSourceLineManager<T extends BaseServerSourceLine>
implements BaseServerSourceLineManager<T> {
    @NotNull
    private final PlasmoBaseVoiceServer voiceServer;
    @NotNull
    private final ConnectionManager<ClientPacketTcpHandler, ? extends VoicePlayer> tcpConnections;
    @NotNull
    private final Map<UUID, T> lineById;

    public VoiceBaseServerSourceLineManager(@NotNull PlasmoBaseVoiceServer voiceServer, @NotNull ConnectionManager<ClientPacketTcpHandler, ? extends VoicePlayer> tcpConnections) {
        Intrinsics.checkNotNullParameter(voiceServer, "voiceServer");
        Intrinsics.checkNotNullParameter(tcpConnections, "tcpConnections");
        this.voiceServer = voiceServer;
        this.tcpConnections = tcpConnections;
        ConcurrentMap concurrentMap = Maps.newConcurrentMap();
        Intrinsics.checkNotNullExpressionValue(concurrentMap, "newConcurrentMap(...)");
        this.lineById = concurrentMap;
    }

    @NotNull
    protected final Map<UUID, T> getLineById() {
        return this.lineById;
    }

    @Override
    @NotNull
    public Collection<T> getLines() {
        return this.lineById.values();
    }

    @Override
    @NotNull
    public Optional<T> getLineById(@NotNull UUID id) {
        Intrinsics.checkNotNullParameter(id, "id");
        Optional<T> optional = Optional.ofNullable(this.lineById.get(id));
        Intrinsics.checkNotNullExpressionValue(optional, "ofNullable(...)");
        return optional;
    }

    @Override
    @NotNull
    public Optional<T> getLineByName(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        Optional<T> optional = Optional.ofNullable(this.lineById.get(VoiceSourceLine.generateId(name)));
        Intrinsics.checkNotNullExpressionValue(optional, "ofNullable(...)");
        return optional;
    }

    @Override
    public boolean unregister(@NotNull UUID id) {
        Intrinsics.checkNotNullParameter(id, "id");
        BaseServerSourceLine baseServerSourceLine = (BaseServerSourceLine)this.lineById.remove(id);
        if (baseServerSourceLine != null) {
            BaseServerSourceLine line = baseServerSourceLine;
            boolean bl = false;
            line.clear();
            ServerSourceLinePlayersSets serverSourceLinePlayersSets = line.getPlayersSets();
            if (serverSourceLinePlayersSets != null) {
                ServerSourceLinePlayersSets it = serverSourceLinePlayersSets;
                boolean bl2 = false;
                this.voiceServer.getEventBus().unregister((Object)this.voiceServer, it);
            }
            this.tcpConnections.broadcast(new SourceLineUnregisterPacket(id));
            return true;
        }
        return false;
    }

    @Override
    public boolean unregister(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        UUID uUID = VoiceSourceLine.generateId(name);
        Intrinsics.checkNotNullExpressionValue(uUID, "generateId(...)");
        return this.unregister(uUID);
    }

    @Override
    public void clear() {
        ArrayList arrayList = Lists.newArrayList((Iterable)this.lineById.values());
        Intrinsics.checkNotNullExpressionValue(arrayList, "newArrayList(...)");
        Iterable $this$forEach$iv = arrayList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BaseServerSourceLine p0 = (BaseServerSourceLine)element$iv;
            boolean bl = false;
            this.unregister((SourceLine)p0);
        }
        this.lineById.clear();
    }

    @Override
    @NotNull
    public BaseServerSourceLine.Builder<T> createBuilder(@NotNull Object addonObject, @NotNull String name, @NotNull String translation, @NotNull String icon, int weight) {
        Intrinsics.checkNotNullParameter(addonObject, "addonObject");
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(translation, "translation");
        Intrinsics.checkNotNullParameter(icon, "icon");
        AddonContainer addon = this.voiceServer.getAddonManager().getAddon(addonObject).orElseThrow(VoiceBaseServerSourceLineManager::createBuilder$lambda$2);
        if (this.lineById.containsKey(VoiceActivation.generateId(name))) {
            throw new IllegalArgumentException("Activation with name " + name + " already exists");
        }
        Intrinsics.checkNotNull(addon);
        return new Builder(addon, name, translation, icon, weight);
    }

    @NotNull
    protected abstract T createSourceLine(@NotNull AddonContainer var1, @NotNull String var2, @NotNull String var3, @NotNull String var4, int var5, boolean var6, double var7);

    private static final IllegalArgumentException createBuilder$lambda$2() {
        return new IllegalArgumentException("addonObject is not an addon");
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\b\u0012\u0004\u0012\u00028\u00000\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\r\u0010\u000f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0010J\u001a\u0010\u0011\u001a\f0\u0000R\b\u0012\u0004\u0012\u00028\u00000\u00122\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001a\u0010\r\u001a\f0\u0000R\b\u0012\u0004\u0012\u00028\u00000\u00122\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lsu/plo/voice/server/audio/line/VoiceBaseServerSourceLineManager$Builder;", "Lsu/plo/voice/api/server/audio/line/BaseServerSourceLine$Builder;", "addon", "Lsu/plo/voice/api/addon/AddonContainer;", "name", "", "translation", "icon", "weight", "", "(Lsu/plo/voice/server/audio/line/VoiceBaseServerSourceLineManager;Lsu/plo/voice/api/addon/AddonContainer;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;I)V", "defaultVolume", "", "withPlayers", "", "build", "()Lsu/plo/voice/api/server/audio/line/BaseServerSourceLine;", "setDefaultVolume", "Lsu/plo/voice/server/audio/line/VoiceBaseServerSourceLineManager;", "server-common"})
    @SourceDebugExtension(value={"SMAP\nVoiceBaseServerSourceLineManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VoiceBaseServerSourceLineManager.kt\nsu/plo/voice/server/audio/line/VoiceBaseServerSourceLineManager$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,119:1\n1#2:120\n*E\n"})
    public final class Builder
    implements BaseServerSourceLine.Builder<T> {
        @NotNull
        private final AddonContainer addon;
        @NotNull
        private final String name;
        @NotNull
        private final String translation;
        @NotNull
        private final String icon;
        private final int weight;
        private boolean withPlayers;
        private double defaultVolume;

        public Builder(@NotNull AddonContainer addon, @NotNull String name, @NotNull String translation, String icon, int weight) {
            Intrinsics.checkNotNullParameter(addon, "addon");
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter(translation, "translation");
            Intrinsics.checkNotNullParameter(icon, "icon");
            this.addon = addon;
            this.name = name;
            this.translation = translation;
            this.icon = icon;
            this.weight = weight;
            this.defaultVolume = 1.0;
        }

        @NotNull
        public Builder withPlayers(boolean withPlayers) {
            Builder builder;
            Builder $this$withPlayers_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$withPlayers_u24lambda_u240.withPlayers = withPlayers;
            return builder;
        }

        @NotNull
        public Builder setDefaultVolume(double defaultVolume) {
            Builder builder;
            Builder $this$setDefaultVolume_u24lambda_u241 = builder = this;
            boolean bl = false;
            $this$setDefaultVolume_u24lambda_u241.defaultVolume = defaultVolume;
            return builder;
        }

        @Override
        @NotNull
        public T build() {
            if (VoiceBaseServerSourceLineManager.this.getLineById().containsKey(VoiceActivation.generateId(this.name))) {
                throw new IllegalArgumentException("Activation with name " + this.name + " already exists");
            }
            Object t = VoiceBaseServerSourceLineManager.this.createSourceLine(this.addon, this.name, this.translation, this.icon, this.weight, this.withPlayers, this.defaultVolume);
            VoiceBaseServerSourceLineManager voiceBaseServerSourceLineManager = VoiceBaseServerSourceLineManager.this;
            Object line = t;
            boolean bl = false;
            ServerSourceLinePlayersSets serverSourceLinePlayersSets = line.getPlayersSets();
            if (serverSourceLinePlayersSets != null) {
                ServerSourceLinePlayersSets it = serverSourceLinePlayersSets;
                boolean bl2 = false;
                voiceBaseServerSourceLineManager.voiceServer.getEventBus().register(voiceBaseServerSourceLineManager.voiceServer, it);
            }
            Map map2 = voiceBaseServerSourceLineManager.getLineById();
            UUID uUID = line.getId();
            Intrinsics.checkNotNullExpressionValue(uUID, "getId(...)");
            map2.put(uUID, line);
            return t;
        }
    }
}

