/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.compatibility.checks;

import me.jellysquid.mods.sodium.client.compatibility.checks.BugChecks;
import me.jellysquid.mods.sodium.client.compatibility.environment.probe.GraphicsAdapterInfo;
import me.jellysquid.mods.sodium.client.compatibility.environment.probe.GraphicsAdapterProbe;
import me.jellysquid.mods.sodium.client.compatibility.environment.probe.GraphicsAdapterVendor;
import me.jellysquid.mods.sodium.client.compatibility.workarounds.nvidia.NvidiaDriverVersion;
import me.jellysquid.mods.sodium.client.platform.MessageBox;
import me.jellysquid.mods.sodium.client.platform.windows.WindowsFileVersion;
import me.jellysquid.mods.sodium.client.platform.windows.api.d3dkmt.D3DKMT;
import me.jellysquid.mods.sodium.client.util.OsUtils;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreLaunchChecks {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Sodium-EarlyDriverScanner");

    public static void onGameInit() {
        WindowsFileVersion installedVersion;
        if (BugChecks.ISSUE_899 && (installedVersion = PreLaunchChecks.findIntelDriverMatchingBug899()) != null) {
            PreLaunchChecks.showUnsupportedDriverMessageBox("The game failed to start because the currently installed Intel Graphics Driver is not compatible.\n\nInstalled version: ###CURRENT_DRIVER###\nRequired version: 10.18.10.5161 (or newer)\n\nYou must update your graphics card driver in order to continue.".replace("###CURRENT_DRIVER###", NvidiaDriverVersion.parse(installedVersion).toString()), "https://github.com/CaffeineMC/sodium-fabric/wiki/Driver-Compatibility#windows-intel-gen7");
        }
        if (BugChecks.ISSUE_1486 && (installedVersion = PreLaunchChecks.findNvidiaDriverMatchingBug1486()) != null) {
            PreLaunchChecks.showUnsupportedDriverMessageBox("The game failed to start because the currently installed NVIDIA Graphics Driver is not compatible.\n\nInstalled version: ###CURRENT_DRIVER###\nRequired version: 536.23 (or newer)\n\nYou must update your graphics card driver in order to continue.".replace("###CURRENT_DRIVER###", installedVersion.toString()), "https://github.com/CaffeineMC/sodium-fabric/wiki/Driver-Compatibility#nvidia-gpus");
        }
    }

    private static void showUnsupportedDriverMessageBox(String message, String url) {
        LOGGER.error("###ERROR_DESCRIPTION###\n\nFor more information, please see: ###HELP_URL###".replace("###ERROR_DESCRIPTION###", message).replace("###HELP_URL###", url));
        MessageBox.showMessageBox(null, MessageBox.IconType.ERROR, "Sodium Renderer - Unsupported Driver", message, url);
        System.exit(1);
    }

    @Nullable
    private static WindowsFileVersion findIntelDriverMatchingBug899() {
        if (OsUtils.getOs() != OsUtils.OperatingSystem.WIN) {
            return null;
        }
        for (GraphicsAdapterInfo graphicsAdapterInfo : GraphicsAdapterProbe.getAdapters()) {
            if (!(graphicsAdapterInfo instanceof D3DKMT.WDDMAdapterInfo)) continue;
            D3DKMT.WDDMAdapterInfo wddmAdapterInfo = (D3DKMT.WDDMAdapterInfo)graphicsAdapterInfo;
            String driverName = wddmAdapterInfo.getOpenGlIcdName();
            WindowsFileVersion driverVersion = wddmAdapterInfo.openglIcdVersion();
            if (!driverName.matches("ig7icd(32|64)") || driverVersion.z() != 10 || driverVersion.w() >= 5161) continue;
            return driverVersion;
        }
        return null;
    }

    @Nullable
    private static WindowsFileVersion findNvidiaDriverMatchingBug1486() {
        if (OsUtils.getOs() != OsUtils.OperatingSystem.WIN) {
            return null;
        }
        for (GraphicsAdapterInfo graphicsAdapterInfo : GraphicsAdapterProbe.getAdapters()) {
            D3DKMT.WDDMAdapterInfo wddmAdapterInfo;
            WindowsFileVersion driverVersion;
            if (graphicsAdapterInfo.vendor() != GraphicsAdapterVendor.NVIDIA || !(graphicsAdapterInfo instanceof D3DKMT.WDDMAdapterInfo) || (driverVersion = (wddmAdapterInfo = (D3DKMT.WDDMAdapterInfo)graphicsAdapterInfo).openglIcdVersion()).z() != 15 || driverVersion.w() < 2647 || driverVersion.w() >= 3623) continue;
            return driverVersion;
        }
        return null;
    }
}

