/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.compatibility.environment.probe;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import me.jellysquid.mods.sodium.client.compatibility.environment.probe.GraphicsAdapterInfo;
import me.jellysquid.mods.sodium.client.compatibility.environment.probe.GraphicsAdapterVendor;
import me.jellysquid.mods.sodium.client.platform.windows.api.d3dkmt.D3DKMT;
import me.jellysquid.mods.sodium.client.util.OsUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.util.ExecutingCommand;

public class GraphicsAdapterProbe {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Sodium-GraphicsAdapterProbe");
    private static List<? extends GraphicsAdapterInfo> ADAPTERS = List.of();

    public static void findAdapters() {
        List<? extends GraphicsAdapterInfo> adapters;
        LOGGER.info("Searching for graphics cards...");
        switch (OsUtils.getOs()) {
            case WIN: {
                List<? extends GraphicsAdapterInfo> list = GraphicsAdapterProbe.findAdapters$Windows();
                break;
            }
            case LINUX: {
                List<? extends GraphicsAdapterInfo> list = GraphicsAdapterProbe.findAdapters$Linux();
                break;
            }
            default: {
                List<? extends GraphicsAdapterInfo> list = adapters = null;
            }
        }
        if (adapters == null) {
            return;
        }
        if (adapters.isEmpty()) {
            LOGGER.warn("Could not find any graphics adapters! Probably the device is not on a bus we can probe, or there are no devices supporting 3D acceleration.");
        } else {
            for (GraphicsAdapterInfo graphicsAdapterInfo : adapters) {
                LOGGER.info("Found graphics adapter: {}", (Object)graphicsAdapterInfo);
            }
        }
        ADAPTERS = adapters;
    }

    private static List<? extends GraphicsAdapterInfo> findAdapters$Windows() {
        return D3DKMT.findGraphicsAdapters();
    }

    private static List<? extends GraphicsAdapterInfo> findAdapters$Linux() {
        ArrayList<GraphicsAdapterInfo.LinuxPciAdapterInfo> results = new ArrayList<GraphicsAdapterInfo.LinuxPciAdapterInfo>();
        try (Stream<Path> devices = Files.list(Path.of("/sys/bus/pci/devices/", new String[0]));){
            Iterable devicesIter = devices::iterator;
            for (Path devicePath : devicesIter) {
                String deviceClass = Files.readString(devicePath.resolve("class")).trim();
                if (!deviceClass.equals("0x030000") && !deviceClass.equals("0x030200")) continue;
                String pciVendorId = Files.readString(devicePath.resolve("vendor")).trim();
                String pciDeviceId = Files.readString(devicePath.resolve("device")).trim();
                String name = ExecutingCommand.runNative((String)("lspci -vmm -d " + pciVendorId.substring(2) + ":" + pciDeviceId.substring(2))).stream().filter(line -> line.startsWith("Device:")).map(line -> line.substring("Device:".length()).trim()).findFirst().orElse("unknown");
                GraphicsAdapterVendor vendor = GraphicsAdapterVendor.fromPciVendorId(pciVendorId);
                GraphicsAdapterInfo.LinuxPciAdapterInfo info = new GraphicsAdapterInfo.LinuxPciAdapterInfo(vendor, name, pciVendorId, pciDeviceId);
                results.add(info);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return results;
    }

    public static Collection<? extends GraphicsAdapterInfo> getAdapters() {
        if (ADAPTERS == null) {
            throw new RuntimeException("Graphics adapters not probed yet");
        }
        return ADAPTERS;
    }
}

