/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.util;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.sk89q.worldedit.util.SideEffect;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class SideEffectSet {
    private static final SideEffectSet DEFAULT = new SideEffectSet((Map<SideEffect, SideEffect.State>)ImmutableMap.of());
    private static final SideEffectSet NONE = new SideEffectSet(Arrays.stream(SideEffect.values()).filter(SideEffect::isExposed).collect(Collectors.toMap(Function.identity(), state -> SideEffect.State.OFF)));
    private final Map<SideEffect, SideEffect.State> sideEffects;
    private final Set<SideEffect> appliedSideEffects;
    private final boolean appliesAny;

    public SideEffectSet(Map<SideEffect, SideEffect.State> sideEffects) {
        this.sideEffects = Maps.immutableEnumMap(sideEffects);
        this.appliedSideEffects = sideEffects.entrySet().stream().filter(entry -> entry.getValue() != SideEffect.State.OFF).map(Map.Entry::getKey).collect(Collectors.toSet());
        this.appliesAny = !this.appliedSideEffects.isEmpty();
    }

    public SideEffectSet with(SideEffect sideEffect, SideEffect.State state) {
        EnumMap<Object, Object> entries = this.sideEffects.isEmpty() ? Maps.newEnumMap(SideEffect.class) : new EnumMap<SideEffect, SideEffect.State>(this.sideEffects);
        entries.put((Object)sideEffect, (Object)state);
        return new SideEffectSet((Map<SideEffect, SideEffect.State>)entries);
    }

    public boolean doesApplyAny() {
        return this.appliesAny;
    }

    public SideEffect.State getState(SideEffect effect) {
        return this.sideEffects.getOrDefault((Object)effect, effect.getDefaultValue());
    }

    public boolean shouldApply(SideEffect effect) {
        return this.getState(effect) != SideEffect.State.OFF;
    }

    public Set<SideEffect> getSideEffectsToApply() {
        return this.appliedSideEffects;
    }

    public static SideEffectSet defaults() {
        return DEFAULT;
    }

    public static SideEffectSet none() {
        return NONE;
    }
}

